/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OpenSearch reserved instances recommendation details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchReservedInstances implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchReservedInstances.Builder, OpenSearchReservedInstances> {
    private static final SdkField<OpenSearchReservedInstancesConfiguration> CONFIGURATION_FIELD = SdkField
            .<OpenSearchReservedInstancesConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(OpenSearchReservedInstances::configuration)).setter(setter(Builder::configuration))
            .constructor(OpenSearchReservedInstancesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<ReservedInstancesCostCalculation> COST_CALCULATION_FIELD = SdkField
            .<ReservedInstancesCostCalculation> builder(MarshallingType.SDK_POJO).memberName("costCalculation")
            .getter(getter(OpenSearchReservedInstances::costCalculation)).setter(setter(Builder::costCalculation))
            .constructor(ReservedInstancesCostCalculation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            COST_CALCULATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final OpenSearchReservedInstancesConfiguration configuration;

    private final ReservedInstancesCostCalculation costCalculation;

    private OpenSearchReservedInstances(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    /**
     * <p>
     * The OpenSearch reserved instances configuration used for recommendations.
     * </p>
     * 
     * @return The OpenSearch reserved instances configuration used for recommendations.
     */
    public final OpenSearchReservedInstancesConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Cost impact of the purchase recommendation.
     * </p>
     * 
     * @return Cost impact of the purchase recommendation.
     */
    public final ReservedInstancesCostCalculation costCalculation() {
        return costCalculation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(costCalculation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchReservedInstances)) {
            return false;
        }
        OpenSearchReservedInstances other = (OpenSearchReservedInstances) obj;
        return Objects.equals(configuration(), other.configuration())
                && Objects.equals(costCalculation(), other.costCalculation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchReservedInstances").add("Configuration", configuration())
                .add("CostCalculation", costCalculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "costCalculation":
            return Optional.ofNullable(clazz.cast(costCalculation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchReservedInstances, T> g) {
        return obj -> g.apply((OpenSearchReservedInstances) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchReservedInstances> {
        /**
         * <p>
         * The OpenSearch reserved instances configuration used for recommendations.
         * </p>
         * 
         * @param configuration
         *        The OpenSearch reserved instances configuration used for recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(OpenSearchReservedInstancesConfiguration configuration);

        /**
         * <p>
         * The OpenSearch reserved instances configuration used for recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OpenSearchReservedInstancesConfiguration.Builder} avoiding the need to create one manually via
         * {@link OpenSearchReservedInstancesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchReservedInstancesConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #configuration(OpenSearchReservedInstancesConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link OpenSearchReservedInstancesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(OpenSearchReservedInstancesConfiguration)
         */
        default Builder configuration(Consumer<OpenSearchReservedInstancesConfiguration.Builder> configuration) {
            return configuration(OpenSearchReservedInstancesConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Cost impact of the purchase recommendation.
         * </p>
         * 
         * @param costCalculation
         *        Cost impact of the purchase recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCalculation(ReservedInstancesCostCalculation costCalculation);

        /**
         * <p>
         * Cost impact of the purchase recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservedInstancesCostCalculation.Builder}
         * avoiding the need to create one manually via {@link ReservedInstancesCostCalculation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedInstancesCostCalculation.Builder#build()} is called
         * immediately and its result is passed to {@link #costCalculation(ReservedInstancesCostCalculation)}.
         * 
         * @param costCalculation
         *        a consumer that will call methods on {@link ReservedInstancesCostCalculation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCalculation(ReservedInstancesCostCalculation)
         */
        default Builder costCalculation(Consumer<ReservedInstancesCostCalculation.Builder> costCalculation) {
            return costCalculation(ReservedInstancesCostCalculation.builder().applyMutation(costCalculation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpenSearchReservedInstancesConfiguration configuration;

        private ReservedInstancesCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchReservedInstances model) {
            configuration(model.configuration);
            costCalculation(model.costCalculation);
        }

        public final OpenSearchReservedInstancesConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(OpenSearchReservedInstancesConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(OpenSearchReservedInstancesConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ReservedInstancesCostCalculation.Builder getCostCalculation() {
            return costCalculation != null ? costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(ReservedInstancesCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(ReservedInstancesCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        @Override
        public OpenSearchReservedInstances build() {
            return new OpenSearchReservedInstances(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
