/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SageMaker Savings Plans configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SageMakerSavingsPlansConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SageMakerSavingsPlansConfiguration.Builder, SageMakerSavingsPlansConfiguration> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountScope").getter(getter(SageMakerSavingsPlansConfiguration::accountScope))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountScope").build()).build();

    private static final SdkField<String> HOURLY_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hourlyCommitment").getter(getter(SageMakerSavingsPlansConfiguration::hourlyCommitment))
            .setter(setter(Builder::hourlyCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hourlyCommitment").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(SageMakerSavingsPlansConfiguration::paymentOption))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<String> TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("term")
            .getter(getter(SageMakerSavingsPlansConfiguration::term)).setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            HOURLY_COMMITMENT_FIELD, PAYMENT_OPTION_FIELD, TERM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String hourlyCommitment;

    private final String paymentOption;

    private final String term;

    private SageMakerSavingsPlansConfiguration(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.hourlyCommitment = builder.hourlyCommitment;
        this.paymentOption = builder.paymentOption;
        this.term = builder.term;
    }

    /**
     * <p>
     * The account scope that you want your recommendations for.
     * </p>
     * 
     * @return The account scope that you want your recommendations for.
     */
    public final String accountScope() {
        return accountScope;
    }

    /**
     * <p>
     * The hourly commitment for the Savings Plans type.
     * </p>
     * 
     * @return The hourly commitment for the Savings Plans type.
     */
    public final String hourlyCommitment() {
        return hourlyCommitment;
    }

    /**
     * <p>
     * The payment option for the commitment.
     * </p>
     * 
     * @return The payment option for the commitment.
     */
    public final String paymentOption() {
        return paymentOption;
    }

    /**
     * <p>
     * The Savings Plans recommendation term in years.
     * </p>
     * 
     * @return The Savings Plans recommendation term in years.
     */
    public final String term() {
        return term;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScope());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerSavingsPlansConfiguration)) {
            return false;
        }
        SageMakerSavingsPlansConfiguration other = (SageMakerSavingsPlansConfiguration) obj;
        return Objects.equals(accountScope(), other.accountScope())
                && Objects.equals(hourlyCommitment(), other.hourlyCommitment())
                && Objects.equals(paymentOption(), other.paymentOption()) && Objects.equals(term(), other.term());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SageMakerSavingsPlansConfiguration").add("AccountScope", accountScope())
                .add("HourlyCommitment", hourlyCommitment()).add("PaymentOption", paymentOption()).add("Term", term()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountScope":
            return Optional.ofNullable(clazz.cast(accountScope()));
        case "hourlyCommitment":
            return Optional.ofNullable(clazz.cast(hourlyCommitment()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOption()));
        case "term":
            return Optional.ofNullable(clazz.cast(term()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SageMakerSavingsPlansConfiguration, T> g) {
        return obj -> g.apply((SageMakerSavingsPlansConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SageMakerSavingsPlansConfiguration> {
        /**
         * <p>
         * The account scope that you want your recommendations for.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The hourly commitment for the Savings Plans type.
         * </p>
         * 
         * @param hourlyCommitment
         *        The hourly commitment for the Savings Plans type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyCommitment(String hourlyCommitment);

        /**
         * <p>
         * The payment option for the commitment.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The Savings Plans recommendation term in years.
         * </p>
         * 
         * @param term
         *        The Savings Plans recommendation term in years.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(String term);
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String hourlyCommitment;

        private String paymentOption;

        private String term;

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerSavingsPlansConfiguration model) {
            accountScope(model.accountScope);
            hourlyCommitment(model.hourlyCommitment);
            paymentOption(model.paymentOption);
            term(model.term);
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        public final String getHourlyCommitment() {
            return hourlyCommitment;
        }

        public final void setHourlyCommitment(String hourlyCommitment) {
            this.hourlyCommitment = hourlyCommitment;
        }

        @Override
        public final Builder hourlyCommitment(String hourlyCommitment) {
            this.hourlyCommitment = hourlyCommitment;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        public final String getTerm() {
            return term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        @Override
        public SageMakerSavingsPlansConfiguration build() {
            return new SageMakerSavingsPlansConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
