/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EC2 instance Savings Plans recommendation details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2InstanceSavingsPlans implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2InstanceSavingsPlans.Builder, Ec2InstanceSavingsPlans> {
    private static final SdkField<Ec2InstanceSavingsPlansConfiguration> CONFIGURATION_FIELD = SdkField
            .<Ec2InstanceSavingsPlansConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(Ec2InstanceSavingsPlans::configuration)).setter(setter(Builder::configuration))
            .constructor(Ec2InstanceSavingsPlansConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<SavingsPlansCostCalculation> COST_CALCULATION_FIELD = SdkField
            .<SavingsPlansCostCalculation> builder(MarshallingType.SDK_POJO).memberName("costCalculation")
            .getter(getter(Ec2InstanceSavingsPlans::costCalculation)).setter(setter(Builder::costCalculation))
            .constructor(SavingsPlansCostCalculation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            COST_CALCULATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Ec2InstanceSavingsPlansConfiguration configuration;

    private final SavingsPlansCostCalculation costCalculation;

    private Ec2InstanceSavingsPlans(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    /**
     * <p>
     * The EC2 instance Savings Plans configuration used for recommendations.
     * </p>
     * 
     * @return The EC2 instance Savings Plans configuration used for recommendations.
     */
    public final Ec2InstanceSavingsPlansConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Cost impact of the Savings Plans purchase recommendation.
     * </p>
     * 
     * @return Cost impact of the Savings Plans purchase recommendation.
     */
    public final SavingsPlansCostCalculation costCalculation() {
        return costCalculation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(costCalculation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceSavingsPlans)) {
            return false;
        }
        Ec2InstanceSavingsPlans other = (Ec2InstanceSavingsPlans) obj;
        return Objects.equals(configuration(), other.configuration())
                && Objects.equals(costCalculation(), other.costCalculation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2InstanceSavingsPlans").add("Configuration", configuration())
                .add("CostCalculation", costCalculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "costCalculation":
            return Optional.ofNullable(clazz.cast(costCalculation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2InstanceSavingsPlans, T> g) {
        return obj -> g.apply((Ec2InstanceSavingsPlans) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2InstanceSavingsPlans> {
        /**
         * <p>
         * The EC2 instance Savings Plans configuration used for recommendations.
         * </p>
         * 
         * @param configuration
         *        The EC2 instance Savings Plans configuration used for recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Ec2InstanceSavingsPlansConfiguration configuration);

        /**
         * <p>
         * The EC2 instance Savings Plans configuration used for recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link Ec2InstanceSavingsPlansConfiguration.Builder} avoiding the need to create one manually via
         * {@link Ec2InstanceSavingsPlansConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2InstanceSavingsPlansConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(Ec2InstanceSavingsPlansConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link Ec2InstanceSavingsPlansConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(Ec2InstanceSavingsPlansConfiguration)
         */
        default Builder configuration(Consumer<Ec2InstanceSavingsPlansConfiguration.Builder> configuration) {
            return configuration(Ec2InstanceSavingsPlansConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Cost impact of the Savings Plans purchase recommendation.
         * </p>
         * 
         * @param costCalculation
         *        Cost impact of the Savings Plans purchase recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCalculation(SavingsPlansCostCalculation costCalculation);

        /**
         * <p>
         * Cost impact of the Savings Plans purchase recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsPlansCostCalculation.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansCostCalculation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansCostCalculation.Builder#build()} is called
         * immediately and its result is passed to {@link #costCalculation(SavingsPlansCostCalculation)}.
         * 
         * @param costCalculation
         *        a consumer that will call methods on {@link SavingsPlansCostCalculation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCalculation(SavingsPlansCostCalculation)
         */
        default Builder costCalculation(Consumer<SavingsPlansCostCalculation.Builder> costCalculation) {
            return costCalculation(SavingsPlansCostCalculation.builder().applyMutation(costCalculation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Ec2InstanceSavingsPlansConfiguration configuration;

        private SavingsPlansCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceSavingsPlans model) {
            configuration(model.configuration);
            costCalculation(model.costCalculation);
        }

        public final Ec2InstanceSavingsPlansConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(Ec2InstanceSavingsPlansConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(Ec2InstanceSavingsPlansConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final SavingsPlansCostCalculation.Builder getCostCalculation() {
            return costCalculation != null ? costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(SavingsPlansCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(SavingsPlansCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        @Override
        public Ec2InstanceSavingsPlans build() {
            return new Ec2InstanceSavingsPlans(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
