/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeProfilesRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<MergeProfilesRequest.Builder, MergeProfilesRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(MergeProfilesRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> MAIN_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MainProfileId").getter(getter(MergeProfilesRequest::mainProfileId))
            .setter(setter(Builder::mainProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MainProfileId").build()).build();

    private static final SdkField<List<String>> PROFILE_IDS_TO_BE_MERGED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProfileIdsToBeMerged")
            .getter(getter(MergeProfilesRequest::profileIdsToBeMerged))
            .setter(setter(Builder::profileIdsToBeMerged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIdsToBeMerged").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FieldSourceProfileIds> FIELD_SOURCE_PROFILE_IDS_FIELD = SdkField
            .<FieldSourceProfileIds> builder(MarshallingType.SDK_POJO).memberName("FieldSourceProfileIds")
            .getter(getter(MergeProfilesRequest::fieldSourceProfileIds)).setter(setter(Builder::fieldSourceProfileIds))
            .constructor(FieldSourceProfileIds::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldSourceProfileIds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            MAIN_PROFILE_ID_FIELD, PROFILE_IDS_TO_BE_MERGED_FIELD, FIELD_SOURCE_PROFILE_IDS_FIELD));

    private final String domainName;

    private final String mainProfileId;

    private final List<String> profileIdsToBeMerged;

    private final FieldSourceProfileIds fieldSourceProfileIds;

    private MergeProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.mainProfileId = builder.mainProfileId;
        this.profileIdsToBeMerged = builder.profileIdsToBeMerged;
        this.fieldSourceProfileIds = builder.fieldSourceProfileIds;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The identifier of the profile to be taken.
     * </p>
     * 
     * @return The identifier of the profile to be taken.
     */
    public final String mainProfileId() {
        return mainProfileId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileIdsToBeMerged property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProfileIdsToBeMerged() {
        return profileIdsToBeMerged != null && !(profileIdsToBeMerged instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the profile to be merged into MainProfileId.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileIdsToBeMerged} method.
     * </p>
     * 
     * @return The identifier of the profile to be merged into MainProfileId.
     */
    public final List<String> profileIdsToBeMerged() {
        return profileIdsToBeMerged;
    }

    /**
     * <p>
     * The identifiers of the fields in the profile that has the information you want to apply to the merge. For
     * example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the
     * EmailAddress field in Profile1.
     * </p>
     * 
     * @return The identifiers of the fields in the profile that has the information you want to apply to the merge. For
     *         example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier
     *         of the EmailAddress field in Profile1.
     */
    public final FieldSourceProfileIds fieldSourceProfileIds() {
        return fieldSourceProfileIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(mainProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileIdsToBeMerged() ? profileIdsToBeMerged() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fieldSourceProfileIds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeProfilesRequest)) {
            return false;
        }
        MergeProfilesRequest other = (MergeProfilesRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(mainProfileId(), other.mainProfileId())
                && hasProfileIdsToBeMerged() == other.hasProfileIdsToBeMerged()
                && Objects.equals(profileIdsToBeMerged(), other.profileIdsToBeMerged())
                && Objects.equals(fieldSourceProfileIds(), other.fieldSourceProfileIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeProfilesRequest").add("DomainName", domainName()).add("MainProfileId", mainProfileId())
                .add("ProfileIdsToBeMerged", hasProfileIdsToBeMerged() ? profileIdsToBeMerged() : null)
                .add("FieldSourceProfileIds", fieldSourceProfileIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "MainProfileId":
            return Optional.ofNullable(clazz.cast(mainProfileId()));
        case "ProfileIdsToBeMerged":
            return Optional.ofNullable(clazz.cast(profileIdsToBeMerged()));
        case "FieldSourceProfileIds":
            return Optional.ofNullable(clazz.cast(fieldSourceProfileIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeProfilesRequest, T> g) {
        return obj -> g.apply((MergeProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo, CopyableBuilder<Builder, MergeProfilesRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The identifier of the profile to be taken.
         * </p>
         * 
         * @param mainProfileId
         *        The identifier of the profile to be taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mainProfileId(String mainProfileId);

        /**
         * <p>
         * The identifier of the profile to be merged into MainProfileId.
         * </p>
         * 
         * @param profileIdsToBeMerged
         *        The identifier of the profile to be merged into MainProfileId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIdsToBeMerged(Collection<String> profileIdsToBeMerged);

        /**
         * <p>
         * The identifier of the profile to be merged into MainProfileId.
         * </p>
         * 
         * @param profileIdsToBeMerged
         *        The identifier of the profile to be merged into MainProfileId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIdsToBeMerged(String... profileIdsToBeMerged);

        /**
         * <p>
         * The identifiers of the fields in the profile that has the information you want to apply to the merge. For
         * example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of
         * the EmailAddress field in Profile1.
         * </p>
         * 
         * @param fieldSourceProfileIds
         *        The identifiers of the fields in the profile that has the information you want to apply to the merge.
         *        For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the
         *        identifier of the EmailAddress field in Profile1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSourceProfileIds(FieldSourceProfileIds fieldSourceProfileIds);

        /**
         * <p>
         * The identifiers of the fields in the profile that has the information you want to apply to the merge. For
         * example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of
         * the EmailAddress field in Profile1.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldSourceProfileIds.Builder} avoiding
         * the need to create one manually via {@link FieldSourceProfileIds#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldSourceProfileIds.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldSourceProfileIds(FieldSourceProfileIds)}.
         * 
         * @param fieldSourceProfileIds
         *        a consumer that will call methods on {@link FieldSourceProfileIds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldSourceProfileIds(FieldSourceProfileIds)
         */
        default Builder fieldSourceProfileIds(Consumer<FieldSourceProfileIds.Builder> fieldSourceProfileIds) {
            return fieldSourceProfileIds(FieldSourceProfileIds.builder().applyMutation(fieldSourceProfileIds).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String mainProfileId;

        private List<String> profileIdsToBeMerged = DefaultSdkAutoConstructList.getInstance();

        private FieldSourceProfileIds fieldSourceProfileIds;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeProfilesRequest model) {
            super(model);
            domainName(model.domainName);
            mainProfileId(model.mainProfileId);
            profileIdsToBeMerged(model.profileIdsToBeMerged);
            fieldSourceProfileIds(model.fieldSourceProfileIds);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getMainProfileId() {
            return mainProfileId;
        }

        public final void setMainProfileId(String mainProfileId) {
            this.mainProfileId = mainProfileId;
        }

        @Override
        public final Builder mainProfileId(String mainProfileId) {
            this.mainProfileId = mainProfileId;
            return this;
        }

        public final Collection<String> getProfileIdsToBeMerged() {
            if (profileIdsToBeMerged instanceof SdkAutoConstructList) {
                return null;
            }
            return profileIdsToBeMerged;
        }

        public final void setProfileIdsToBeMerged(Collection<String> profileIdsToBeMerged) {
            this.profileIdsToBeMerged = ProfileIdToBeMergedListCopier.copy(profileIdsToBeMerged);
        }

        @Override
        public final Builder profileIdsToBeMerged(Collection<String> profileIdsToBeMerged) {
            this.profileIdsToBeMerged = ProfileIdToBeMergedListCopier.copy(profileIdsToBeMerged);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIdsToBeMerged(String... profileIdsToBeMerged) {
            profileIdsToBeMerged(Arrays.asList(profileIdsToBeMerged));
            return this;
        }

        public final FieldSourceProfileIds.Builder getFieldSourceProfileIds() {
            return fieldSourceProfileIds != null ? fieldSourceProfileIds.toBuilder() : null;
        }

        public final void setFieldSourceProfileIds(FieldSourceProfileIds.BuilderImpl fieldSourceProfileIds) {
            this.fieldSourceProfileIds = fieldSourceProfileIds != null ? fieldSourceProfileIds.build() : null;
        }

        @Override
        public final Builder fieldSourceProfileIds(FieldSourceProfileIds fieldSourceProfileIds) {
            this.fieldSourceProfileIds = fieldSourceProfileIds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeProfilesRequest build() {
            return new MergeProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
