/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents options that specify how and where in the Glue Data Catalog DataBrew writes the output generated by recipe
 * jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCatalogOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCatalogOutput.Builder, DataCatalogOutput> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(DataCatalogOutput::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DataCatalogOutput::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DataCatalogOutput::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<S3TableOutputOptions> S3_OPTIONS_FIELD = SdkField
            .<S3TableOutputOptions> builder(MarshallingType.SDK_POJO).memberName("S3Options")
            .getter(getter(DataCatalogOutput::s3Options)).setter(setter(Builder::s3Options))
            .constructor(S3TableOutputOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Options").build()).build();

    private static final SdkField<DatabaseTableOutputOptions> DATABASE_OPTIONS_FIELD = SdkField
            .<DatabaseTableOutputOptions> builder(MarshallingType.SDK_POJO).memberName("DatabaseOptions")
            .getter(getter(DataCatalogOutput::databaseOptions)).setter(setter(Builder::databaseOptions))
            .constructor(DatabaseTableOutputOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOptions").build()).build();

    private static final SdkField<Boolean> OVERWRITE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Overwrite").getter(getter(DataCatalogOutput::overwrite)).setter(setter(Builder::overwrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overwrite").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, S3_OPTIONS_FIELD, DATABASE_OPTIONS_FIELD, OVERWRITE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final S3TableOutputOptions s3Options;

    private final DatabaseTableOutputOptions databaseOptions;

    private final Boolean overwrite;

    private DataCatalogOutput(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.s3Options = builder.s3Options;
        this.databaseOptions = builder.databaseOptions;
        this.overwrite = builder.overwrite;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
     * </p>
     * 
     * @return The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the
     *         data.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of a database in the Data Catalog.
     * </p>
     * 
     * @return The name of a database in the Data Catalog.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of a table in the Data Catalog.
     * </p>
     * 
     * @return The name of a table in the Data Catalog.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
     * </p>
     * 
     * @return Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe
     *         jobs.
     */
    public final S3TableOutputOptions s3Options() {
        return s3Options;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @return Represents options that specify how and where DataBrew writes the database output generated by recipe
     *         jobs.
     */
    public final DatabaseTableOutputOptions databaseOptions() {
        return databaseOptions;
    }

    /**
     * <p>
     * A value that, if true, means that any data in the location specified for output is overwritten with new output.
     * Not supported with DatabaseOptions.
     * </p>
     * 
     * @return A value that, if true, means that any data in the location specified for output is overwritten with new
     *         output. Not supported with DatabaseOptions.
     */
    public final Boolean overwrite() {
        return overwrite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Options());
        hashCode = 31 * hashCode + Objects.hashCode(databaseOptions());
        hashCode = 31 * hashCode + Objects.hashCode(overwrite());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogOutput)) {
            return false;
        }
        DataCatalogOutput other = (DataCatalogOutput) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(s3Options(), other.s3Options())
                && Objects.equals(databaseOptions(), other.databaseOptions()) && Objects.equals(overwrite(), other.overwrite());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCatalogOutput").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("S3Options", s3Options()).add("DatabaseOptions", databaseOptions())
                .add("Overwrite", overwrite()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "S3Options":
            return Optional.ofNullable(clazz.cast(s3Options()));
        case "DatabaseOptions":
            return Optional.ofNullable(clazz.cast(databaseOptions()));
        case "Overwrite":
            return Optional.ofNullable(clazz.cast(overwrite()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogOutput, T> g) {
        return obj -> g.apply((DataCatalogOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCatalogOutput> {
        /**
         * <p>
         * The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the data.
         * </p>
         * 
         * @param catalogId
         *        The unique identifier of the Amazon Web Services account that holds the Data Catalog that stores the
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of a database in the Data Catalog.
         * </p>
         * 
         * @param databaseName
         *        The name of a database in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of a table in the Data Catalog.
         * </p>
         * 
         * @param tableName
         *        The name of a table in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
         * </p>
         * 
         * @param s3Options
         *        Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Options(S3TableOutputOptions s3Options);

        /**
         * <p>
         * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3TableOutputOptions.Builder} avoiding
         * the need to create one manually via {@link S3TableOutputOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3TableOutputOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Options(S3TableOutputOptions)}.
         * 
         * @param s3Options
         *        a consumer that will call methods on {@link S3TableOutputOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Options(S3TableOutputOptions)
         */
        default Builder s3Options(Consumer<S3TableOutputOptions.Builder> s3Options) {
            return s3Options(S3TableOutputOptions.builder().applyMutation(s3Options).build());
        }

        /**
         * <p>
         * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
         * </p>
         * 
         * @param databaseOptions
         *        Represents options that specify how and where DataBrew writes the database output generated by recipe
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseOptions(DatabaseTableOutputOptions databaseOptions);

        /**
         * <p>
         * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabaseTableOutputOptions.Builder}
         * avoiding the need to create one manually via {@link DatabaseTableOutputOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseTableOutputOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #databaseOptions(DatabaseTableOutputOptions)}.
         * 
         * @param databaseOptions
         *        a consumer that will call methods on {@link DatabaseTableOutputOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseOptions(DatabaseTableOutputOptions)
         */
        default Builder databaseOptions(Consumer<DatabaseTableOutputOptions.Builder> databaseOptions) {
            return databaseOptions(DatabaseTableOutputOptions.builder().applyMutation(databaseOptions).build());
        }

        /**
         * <p>
         * A value that, if true, means that any data in the location specified for output is overwritten with new
         * output. Not supported with DatabaseOptions.
         * </p>
         * 
         * @param overwrite
         *        A value that, if true, means that any data in the location specified for output is overwritten with
         *        new output. Not supported with DatabaseOptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overwrite(Boolean overwrite);
    }

    static final class BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private S3TableOutputOptions s3Options;

        private DatabaseTableOutputOptions databaseOptions;

        private Boolean overwrite;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogOutput model) {
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            s3Options(model.s3Options);
            databaseOptions(model.databaseOptions);
            overwrite(model.overwrite);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final S3TableOutputOptions.Builder getS3Options() {
            return s3Options != null ? s3Options.toBuilder() : null;
        }

        public final void setS3Options(S3TableOutputOptions.BuilderImpl s3Options) {
            this.s3Options = s3Options != null ? s3Options.build() : null;
        }

        @Override
        public final Builder s3Options(S3TableOutputOptions s3Options) {
            this.s3Options = s3Options;
            return this;
        }

        public final DatabaseTableOutputOptions.Builder getDatabaseOptions() {
            return databaseOptions != null ? databaseOptions.toBuilder() : null;
        }

        public final void setDatabaseOptions(DatabaseTableOutputOptions.BuilderImpl databaseOptions) {
            this.databaseOptions = databaseOptions != null ? databaseOptions.build() : null;
        }

        @Override
        public final Builder databaseOptions(DatabaseTableOutputOptions databaseOptions) {
            this.databaseOptions = databaseOptions;
            return this;
        }

        public final Boolean getOverwrite() {
            return overwrite;
        }

        public final void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        @Override
        public final Builder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        @Override
        public DataCatalogOutput build() {
            return new DataCatalogOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
