/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduleRequest extends DataBrewRequest implements
        ToCopyableBuilder<CreateScheduleRequest.Builder, CreateScheduleRequest> {
    private static final SdkField<List<String>> JOB_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobNames")
            .getter(getter(CreateScheduleRequest::jobNames))
            .setter(setter(Builder::jobNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CronExpression").getter(getter(CreateScheduleRequest::cronExpression))
            .setter(setter(Builder::cronExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateScheduleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateScheduleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAMES_FIELD,
            CRON_EXPRESSION_FIELD, TAGS_FIELD, NAME_FIELD));

    private final List<String> jobNames;

    private final String cronExpression;

    private final Map<String, String> tags;

    private final String name;

    private CreateScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.jobNames = builder.jobNames;
        this.cronExpression = builder.cronExpression;
        this.tags = builder.tags;
        this.name = builder.name;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobNames() {
        return jobNames != null && !(jobNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name or names of one or more jobs to be run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobNames} method.
     * </p>
     * 
     * @return The name or names of one or more jobs to be run.
     */
    public final List<String> jobNames() {
        return jobNames;
    }

    /**
     * <p>
     * The date or dates and time or times when the jobs are to be run. For more information, see <a
     * href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew
     * Developer Guide</i>.
     * </p>
     * 
     * @return The date or dates and time or times when the jobs are to be run. For more information, see <a
     *         href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue
     *         DataBrew Developer Guide</i>.
     */
    public final String cronExpression() {
        return cronExpression;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags to apply to this schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata tags to apply to this schedule.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and
     * space.
     * </p>
     * 
     * @return A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period
     *         (.), and space.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobNames() ? jobNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cronExpression());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduleRequest)) {
            return false;
        }
        CreateScheduleRequest other = (CreateScheduleRequest) obj;
        return hasJobNames() == other.hasJobNames() && Objects.equals(jobNames(), other.jobNames())
                && Objects.equals(cronExpression(), other.cronExpression()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduleRequest").add("JobNames", hasJobNames() ? jobNames() : null)
                .add("CronExpression", cronExpression()).add("Tags", hasTags() ? tags() : null).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobNames":
            return Optional.ofNullable(clazz.cast(jobNames()));
        case "CronExpression":
            return Optional.ofNullable(clazz.cast(cronExpression()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduleRequest, T> g) {
        return obj -> g.apply((CreateScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateScheduleRequest> {
        /**
         * <p>
         * The name or names of one or more jobs to be run.
         * </p>
         * 
         * @param jobNames
         *        The name or names of one or more jobs to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNames(Collection<String> jobNames);

        /**
         * <p>
         * The name or names of one or more jobs to be run.
         * </p>
         * 
         * @param jobNames
         *        The name or names of one or more jobs to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNames(String... jobNames);

        /**
         * <p>
         * The date or dates and time or times when the jobs are to be run. For more information, see <a
         * href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue
         * DataBrew Developer Guide</i>.
         * </p>
         * 
         * @param cronExpression
         *        The date or dates and time or times when the jobs are to be run. For more information, see <a
         *        href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the
         *        <i>Glue DataBrew Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpression(String cronExpression);

        /**
         * <p>
         * Metadata tags to apply to this schedule.
         * </p>
         * 
         * @param tags
         *        Metadata tags to apply to this schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.),
         * and space.
         * </p>
         * 
         * @param name
         *        A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period
         *        (.), and space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private List<String> jobNames = DefaultSdkAutoConstructList.getInstance();

        private String cronExpression;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduleRequest model) {
            super(model);
            jobNames(model.jobNames);
            cronExpression(model.cronExpression);
            tags(model.tags);
            name(model.name);
        }

        public final Collection<String> getJobNames() {
            if (jobNames instanceof SdkAutoConstructList) {
                return null;
            }
            return jobNames;
        }

        public final void setJobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
        }

        @Override
        public final Builder jobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobNames(String... jobNames) {
            jobNames(Arrays.asList(jobNames));
            return this;
        }

        public final String getCronExpression() {
            return cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduleRequest build() {
            return new CreateScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
