/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoExportRevisionDestinationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoExportRevisionDestinationEntry.Builder, AutoExportRevisionDestinationEntry> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(AutoExportRevisionDestinationEntry::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> KEY_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyPattern").getter(getter(AutoExportRevisionDestinationEntry::keyPattern))
            .setter(setter(Builder::keyPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPattern").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            KEY_PATTERN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String keyPattern;

    private AutoExportRevisionDestinationEntry(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPattern = builder.keyPattern;
    }

    /**
     * <p>
     * The S3 bucket that is the destination for the event action.
     * </p>
     * 
     * @return The S3 bucket that is the destination for the event action.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * A string representing the pattern for generated names of the individual assets in the revision. For more
     * information about key patterns, see <a
     * href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key
     * patterns when exporting revisions</a>.
     * </p>
     * 
     * @return A string representing the pattern for generated names of the individual assets in the revision. For more
     *         information about key patterns, see <a
     *         href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns"
     *         >Key patterns when exporting revisions</a>.
     */
    public final String keyPattern() {
        return keyPattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(keyPattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoExportRevisionDestinationEntry)) {
            return false;
        }
        AutoExportRevisionDestinationEntry other = (AutoExportRevisionDestinationEntry) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(keyPattern(), other.keyPattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoExportRevisionDestinationEntry").add("Bucket", bucket()).add("KeyPattern", keyPattern())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "KeyPattern":
            return Optional.ofNullable(clazz.cast(keyPattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoExportRevisionDestinationEntry, T> g) {
        return obj -> g.apply((AutoExportRevisionDestinationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoExportRevisionDestinationEntry> {
        /**
         * <p>
         * The S3 bucket that is the destination for the event action.
         * </p>
         * 
         * @param bucket
         *        The S3 bucket that is the destination for the event action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * A string representing the pattern for generated names of the individual assets in the revision. For more
         * information about key patterns, see <a
         * href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key
         * patterns when exporting revisions</a>.
         * </p>
         * 
         * @param keyPattern
         *        A string representing the pattern for generated names of the individual assets in the revision. For
         *        more information about key patterns, see <a href=
         *        "https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key
         *        patterns when exporting revisions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPattern(String keyPattern);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String keyPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoExportRevisionDestinationEntry model) {
            bucket(model.bucket);
            keyPattern(model.keyPattern);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPattern() {
            return keyPattern;
        }

        public final void setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
        }

        @Override
        public final Builder keyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
            return this;
        }

        @Override
        public AutoExportRevisionDestinationEntry build() {
            return new AutoExportRevisionDestinationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
