/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRevisionResponse extends DataExchangeResponse implements
        ToCopyableBuilder<CreateRevisionResponse.Builder, CreateRevisionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateRevisionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Comment")
            .getter(getter(CreateRevisionResponse::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(CreateRevisionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(CreateRevisionResponse::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<Boolean> FINALIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Finalized").getter(getter(CreateRevisionResponse::finalized)).setter(setter(Builder::finalized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Finalized").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateRevisionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceId").getter(getter(CreateRevisionResponse::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRevisionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(CreateRevisionResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> REVOCATION_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevocationComment").getter(getter(CreateRevisionResponse::revocationComment))
            .setter(setter(Builder::revocationComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationComment").build()).build();

    private static final SdkField<Boolean> REVOKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Revoked").getter(getter(CreateRevisionResponse::revoked)).setter(setter(Builder::revoked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revoked").build()).build();

    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RevokedAt")
            .getter(getter(CreateRevisionResponse::revokedAt))
            .setter(setter(Builder::revokedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMMENT_FIELD,
            CREATED_AT_FIELD, DATA_SET_ID_FIELD, FINALIZED_FIELD, ID_FIELD, SOURCE_ID_FIELD, TAGS_FIELD, UPDATED_AT_FIELD,
            REVOCATION_COMMENT_FIELD, REVOKED_FIELD, REVOKED_AT_FIELD));

    private final String arn;

    private final String comment;

    private final Instant createdAt;

    private final String dataSetId;

    private final Boolean finalized;

    private final String id;

    private final String sourceId;

    private final Map<String, String> tags;

    private final Instant updatedAt;

    private final String revocationComment;

    private final Boolean revoked;

    private final Instant revokedAt;

    private CreateRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.comment = builder.comment;
        this.createdAt = builder.createdAt;
        this.dataSetId = builder.dataSetId;
        this.finalized = builder.finalized;
        this.id = builder.id;
        this.sourceId = builder.sourceId;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
        this.revocationComment = builder.revocationComment;
        this.revoked = builder.revoked;
        this.revokedAt = builder.revokedAt;
    }

    /**
     * <p>
     * The ARN for the revision.
     * </p>
     * 
     * @return The ARN for the revision.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An optional comment about the revision.
     * </p>
     * 
     * @return An optional comment about the revision.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The date and time that the revision was created, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the revision was created, in ISO 8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this revision.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this revision.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision
     * tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this
     * read-only state, you can publish the revision to your products. Finalized revisions can be published through the
     * AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace Catalog
     * API action. When using the API, revisions are uniquely identified by their ARN.
     * </p>
     * 
     * @return To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a
     *         revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's
     *         in this read-only state, you can publish the revision to your products. Finalized revisions can be
     *         published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the
     *         StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely identified
     *         by their ARN.
     */
    public final Boolean finalized() {
        return finalized;
    }

    /**
     * <p>
     * The unique identifier for the revision.
     * </p>
     * 
     * @return The unique identifier for the revision.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is
     * returned when a revision owner is viewing the entitled copy of its owned revision.
     * </p>
     * 
     * @return The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter
     *         is returned when a revision owner is viewing the entitled copy of its owned revision.
     */
    public final String sourceId() {
        return sourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the revision.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the revision.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The date and time that the revision was last updated, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the revision was last updated, in ISO 8601 format.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * A required comment to inform subscribers of the reason their access to the revision was revoked.
     * </p>
     * 
     * @return A required comment to inform subscribers of the reason their access to the revision was revoked.
     */
    public final String revocationComment() {
        return revocationComment;
    }

    /**
     * <p>
     * A status indicating that subscribers' access to the revision was revoked.
     * </p>
     * 
     * @return A status indicating that subscribers' access to the revision was revoked.
     */
    public final Boolean revoked() {
        return revoked;
    }

    /**
     * <p>
     * The date and time that the revision was revoked, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the revision was revoked, in ISO 8601 format.
     */
    public final Instant revokedAt() {
        return revokedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(finalized());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(revocationComment());
        hashCode = 31 * hashCode + Objects.hashCode(revoked());
        hashCode = 31 * hashCode + Objects.hashCode(revokedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRevisionResponse)) {
            return false;
        }
        CreateRevisionResponse other = (CreateRevisionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(comment(), other.comment())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(finalized(), other.finalized()) && Objects.equals(id(), other.id())
                && Objects.equals(sourceId(), other.sourceId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(revocationComment(), other.revocationComment()) && Objects.equals(revoked(), other.revoked())
                && Objects.equals(revokedAt(), other.revokedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRevisionResponse").add("Arn", arn()).add("Comment", comment())
                .add("CreatedAt", createdAt()).add("DataSetId", dataSetId()).add("Finalized", finalized()).add("Id", id())
                .add("SourceId", sourceId()).add("Tags", hasTags() ? tags() : null).add("UpdatedAt", updatedAt())
                .add("RevocationComment", revocationComment()).add("Revoked", revoked()).add("RevokedAt", revokedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Finalized":
            return Optional.ofNullable(clazz.cast(finalized()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "RevocationComment":
            return Optional.ofNullable(clazz.cast(revocationComment()));
        case "Revoked":
            return Optional.ofNullable(clazz.cast(revoked()));
        case "RevokedAt":
            return Optional.ofNullable(clazz.cast(revokedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRevisionResponse, T> g) {
        return obj -> g.apply((CreateRevisionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataExchangeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRevisionResponse> {
        /**
         * <p>
         * The ARN for the revision.
         * </p>
         * 
         * @param arn
         *        The ARN for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An optional comment about the revision.
         * </p>
         * 
         * @param comment
         *        An optional comment about the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The date and time that the revision was created, in ISO 8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the revision was created, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The unique identifier for the data set associated with this revision.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a revision
         * tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this
         * read-only state, you can publish the revision to your products. Finalized revisions can be published through
         * the AWS Data Exchange console or the AWS Marketplace Catalog API, using the StartChangeSet AWS Marketplace
         * Catalog API action. When using the API, revisions are uniquely identified by their ARN.
         * </p>
         * 
         * @param finalized
         *        To publish a revision to a data set in a product, the revision must first be finalized. Finalizing a
         *        revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After
         *        it's in this read-only state, you can publish the revision to your products. Finalized revisions can
         *        be published through the AWS Data Exchange console or the AWS Marketplace Catalog API, using the
         *        StartChangeSet AWS Marketplace Catalog API action. When using the API, revisions are uniquely
         *        identified by their ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalized(Boolean finalized);

        /**
         * <p>
         * The unique identifier for the revision.
         * </p>
         * 
         * @param id
         *        The unique identifier for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The revision ID of the owned revision corresponding to the entitled revision being viewed. This parameter is
         * returned when a revision owner is viewing the entitled copy of its owned revision.
         * </p>
         * 
         * @param sourceId
         *        The revision ID of the owned revision corresponding to the entitled revision being viewed. This
         *        parameter is returned when a revision owner is viewing the entitled copy of its owned revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * The tags for the revision.
         * </p>
         * 
         * @param tags
         *        The tags for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The date and time that the revision was last updated, in ISO 8601 format.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the revision was last updated, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * A required comment to inform subscribers of the reason their access to the revision was revoked.
         * </p>
         * 
         * @param revocationComment
         *        A required comment to inform subscribers of the reason their access to the revision was revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationComment(String revocationComment);

        /**
         * <p>
         * A status indicating that subscribers' access to the revision was revoked.
         * </p>
         * 
         * @param revoked
         *        A status indicating that subscribers' access to the revision was revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revoked(Boolean revoked);

        /**
         * <p>
         * The date and time that the revision was revoked, in ISO 8601 format.
         * </p>
         * 
         * @param revokedAt
         *        The date and time that the revision was revoked, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedAt(Instant revokedAt);
    }

    static final class BuilderImpl extends DataExchangeResponse.BuilderImpl implements Builder {
        private String arn;

        private String comment;

        private Instant createdAt;

        private String dataSetId;

        private Boolean finalized;

        private String id;

        private String sourceId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant updatedAt;

        private String revocationComment;

        private Boolean revoked;

        private Instant revokedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRevisionResponse model) {
            super(model);
            arn(model.arn);
            comment(model.comment);
            createdAt(model.createdAt);
            dataSetId(model.dataSetId);
            finalized(model.finalized);
            id(model.id);
            sourceId(model.sourceId);
            tags(model.tags);
            updatedAt(model.updatedAt);
            revocationComment(model.revocationComment);
            revoked(model.revoked);
            revokedAt(model.revokedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final Boolean getFinalized() {
            return finalized;
        }

        public final void setFinalized(Boolean finalized) {
            this.finalized = finalized;
        }

        @Override
        public final Builder finalized(Boolean finalized) {
            this.finalized = finalized;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getRevocationComment() {
            return revocationComment;
        }

        public final void setRevocationComment(String revocationComment) {
            this.revocationComment = revocationComment;
        }

        @Override
        public final Builder revocationComment(String revocationComment) {
            this.revocationComment = revocationComment;
            return this;
        }

        public final Boolean getRevoked() {
            return revoked;
        }

        public final void setRevoked(Boolean revoked) {
            this.revoked = revoked;
        }

        @Override
        public final Builder revoked(Boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        public final Instant getRevokedAt() {
            return revokedAt;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @Override
        public CreateRevisionResponse build() {
            return new CreateRevisionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
