/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The destination where the assets in the revision will be exported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevisionDestinationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<RevisionDestinationEntry.Builder, RevisionDestinationEntry> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(RevisionDestinationEntry::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> KEY_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyPattern").getter(getter(RevisionDestinationEntry::keyPattern)).setter(setter(Builder::keyPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPattern").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(RevisionDestinationEntry::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            KEY_PATTERN_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String keyPattern;

    private final String revisionId;

    private RevisionDestinationEntry(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPattern = builder.keyPattern;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The S3 bucket that is the destination for the assets in the revision.
     * </p>
     * 
     * @return The S3 bucket that is the destination for the assets in the revision.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * A string representing the pattern for generated names of the individual assets in the revision. For more
     * information about key patterns, see <a
     * href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key
     * patterns when exporting revisions</a>.
     * </p>
     * 
     * @return A string representing the pattern for generated names of the individual assets in the revision. For more
     *         information about key patterns, see <a
     *         href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns"
     *         >Key patterns when exporting revisions</a>.
     */
    public final String keyPattern() {
        return keyPattern;
    }

    /**
     * <p>
     * The unique identifier for the revision.
     * </p>
     * 
     * @return The unique identifier for the revision.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(keyPattern());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionDestinationEntry)) {
            return false;
        }
        RevisionDestinationEntry other = (RevisionDestinationEntry) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(keyPattern(), other.keyPattern())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevisionDestinationEntry").add("Bucket", bucket()).add("KeyPattern", keyPattern())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "KeyPattern":
            return Optional.ofNullable(clazz.cast(keyPattern()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevisionDestinationEntry, T> g) {
        return obj -> g.apply((RevisionDestinationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevisionDestinationEntry> {
        /**
         * <p>
         * The S3 bucket that is the destination for the assets in the revision.
         * </p>
         * 
         * @param bucket
         *        The S3 bucket that is the destination for the assets in the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * A string representing the pattern for generated names of the individual assets in the revision. For more
         * information about key patterns, see <a
         * href="https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key
         * patterns when exporting revisions</a>.
         * </p>
         * 
         * @param keyPattern
         *        A string representing the pattern for generated names of the individual assets in the revision. For
         *        more information about key patterns, see <a href=
         *        "https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html#revision-export-keypatterns">Key
         *        patterns when exporting revisions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPattern(String keyPattern);

        /**
         * <p>
         * The unique identifier for the revision.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String keyPattern;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionDestinationEntry model) {
            bucket(model.bucket);
            keyPattern(model.keyPattern);
            revisionId(model.revisionId);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPattern() {
            return keyPattern;
        }

        public final void setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
        }

        @Override
        public final Builder keyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public RevisionDestinationEntry build() {
            return new RevisionDestinationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
