/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extra details specific to this schema change type notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaChangeRequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaChangeRequestDetails.Builder, SchemaChangeRequestDetails> {
    private static final SdkField<List<SchemaChangeDetails>> CHANGES_FIELD = SdkField
            .<List<SchemaChangeDetails>> builder(MarshallingType.LIST)
            .memberName("Changes")
            .getter(getter(SchemaChangeRequestDetails::changes))
            .setter(setter(Builder::changes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaChangeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaChangeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> SCHEMA_CHANGE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SchemaChangeAt")
            .getter(getter(SchemaChangeRequestDetails::schemaChangeAt))
            .setter(setter(Builder::schemaChangeAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangeAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGES_FIELD,
            SCHEMA_CHANGE_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SchemaChangeDetails> changes;

    private final Instant schemaChangeAt;

    private SchemaChangeRequestDetails(BuilderImpl builder) {
        this.changes = builder.changes;
        this.schemaChangeAt = builder.schemaChangeAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Changes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChanges() {
        return changes != null && !(changes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of schema changes happening in the scope of this notification. This can have up to 100 entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChanges} method.
     * </p>
     * 
     * @return List of schema changes happening in the scope of this notification. This can have up to 100 entries.
     */
    public final List<SchemaChangeDetails> changes() {
        return changes;
    }

    /**
     * <p>
     * A date in the future when the schema change is taking effect.
     * </p>
     * 
     * @return A date in the future when the schema change is taking effect.
     */
    public final Instant schemaChangeAt() {
        return schemaChangeAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasChanges() ? changes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaChangeAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaChangeRequestDetails)) {
            return false;
        }
        SchemaChangeRequestDetails other = (SchemaChangeRequestDetails) obj;
        return hasChanges() == other.hasChanges() && Objects.equals(changes(), other.changes())
                && Objects.equals(schemaChangeAt(), other.schemaChangeAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaChangeRequestDetails").add("Changes", hasChanges() ? changes() : null)
                .add("SchemaChangeAt", schemaChangeAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Changes":
            return Optional.ofNullable(clazz.cast(changes()));
        case "SchemaChangeAt":
            return Optional.ofNullable(clazz.cast(schemaChangeAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaChangeRequestDetails, T> g) {
        return obj -> g.apply((SchemaChangeRequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaChangeRequestDetails> {
        /**
         * <p>
         * List of schema changes happening in the scope of this notification. This can have up to 100 entries.
         * </p>
         * 
         * @param changes
         *        List of schema changes happening in the scope of this notification. This can have up to 100 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Collection<SchemaChangeDetails> changes);

        /**
         * <p>
         * List of schema changes happening in the scope of this notification. This can have up to 100 entries.
         * </p>
         * 
         * @param changes
         *        List of schema changes happening in the scope of this notification. This can have up to 100 entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(SchemaChangeDetails... changes);

        /**
         * <p>
         * List of schema changes happening in the scope of this notification. This can have up to 100 entries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #changes(List<SchemaChangeDetails>)}.
         * 
         * @param changes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.SchemaChangeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changes(java.util.Collection<SchemaChangeDetails>)
         */
        Builder changes(Consumer<SchemaChangeDetails.Builder>... changes);

        /**
         * <p>
         * A date in the future when the schema change is taking effect.
         * </p>
         * 
         * @param schemaChangeAt
         *        A date in the future when the schema change is taking effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaChangeAt(Instant schemaChangeAt);
    }

    static final class BuilderImpl implements Builder {
        private List<SchemaChangeDetails> changes = DefaultSdkAutoConstructList.getInstance();

        private Instant schemaChangeAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaChangeRequestDetails model) {
            changes(model.changes);
            schemaChangeAt(model.schemaChangeAt);
        }

        public final List<SchemaChangeDetails.Builder> getChanges() {
            List<SchemaChangeDetails.Builder> result = ListOfSchemaChangeDetailsCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<SchemaChangeDetails.BuilderImpl> changes) {
            this.changes = ListOfSchemaChangeDetailsCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<SchemaChangeDetails> changes) {
            this.changes = ListOfSchemaChangeDetailsCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(SchemaChangeDetails... changes) {
            changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<SchemaChangeDetails.Builder>... changes) {
            changes(Stream.of(changes).map(c -> SchemaChangeDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getSchemaChangeAt() {
            return schemaChangeAt;
        }

        public final void setSchemaChangeAt(Instant schemaChangeAt) {
            this.schemaChangeAt = schemaChangeAt;
        }

        @Override
        public final Builder schemaChangeAt(Instant schemaChangeAt) {
            this.schemaChangeAt = schemaChangeAt;
            return this;
        }

        @Override
        public SchemaChangeRequestDetails build() {
            return new SchemaChangeRequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
