/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extra details specific to a deprecation type notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeprecationRequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DeprecationRequestDetails.Builder, DeprecationRequestDetails> {
    private static final SdkField<Instant> DEPRECATION_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeprecationAt")
            .getter(getter(DeprecationRequestDetails::deprecationAt))
            .setter(setter(Builder::deprecationAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPRECATION_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant deprecationAt;

    private DeprecationRequestDetails(BuilderImpl builder) {
        this.deprecationAt = builder.deprecationAt;
    }

    /**
     * <p>
     * A datetime in the future when the data set will be deprecated.
     * </p>
     * 
     * @return A datetime in the future when the data set will be deprecated.
     */
    public final Instant deprecationAt() {
        return deprecationAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deprecationAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecationRequestDetails)) {
            return false;
        }
        DeprecationRequestDetails other = (DeprecationRequestDetails) obj;
        return Objects.equals(deprecationAt(), other.deprecationAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeprecationRequestDetails").add("DeprecationAt", deprecationAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeprecationAt":
            return Optional.ofNullable(clazz.cast(deprecationAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeprecationRequestDetails, T> g) {
        return obj -> g.apply((DeprecationRequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeprecationRequestDetails> {
        /**
         * <p>
         * A datetime in the future when the data set will be deprecated.
         * </p>
         * 
         * @param deprecationAt
         *        A datetime in the future when the data set will be deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationAt(Instant deprecationAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant deprecationAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecationRequestDetails model) {
            deprecationAt(model.deprecationAt);
        }

        public final Instant getDeprecationAt() {
            return deprecationAt;
        }

        public final void setDeprecationAt(Instant deprecationAt) {
            this.deprecationAt = deprecationAt;
        }

        @Override
        public final Builder deprecationAt(Instant deprecationAt) {
            this.deprecationAt = deprecationAt;
            return this;
        }

        @Override
        public DeprecationRequestDetails build() {
            return new DeprecationRequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
