/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * StartTaskExecutionRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTaskExecutionRequest extends DataSyncRequest implements
        ToCopyableBuilder<StartTaskExecutionRequest.Builder, StartTaskExecutionRequest> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(StartTaskExecutionRequest::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<Options> OVERRIDE_OPTIONS_FIELD = SdkField.<Options> builder(MarshallingType.SDK_POJO)
            .memberName("OverrideOptions").getter(getter(StartTaskExecutionRequest::overrideOptions))
            .setter(setter(Builder::overrideOptions)).constructor(Options::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideOptions").build()).build();

    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Includes")
            .getter(getter(StartTaskExecutionRequest::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField
            .<List<FilterRule>> builder(MarshallingType.LIST)
            .memberName("Excludes")
            .getter(getter(StartTaskExecutionRequest::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartTaskExecutionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TaskReportConfig> TASK_REPORT_CONFIG_FIELD = SdkField
            .<TaskReportConfig> builder(MarshallingType.SDK_POJO).memberName("TaskReportConfig")
            .getter(getter(StartTaskExecutionRequest::taskReportConfig)).setter(setter(Builder::taskReportConfig))
            .constructor(TaskReportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskReportConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD,
            OVERRIDE_OPTIONS_FIELD, INCLUDES_FIELD, EXCLUDES_FIELD, TAGS_FIELD, TASK_REPORT_CONFIG_FIELD));

    private final String taskArn;

    private final Options overrideOptions;

    private final List<FilterRule> includes;

    private final List<FilterRule> excludes;

    private final List<TagListEntry> tags;

    private final TaskReportConfig taskReportConfig;

    private StartTaskExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.taskArn = builder.taskArn;
        this.overrideOptions = builder.overrideOptions;
        this.includes = builder.includes;
        this.excludes = builder.excludes;
        this.tags = builder.tags;
        this.taskReportConfig = builder.taskReportConfig;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the task that you want to start.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the task that you want to start.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * Returns the value of the OverrideOptions property for this object.
     * 
     * @return The value of the OverrideOptions property for this object.
     */
    public final Options overrideOptions() {
        return overrideOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Includes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of filter rules that determines which files to include when running a task. The pattern should
     * contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that
     * is, a pipe), for example, <code>"/folder1|/folder2"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludes} method.
     * </p>
     * 
     * @return Specifies a list of filter rules that determines which files to include when running a task. The pattern
     *         should contain a single filter string that consists of the patterns to include. The patterns are
     *         delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
     */
    public final List<FilterRule> includes() {
        return includes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Excludes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of filter rules that determines which files to exclude from a task. The list contains a single
     * filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for
     * example, <code>"/folder1|/folder2"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludes} method.
     * </p>
     * 
     * @return Specifies a list of filter rules that determines which files to exclude from a task. The list contains a
     *         single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that
     *         is, a pipe), for example, <code>"/folder1|/folder2"</code>.
     */
    public final List<FilterRule> excludes() {
        return excludes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task execution.
     * </p>
     * <p>
     * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task
     *         execution.</p>
     *         <p>
     *         <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies how you want to configure a task report, which provides detailed information about for your DataSync
     * transfer.
     * </p>
     * 
     * @return Specifies how you want to configure a task report, which provides detailed information about for your
     *         DataSync transfer.
     */
    public final TaskReportConfig taskReportConfig() {
        return taskReportConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(overrideOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludes() ? includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludes() ? excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskReportConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskExecutionRequest)) {
            return false;
        }
        StartTaskExecutionRequest other = (StartTaskExecutionRequest) obj;
        return Objects.equals(taskArn(), other.taskArn()) && Objects.equals(overrideOptions(), other.overrideOptions())
                && hasIncludes() == other.hasIncludes() && Objects.equals(includes(), other.includes())
                && hasExcludes() == other.hasExcludes() && Objects.equals(excludes(), other.excludes())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(taskReportConfig(), other.taskReportConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTaskExecutionRequest").add("TaskArn", taskArn()).add("OverrideOptions", overrideOptions())
                .add("Includes", hasIncludes() ? includes() : null).add("Excludes", hasExcludes() ? excludes() : null)
                .add("Tags", hasTags() ? tags() : null).add("TaskReportConfig", taskReportConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "OverrideOptions":
            return Optional.ofNullable(clazz.cast(overrideOptions()));
        case "Includes":
            return Optional.ofNullable(clazz.cast(includes()));
        case "Excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TaskReportConfig":
            return Optional.ofNullable(clazz.cast(taskReportConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTaskExecutionRequest, T> g) {
        return obj -> g.apply((StartTaskExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTaskExecutionRequest> {
        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the task that you want to start.
         * </p>
         * 
         * @param taskArn
         *        Specifies the Amazon Resource Name (ARN) of the task that you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * Sets the value of the OverrideOptions property for this object.
         *
         * @param overrideOptions
         *        The new value for the OverrideOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideOptions(Options overrideOptions);

        /**
         * Sets the value of the OverrideOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Options.Builder} avoiding the need to
         * create one manually via {@link Options#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Options.Builder#build()} is called immediately and its result is
         * passed to {@link #overrideOptions(Options)}.
         * 
         * @param overrideOptions
         *        a consumer that will call methods on {@link Options.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideOptions(Options)
         */
        default Builder overrideOptions(Consumer<Options.Builder> overrideOptions) {
            return overrideOptions(Options.builder().applyMutation(overrideOptions).build());
        }

        /**
         * <p>
         * Specifies a list of filter rules that determines which files to include when running a task. The pattern
         * should contain a single filter string that consists of the patterns to include. The patterns are delimited by
         * "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
         * </p>
         * 
         * @param includes
         *        Specifies a list of filter rules that determines which files to include when running a task. The
         *        pattern should contain a single filter string that consists of the patterns to include. The patterns
         *        are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<FilterRule> includes);

        /**
         * <p>
         * Specifies a list of filter rules that determines which files to include when running a task. The pattern
         * should contain a single filter string that consists of the patterns to include. The patterns are delimited by
         * "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
         * </p>
         * 
         * @param includes
         *        Specifies a list of filter rules that determines which files to include when running a task. The
         *        pattern should contain a single filter string that consists of the patterns to include. The patterns
         *        are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(FilterRule... includes);

        /**
         * <p>
         * Specifies a list of filter rules that determines which files to include when running a task. The pattern
         * should contain a single filter string that consists of the patterns to include. The patterns are delimited by
         * "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #includes(List<FilterRule>)}.
         * 
         * @param includes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(java.util.Collection<FilterRule>)
         */
        Builder includes(Consumer<FilterRule.Builder>... includes);

        /**
         * <p>
         * Specifies a list of filter rules that determines which files to exclude from a task. The list contains a
         * single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a
         * pipe), for example, <code>"/folder1|/folder2"</code>.
         * </p>
         * 
         * @param excludes
         *        Specifies a list of filter rules that determines which files to exclude from a task. The list contains
         *        a single filter string that consists of the patterns to exclude. The patterns are delimited by "|"
         *        (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<FilterRule> excludes);

        /**
         * <p>
         * Specifies a list of filter rules that determines which files to exclude from a task. The list contains a
         * single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a
         * pipe), for example, <code>"/folder1|/folder2"</code>.
         * </p>
         * 
         * @param excludes
         *        Specifies a list of filter rules that determines which files to exclude from a task. The list contains
         *        a single filter string that consists of the patterns to exclude. The patterns are delimited by "|"
         *        (that is, a pipe), for example, <code>"/folder1|/folder2"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(FilterRule... excludes);

        /**
         * <p>
         * Specifies a list of filter rules that determines which files to exclude from a task. The list contains a
         * single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a
         * pipe), for example, <code>"/folder1|/folder2"</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.FilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder#build()} is called immediately and
         * its result is passed to {@link #excludes(List<FilterRule>)}.
         * 
         * @param excludes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.FilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(java.util.Collection<FilterRule>)
         */
        Builder excludes(Consumer<FilterRule.Builder>... excludes);

        /**
         * <p>
         * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task execution.
         * </p>
         * <p>
         * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * </p>
         * 
         * @param tags
         *        Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task
         *        execution.</p>
         *        <p>
         *        <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task execution.
         * </p>
         * <p>
         * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * </p>
         * 
         * @param tags
         *        Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task
         *        execution.</p>
         *        <p>
         *        <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task execution.
         * </p>
         * <p>
         * <i>Tags</i> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        /**
         * <p>
         * Specifies how you want to configure a task report, which provides detailed information about for your
         * DataSync transfer.
         * </p>
         * 
         * @param taskReportConfig
         *        Specifies how you want to configure a task report, which provides detailed information about for your
         *        DataSync transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskReportConfig(TaskReportConfig taskReportConfig);

        /**
         * <p>
         * Specifies how you want to configure a task report, which provides detailed information about for your
         * DataSync transfer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskReportConfig.Builder} avoiding the
         * need to create one manually via {@link TaskReportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskReportConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #taskReportConfig(TaskReportConfig)}.
         * 
         * @param taskReportConfig
         *        a consumer that will call methods on {@link TaskReportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskReportConfig(TaskReportConfig)
         */
        default Builder taskReportConfig(Consumer<TaskReportConfig.Builder> taskReportConfig) {
            return taskReportConfig(TaskReportConfig.builder().applyMutation(taskReportConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String taskArn;

        private Options overrideOptions;

        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();

        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private TaskReportConfig taskReportConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskExecutionRequest model) {
            super(model);
            taskArn(model.taskArn);
            overrideOptions(model.overrideOptions);
            includes(model.includes);
            excludes(model.excludes);
            tags(model.tags);
            taskReportConfig(model.taskReportConfig);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Options.Builder getOverrideOptions() {
            return overrideOptions != null ? overrideOptions.toBuilder() : null;
        }

        public final void setOverrideOptions(Options.BuilderImpl overrideOptions) {
            this.overrideOptions = overrideOptions != null ? overrideOptions.build() : null;
        }

        @Override
        public final Builder overrideOptions(Options overrideOptions) {
            this.overrideOptions = overrideOptions;
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder>... includes) {
            includes(Stream.of(includes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder>... excludes) {
            excludes(Stream.of(excludes).map(c -> FilterRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TaskReportConfig.Builder getTaskReportConfig() {
            return taskReportConfig != null ? taskReportConfig.toBuilder() : null;
        }

        public final void setTaskReportConfig(TaskReportConfig.BuilderImpl taskReportConfig) {
            this.taskReportConfig = taskReportConfig != null ? taskReportConfig.build() : null;
        }

        @Override
        public final Builder taskReportConfig(TaskReportConfig taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTaskExecutionRequest build() {
            return new StartTaskExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
