/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Amazon DataZone inventory asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetItem implements SdkPojo, Serializable, ToCopyableBuilder<AssetItem.Builder, AssetItem> {
    private static final SdkField<AssetItemAdditionalAttributes> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<AssetItemAdditionalAttributes> builder(MarshallingType.SDK_POJO).memberName("additionalAttributes")
            .getter(getter(AssetItem::additionalAttributes)).setter(setter(Builder::additionalAttributes))
            .constructor(AssetItemAdditionalAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AssetItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(AssetItem::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssetItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(AssetItem::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> EXTERNAL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalIdentifier").getter(getter(AssetItem::externalIdentifier))
            .setter(setter(Builder::externalIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalIdentifier").build())
            .build();

    private static final SdkField<Instant> FIRST_REVISION_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstRevisionCreatedAt").getter(getter(AssetItem::firstRevisionCreatedAt))
            .setter(setter(Builder::firstRevisionCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedAt").build())
            .build();

    private static final SdkField<String> FIRST_REVISION_CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstRevisionCreatedBy").getter(getter(AssetItem::firstRevisionCreatedBy))
            .setter(setter(Builder::firstRevisionCreatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstRevisionCreatedBy").build())
            .build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(AssetItem::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(AssetItem::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(AssetItem::owningProjectId)).setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeIdentifier").getter(getter(AssetItem::typeIdentifier)).setter(setter(Builder::typeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(AssetItem::typeRevision)).setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD,
            CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, EXTERNAL_IDENTIFIER_FIELD,
            FIRST_REVISION_CREATED_AT_FIELD, FIRST_REVISION_CREATED_BY_FIELD, GLOSSARY_TERMS_FIELD, IDENTIFIER_FIELD, NAME_FIELD,
            OWNING_PROJECT_ID_FIELD, TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssetItemAdditionalAttributes additionalAttributes;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final String externalIdentifier;

    private final Instant firstRevisionCreatedAt;

    private final String firstRevisionCreatedBy;

    private final List<String> glossaryTerms;

    private final String identifier;

    private final String name;

    private final String owningProjectId;

    private final String typeIdentifier;

    private final String typeRevision;

    private AssetItem(BuilderImpl builder) {
        this.additionalAttributes = builder.additionalAttributes;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.externalIdentifier = builder.externalIdentifier;
        this.firstRevisionCreatedAt = builder.firstRevisionCreatedAt;
        this.firstRevisionCreatedBy = builder.firstRevisionCreatedBy;
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    /**
     * <p>
     * The additional attributes of a Amazon DataZone inventory asset.
     * </p>
     * 
     * @return The additional attributes of a Amazon DataZone inventory asset.
     */
    public final AssetItemAdditionalAttributes additionalAttributes() {
        return additionalAttributes;
    }

    /**
     * <p>
     * The timestamp of when the Amazon DataZone inventory asset was created.
     * </p>
     * 
     * @return The timestamp of when the Amazon DataZone inventory asset was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the inventory asset.
     * </p>
     * 
     * @return The Amazon DataZone user who created the inventory asset.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of an Amazon DataZone inventory asset.
     * </p>
     * 
     * @return The description of an Amazon DataZone inventory asset.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the inventory asset exists.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which the inventory asset exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The external identifier of the Amazon DataZone inventory asset.
     * </p>
     * 
     * @return The external identifier of the Amazon DataZone inventory asset.
     */
    public final String externalIdentifier() {
        return externalIdentifier;
    }

    /**
     * <p>
     * The timestamp of when the first revision of the inventory asset was created.
     * </p>
     * 
     * @return The timestamp of when the first revision of the inventory asset was created.
     */
    public final Instant firstRevisionCreatedAt() {
        return firstRevisionCreatedAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the first revision of the inventory asset.
     * </p>
     * 
     * @return The Amazon DataZone user who created the first revision of the inventory asset.
     */
    public final String firstRevisionCreatedBy() {
        return firstRevisionCreatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms attached to the Amazon DataZone inventory asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms attached to the Amazon DataZone inventory asset.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * the identifier of the Amazon DataZone inventory asset.
     * </p>
     * 
     * @return the identifier of the Amazon DataZone inventory asset.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the Amazon DataZone inventory asset.
     * </p>
     * 
     * @return The name of the Amazon DataZone inventory asset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone project that owns the inventory asset.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone project that owns the inventory asset.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * <p>
     * The identifier of the asset type of the specified Amazon DataZone inventory asset.
     * </p>
     * 
     * @return The identifier of the asset type of the specified Amazon DataZone inventory asset.
     */
    public final String typeIdentifier() {
        return typeIdentifier;
    }

    /**
     * <p>
     * The revision of the inventory asset type.
     * </p>
     * 
     * @return The revision of the inventory asset type.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(externalIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(firstRevisionCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetItem)) {
            return false;
        }
        AssetItem other = (AssetItem) obj;
        return Objects.equals(additionalAttributes(), other.additionalAttributes())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(externalIdentifier(), other.externalIdentifier())
                && Objects.equals(firstRevisionCreatedAt(), other.firstRevisionCreatedAt())
                && Objects.equals(firstRevisionCreatedBy(), other.firstRevisionCreatedBy())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectId(), other.owningProjectId())
                && Objects.equals(typeIdentifier(), other.typeIdentifier())
                && Objects.equals(typeRevision(), other.typeRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetItem").add("AdditionalAttributes", additionalAttributes()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("ExternalIdentifier", externalIdentifier() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FirstRevisionCreatedAt", firstRevisionCreatedAt()).add("FirstRevisionCreatedBy", firstRevisionCreatedBy())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Identifier", identifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectId", owningProjectId())
                .add("TypeIdentifier", typeIdentifier()).add("TypeRevision", typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "externalIdentifier":
            return Optional.ofNullable(clazz.cast(externalIdentifier()));
        case "firstRevisionCreatedAt":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedAt()));
        case "firstRevisionCreatedBy":
            return Optional.ofNullable(clazz.cast(firstRevisionCreatedBy()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "typeIdentifier":
            return Optional.ofNullable(clazz.cast(typeIdentifier()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetItem, T> g) {
        return obj -> g.apply((AssetItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetItem> {
        /**
         * <p>
         * The additional attributes of a Amazon DataZone inventory asset.
         * </p>
         * 
         * @param additionalAttributes
         *        The additional attributes of a Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(AssetItemAdditionalAttributes additionalAttributes);

        /**
         * <p>
         * The additional attributes of a Amazon DataZone inventory asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetItemAdditionalAttributes.Builder}
         * avoiding the need to create one manually via {@link AssetItemAdditionalAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetItemAdditionalAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalAttributes(AssetItemAdditionalAttributes)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on {@link AssetItemAdditionalAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(AssetItemAdditionalAttributes)
         */
        default Builder additionalAttributes(Consumer<AssetItemAdditionalAttributes.Builder> additionalAttributes) {
            return additionalAttributes(AssetItemAdditionalAttributes.builder().applyMutation(additionalAttributes).build());
        }

        /**
         * <p>
         * The timestamp of when the Amazon DataZone inventory asset was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the Amazon DataZone inventory asset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the inventory asset.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of an Amazon DataZone inventory asset.
         * </p>
         * 
         * @param description
         *        The description of an Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which the inventory asset exists.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which the inventory asset exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The external identifier of the Amazon DataZone inventory asset.
         * </p>
         * 
         * @param externalIdentifier
         *        The external identifier of the Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalIdentifier(String externalIdentifier);

        /**
         * <p>
         * The timestamp of when the first revision of the inventory asset was created.
         * </p>
         * 
         * @param firstRevisionCreatedAt
         *        The timestamp of when the first revision of the inventory asset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt);

        /**
         * <p>
         * The Amazon DataZone user who created the first revision of the inventory asset.
         * </p>
         * 
         * @param firstRevisionCreatedBy
         *        The Amazon DataZone user who created the first revision of the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstRevisionCreatedBy(String firstRevisionCreatedBy);

        /**
         * <p>
         * The glossary terms attached to the Amazon DataZone inventory asset.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to the Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The glossary terms attached to the Amazon DataZone inventory asset.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms attached to the Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * the identifier of the Amazon DataZone inventory asset.
         * </p>
         * 
         * @param identifier
         *        the identifier of the Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the Amazon DataZone inventory asset.
         * </p>
         * 
         * @param name
         *        The name of the Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the Amazon DataZone project that owns the inventory asset.
         * </p>
         * 
         * @param owningProjectId
         *        The identifier of the Amazon DataZone project that owns the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * The identifier of the asset type of the specified Amazon DataZone inventory asset.
         * </p>
         * 
         * @param typeIdentifier
         *        The identifier of the asset type of the specified Amazon DataZone inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeIdentifier(String typeIdentifier);

        /**
         * <p>
         * The revision of the inventory asset type.
         * </p>
         * 
         * @param typeRevision
         *        The revision of the inventory asset type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);
    }

    static final class BuilderImpl implements Builder {
        private AssetItemAdditionalAttributes additionalAttributes;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private String externalIdentifier;

        private Instant firstRevisionCreatedAt;

        private String firstRevisionCreatedBy;

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String identifier;

        private String name;

        private String owningProjectId;

        private String typeIdentifier;

        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetItem model) {
            additionalAttributes(model.additionalAttributes);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            externalIdentifier(model.externalIdentifier);
            firstRevisionCreatedAt(model.firstRevisionCreatedAt);
            firstRevisionCreatedBy(model.firstRevisionCreatedBy);
            glossaryTerms(model.glossaryTerms);
            identifier(model.identifier);
            name(model.name);
            owningProjectId(model.owningProjectId);
            typeIdentifier(model.typeIdentifier);
            typeRevision(model.typeRevision);
        }

        public final AssetItemAdditionalAttributes.Builder getAdditionalAttributes() {
            return additionalAttributes != null ? additionalAttributes.toBuilder() : null;
        }

        public final void setAdditionalAttributes(AssetItemAdditionalAttributes.BuilderImpl additionalAttributes) {
            this.additionalAttributes = additionalAttributes != null ? additionalAttributes.build() : null;
        }

        @Override
        public final Builder additionalAttributes(AssetItemAdditionalAttributes additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getExternalIdentifier() {
            return externalIdentifier;
        }

        public final void setExternalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
        }

        @Override
        public final Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public final Instant getFirstRevisionCreatedAt() {
            return firstRevisionCreatedAt;
        }

        public final void setFirstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
        }

        @Override
        public final Builder firstRevisionCreatedAt(Instant firstRevisionCreatedAt) {
            this.firstRevisionCreatedAt = firstRevisionCreatedAt;
            return this;
        }

        public final String getFirstRevisionCreatedBy() {
            return firstRevisionCreatedBy;
        }

        public final void setFirstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
        }

        @Override
        public final Builder firstRevisionCreatedBy(String firstRevisionCreatedBy) {
            this.firstRevisionCreatedBy = firstRevisionCreatedBy;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getTypeIdentifier() {
            return typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public AssetItem build() {
            return new AssetItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
