/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentProfileRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateEnvironmentProfileRequest.Builder, CreateEnvironmentProfileRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(CreateEnvironmentProfileRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountRegion").getter(getter(CreateEnvironmentProfileRequest::awsAccountRegion))
            .setter(setter(Builder::awsAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountRegion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentProfileRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateEnvironmentProfileRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintIdentifier")
            .getter(getter(CreateEnvironmentProfileRequest::environmentBlueprintIdentifier))
            .setter(setter(Builder::environmentBlueprintIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintIdentifier")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(CreateEnvironmentProfileRequest::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectIdentifier").build()).build();

    private static final SdkField<List<EnvironmentParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<EnvironmentParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(CreateEnvironmentProfileRequest::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_REGION_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD,
            NAME_FIELD, PROJECT_IDENTIFIER_FIELD, USER_PARAMETERS_FIELD));

    private final String awsAccountId;

    private final String awsAccountRegion;

    private final String description;

    private final String domainIdentifier;

    private final String environmentBlueprintIdentifier;

    private final String name;

    private final String projectIdentifier;

    private final List<EnvironmentParameter> userParameters;

    private CreateEnvironmentProfileRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.name = builder.name;
        this.projectIdentifier = builder.projectIdentifier;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * The Amazon Web Services account in which the Amazon DataZone environment is created.
     * </p>
     * 
     * @return The Amazon Web Services account in which the Amazon DataZone environment is created.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services region in which this environment profile is created.
     * </p>
     * 
     * @return The Amazon Web Services region in which this environment profile is created.
     */
    public final String awsAccountRegion() {
        return awsAccountRegion;
    }

    /**
     * <p>
     * The description of this Amazon DataZone environment profile.
     * </p>
     * 
     * @return The description of this Amazon DataZone environment profile.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this environment profile is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this environment profile is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the blueprint with which this environment profile is created.
     * </p>
     * 
     * @return The ID of the blueprint with which this environment profile is created.
     */
    public final String environmentBlueprintIdentifier() {
        return environmentBlueprintIdentifier;
    }

    /**
     * <p>
     * The name of this Amazon DataZone environment profile.
     * </p>
     * 
     * @return The name of this Amazon DataZone environment profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the project in which to create the environment profile.
     * </p>
     * 
     * @return The identifier of the project in which to create the environment profile.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters of this Amazon DataZone environment profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters of this Amazon DataZone environment profile.
     */
    public final List<EnvironmentParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentProfileRequest)) {
            return false;
        }
        CreateEnvironmentProfileRequest other = (CreateEnvironmentProfileRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountRegion(), other.awsAccountRegion())
                && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier())
                && Objects.equals(name(), other.name()) && Objects.equals(projectIdentifier(), other.projectIdentifier())
                && hasUserParameters() == other.hasUserParameters() && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentProfileRequest").add("AwsAccountId", awsAccountId())
                .add("AwsAccountRegion", awsAccountRegion())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentBlueprintIdentifier", environmentBlueprintIdentifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectIdentifier", projectIdentifier())
                .add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountRegion":
            return Optional.ofNullable(clazz.cast(awsAccountRegion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentBlueprintIdentifier":
            return Optional.ofNullable(clazz.cast(environmentBlueprintIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentProfileRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentProfileRequest> {
        /**
         * <p>
         * The Amazon Web Services account in which the Amazon DataZone environment is created.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account in which the Amazon DataZone environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services region in which this environment profile is created.
         * </p>
         * 
         * @param awsAccountRegion
         *        The Amazon Web Services region in which this environment profile is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountRegion(String awsAccountRegion);

        /**
         * <p>
         * The description of this Amazon DataZone environment profile.
         * </p>
         * 
         * @param description
         *        The description of this Amazon DataZone environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this environment profile is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which this environment profile is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the blueprint with which this environment profile is created.
         * </p>
         * 
         * @param environmentBlueprintIdentifier
         *        The ID of the blueprint with which this environment profile is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier);

        /**
         * <p>
         * The name of this Amazon DataZone environment profile.
         * </p>
         * 
         * @param name
         *        The name of this Amazon DataZone environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the project in which to create the environment profile.
         * </p>
         * 
         * @param projectIdentifier
         *        The identifier of the project in which to create the environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment profile.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<EnvironmentParameter> userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment profile.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(EnvironmentParameter... userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #userParameters(List<EnvironmentParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<EnvironmentParameter>)
         */
        Builder userParameters(Consumer<EnvironmentParameter.Builder>... userParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountRegion;

        private String description;

        private String domainIdentifier;

        private String environmentBlueprintIdentifier;

        private String name;

        private String projectIdentifier;

        private List<EnvironmentParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentProfileRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            awsAccountRegion(model.awsAccountRegion);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            name(model.name);
            projectIdentifier(model.projectIdentifier);
            userParameters(model.userParameters);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getUserParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<EnvironmentParameter.BuilderImpl> userParameters) {
            this.userParameters = EnvironmentParametersListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<EnvironmentParameter> userParameters) {
            this.userParameters = EnvironmentParametersListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(EnvironmentParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<EnvironmentParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters).map(c -> EnvironmentParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentProfileRequest build() {
            return new CreateEnvironmentProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
