/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectSubscriptionRequestRequest extends DataZoneRequest implements
        ToCopyableBuilder<RejectSubscriptionRequestRequest.Builder, RejectSubscriptionRequestRequest> {
    private static final SdkField<String> DECISION_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decisionComment").getter(getter(RejectSubscriptionRequestRequest::decisionComment))
            .setter(setter(Builder::decisionComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionComment").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(RejectSubscriptionRequestRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(RejectSubscriptionRequestRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECISION_COMMENT_FIELD,
            DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD));

    private final String decisionComment;

    private final String domainIdentifier;

    private final String identifier;

    private RejectSubscriptionRequestRequest(BuilderImpl builder) {
        super(builder);
        this.decisionComment = builder.decisionComment;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * The decision comment of the rejected subscription request.
     * </p>
     * 
     * @return The decision comment of the rejected subscription request.
     */
    public final String decisionComment() {
        return decisionComment;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which the subscription request was rejected.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the subscription request that was rejected.
     * </p>
     * 
     * @return The identifier of the subscription request that was rejected.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(decisionComment());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectSubscriptionRequestRequest)) {
            return false;
        }
        RejectSubscriptionRequestRequest other = (RejectSubscriptionRequestRequest) obj;
        return Objects.equals(decisionComment(), other.decisionComment())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectSubscriptionRequestRequest")
                .add("DecisionComment", decisionComment() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "decisionComment":
            return Optional.ofNullable(clazz.cast(decisionComment()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectSubscriptionRequestRequest, T> g) {
        return obj -> g.apply((RejectSubscriptionRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, RejectSubscriptionRequestRequest> {
        /**
         * <p>
         * The decision comment of the rejected subscription request.
         * </p>
         * 
         * @param decisionComment
         *        The decision comment of the rejected subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionComment(String decisionComment);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which the subscription request was rejected.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which the subscription request was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the subscription request that was rejected.
         * </p>
         * 
         * @param identifier
         *        The identifier of the subscription request that was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String decisionComment;

        private String domainIdentifier;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectSubscriptionRequestRequest model) {
            super(model);
            decisionComment(model.decisionComment);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
        }

        public final String getDecisionComment() {
            return decisionComment;
        }

        public final void setDecisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
        }

        @Override
        public final Builder decisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectSubscriptionRequestRequest build() {
            return new RejectSubscriptionRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
