/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the published asset for which the subscription grant is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedListing implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedListing.Builder, SubscribedListing> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SubscribedListing::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SubscribedListing::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<SubscribedListingItem> ITEM_FIELD = SdkField
            .<SubscribedListingItem> builder(MarshallingType.SDK_POJO).memberName("item").getter(getter(SubscribedListing::item))
            .setter(setter(Builder::item)).constructor(SubscribedListingItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SubscribedListing::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerProjectId").getter(getter(SubscribedListing::ownerProjectId))
            .setter(setter(Builder::ownerProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerProjectId").build()).build();

    private static final SdkField<String> OWNER_PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerProjectName").getter(getter(SubscribedListing::ownerProjectName))
            .setter(setter(Builder::ownerProjectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerProjectName").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(SubscribedListing::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ID_FIELD,
            ITEM_FIELD, NAME_FIELD, OWNER_PROJECT_ID_FIELD, OWNER_PROJECT_NAME_FIELD, REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String id;

    private final SubscribedListingItem item;

    private final String name;

    private final String ownerProjectId;

    private final String ownerProjectName;

    private final String revision;

    private SubscribedListing(BuilderImpl builder) {
        this.description = builder.description;
        this.id = builder.id;
        this.item = builder.item;
        this.name = builder.name;
        this.ownerProjectId = builder.ownerProjectId;
        this.ownerProjectName = builder.ownerProjectName;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The description of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The description of the published asset for which the subscription grant is created.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The identifier of the published asset for which the subscription grant is created.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The published asset for which the subscription grant is created.
     */
    public final SubscribedListingItem item() {
        return item;
    }

    /**
     * <p>
     * The name of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The name of the published asset for which the subscription grant is created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the project of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The identifier of the project of the published asset for which the subscription grant is created.
     */
    public final String ownerProjectId() {
        return ownerProjectId;
    }

    /**
     * <p>
     * The name of the project that owns the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The name of the project that owns the published asset for which the subscription grant is created.
     */
    public final String ownerProjectName() {
        return ownerProjectName;
    }

    /**
     * <p>
     * The revision of the published asset for which the subscription grant is created.
     * </p>
     * 
     * @return The revision of the published asset for which the subscription grant is created.
     */
    public final String revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerProjectName());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedListing)) {
            return false;
        }
        SubscribedListing other = (SubscribedListing) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(item(), other.item()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerProjectId(), other.ownerProjectId())
                && Objects.equals(ownerProjectName(), other.ownerProjectName()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedListing")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Id", id())
                .add("Item", item()).add("Name", name()).add("OwnerProjectId", ownerProjectId())
                .add("OwnerProjectName", ownerProjectName()).add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "item":
            return Optional.ofNullable(clazz.cast(item()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ownerProjectId":
            return Optional.ofNullable(clazz.cast(ownerProjectId()));
        case "ownerProjectName":
            return Optional.ofNullable(clazz.cast(ownerProjectName()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedListing, T> g) {
        return obj -> g.apply((SubscribedListing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedListing> {
        /**
         * <p>
         * The description of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param description
         *        The description of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param id
         *        The identifier of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The published asset for which the subscription grant is created.
         * </p>
         * 
         * @param item
         *        The published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(SubscribedListingItem item);

        /**
         * <p>
         * The published asset for which the subscription grant is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedListingItem.Builder} avoiding
         * the need to create one manually via {@link SubscribedListingItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedListingItem.Builder#build()} is called immediately and
         * its result is passed to {@link #item(SubscribedListingItem)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link SubscribedListingItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(SubscribedListingItem)
         */
        default Builder item(Consumer<SubscribedListingItem.Builder> item) {
            return item(SubscribedListingItem.builder().applyMutation(item).build());
        }

        /**
         * <p>
         * The name of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param name
         *        The name of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the project of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param ownerProjectId
         *        The identifier of the project of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerProjectId(String ownerProjectId);

        /**
         * <p>
         * The name of the project that owns the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param ownerProjectName
         *        The name of the project that owns the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerProjectName(String ownerProjectName);

        /**
         * <p>
         * The revision of the published asset for which the subscription grant is created.
         * </p>
         * 
         * @param revision
         *        The revision of the published asset for which the subscription grant is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String id;

        private SubscribedListingItem item;

        private String name;

        private String ownerProjectId;

        private String ownerProjectName;

        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedListing model) {
            description(model.description);
            id(model.id);
            item(model.item);
            name(model.name);
            ownerProjectId(model.ownerProjectId);
            ownerProjectName(model.ownerProjectName);
            revision(model.revision);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SubscribedListingItem.Builder getItem() {
            return item != null ? item.toBuilder() : null;
        }

        public final void setItem(SubscribedListingItem.BuilderImpl item) {
            this.item = item != null ? item.build() : null;
        }

        @Override
        public final Builder item(SubscribedListingItem item) {
            this.item = item;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerProjectId() {
            return ownerProjectId;
        }

        public final void setOwnerProjectId(String ownerProjectId) {
            this.ownerProjectId = ownerProjectId;
        }

        @Override
        public final Builder ownerProjectId(String ownerProjectId) {
            this.ownerProjectId = ownerProjectId;
            return this;
        }

        public final String getOwnerProjectName() {
            return ownerProjectName;
        }

        public final void setOwnerProjectName(String ownerProjectName) {
            this.ownerProjectName = ownerProjectName;
        }

        @Override
        public final Builder ownerProjectName(String ownerProjectName) {
            this.ownerProjectName = ownerProjectName;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public SubscribedListing build() {
            return new SubscribedListing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
