/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The principal that is to be given a subscriptiong grant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedPrincipalInput implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedPrincipalInput.Builder, SubscribedPrincipalInput> {
    private static final SdkField<SubscribedProjectInput> PROJECT_FIELD = SdkField
            .<SubscribedProjectInput> builder(MarshallingType.SDK_POJO).memberName("project")
            .getter(getter(SubscribedPrincipalInput::project)).setter(setter(Builder::project))
            .constructor(SubscribedProjectInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SubscribedProjectInput project;

    private final Type type;

    private SubscribedPrincipalInput(BuilderImpl builder) {
        this.project = builder.project;
        this.type = builder.type;
    }

    /**
     * <p>
     * The project that is to be given a subscription grant.
     * </p>
     * 
     * @return The project that is to be given a subscription grant.
     */
    public final SubscribedProjectInput project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedPrincipalInput)) {
            return false;
        }
        SubscribedPrincipalInput other = (SubscribedPrincipalInput) obj;
        return Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubscribedPrincipalInput").add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project that is to be given a subscription grant.
     * </p>
     * 
     * @param project
     *        The project that is to be given a subscription grant.
     */
    public static SubscribedPrincipalInput fromProject(SubscribedProjectInput project) {
        return builder().project(project).build();
    }

    /**
     * Create an instance of this class with {@link #project()} initialized to the given value.
     *
     * <p>
     * The project that is to be given a subscription grant.
     * </p>
     * 
     * @param project
     *        The project that is to be given a subscription grant.
     */
    public static SubscribedPrincipalInput fromProject(Consumer<SubscribedProjectInput.Builder> project) {
        SubscribedProjectInput.Builder builder = SubscribedProjectInput.builder();
        project.accept(builder);
        return fromProject(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedPrincipalInput, T> g) {
        return obj -> g.apply((SubscribedPrincipalInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedPrincipalInput> {
        /**
         * <p>
         * The project that is to be given a subscription grant.
         * </p>
         * 
         * @param project
         *        The project that is to be given a subscription grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(SubscribedProjectInput project);

        /**
         * <p>
         * The project that is to be given a subscription grant.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscribedProjectInput.Builder} avoiding
         * the need to create one manually via {@link SubscribedProjectInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscribedProjectInput.Builder#build()} is called immediately and
         * its result is passed to {@link #project(SubscribedProjectInput)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link SubscribedProjectInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(SubscribedProjectInput)
         */
        default Builder project(Consumer<SubscribedProjectInput.Builder> project) {
            return project(SubscribedProjectInput.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SubscribedProjectInput project;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedPrincipalInput model) {
            project(model.project);
        }

        public final SubscribedProjectInput.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(SubscribedProjectInput.BuilderImpl project) {
            Object oldValue = this.project;
            this.project = project != null ? project.build() : null;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(SubscribedProjectInput project) {
            Object oldValue = this.project;
            this.project = project;
            handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        @Override
        public SubscribedPrincipalInput build() {
            return new SubscribedPrincipalInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SubscribedPrincipalInput#type()
     */
    public enum Type {
        PROJECT,

        UNKNOWN_TO_SDK_VERSION
    }
}
