/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFeedbackResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeFeedbackResponse.Builder, DescribeFeedbackResponse> {
    private static final SdkField<InsightFeedback> INSIGHT_FEEDBACK_FIELD = SdkField
            .<InsightFeedback> builder(MarshallingType.SDK_POJO).memberName("InsightFeedback")
            .getter(getter(DescribeFeedbackResponse::insightFeedback)).setter(setter(Builder::insightFeedback))
            .constructor(InsightFeedback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightFeedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_FEEDBACK_FIELD));

    private final InsightFeedback insightFeedback;

    private DescribeFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.insightFeedback = builder.insightFeedback;
    }

    /**
     * Returns the value of the InsightFeedback property for this object.
     * 
     * @return The value of the InsightFeedback property for this object.
     */
    public final InsightFeedback insightFeedback() {
        return insightFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeedbackResponse)) {
            return false;
        }
        DescribeFeedbackResponse other = (DescribeFeedbackResponse) obj;
        return Objects.equals(insightFeedback(), other.insightFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFeedbackResponse").add("InsightFeedback", insightFeedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightFeedback":
            return Optional.ofNullable(clazz.cast(insightFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeedbackResponse, T> g) {
        return obj -> g.apply((DescribeFeedbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFeedbackResponse> {
        /**
         * Sets the value of the InsightFeedback property for this object.
         *
         * @param insightFeedback
         *        The new value for the InsightFeedback property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightFeedback(InsightFeedback insightFeedback);

        /**
         * Sets the value of the InsightFeedback property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InsightFeedback.Builder} avoiding the
         * need to create one manually via {@link InsightFeedback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightFeedback.Builder#build()} is called immediately and its
         * result is passed to {@link #insightFeedback(InsightFeedback)}.
         * 
         * @param insightFeedback
         *        a consumer that will call methods on {@link InsightFeedback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightFeedback(InsightFeedback)
         */
        default Builder insightFeedback(Consumer<InsightFeedback.Builder> insightFeedback) {
            return insightFeedback(InsightFeedback.builder().applyMutation(insightFeedback).build());
        }
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private InsightFeedback insightFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeedbackResponse model) {
            super(model);
            insightFeedback(model.insightFeedback);
        }

        public final InsightFeedback.Builder getInsightFeedback() {
            return insightFeedback != null ? insightFeedback.toBuilder() : null;
        }

        public final void setInsightFeedback(InsightFeedback.BuilderImpl insightFeedback) {
            this.insightFeedback = insightFeedback != null ? insightFeedback.build() : null;
        }

        @Override
        public final Builder insightFeedback(InsightFeedback insightFeedback) {
            this.insightFeedback = insightFeedback;
            return this;
        }

        @Override
        public DescribeFeedbackResponse build() {
            return new DescribeFeedbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
