/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceCollectionHealthResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeResourceCollectionHealthResponse.Builder, DescribeResourceCollectionHealthResponse> {
    private static final SdkField<List<CloudFormationHealth>> CLOUD_FORMATION_FIELD = SdkField
            .<List<CloudFormationHealth>> builder(MarshallingType.LIST)
            .memberName("CloudFormation")
            .getter(getter(DescribeResourceCollectionHealthResponse::cloudFormation))
            .setter(setter(Builder::cloudFormation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudFormationHealth> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudFormationHealth::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceHealth>> SERVICE_FIELD = SdkField
            .<List<ServiceHealth>> builder(MarshallingType.LIST)
            .memberName("Service")
            .getter(getter(DescribeResourceCollectionHealthResponse::service))
            .setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceHealth> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceHealth::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeResourceCollectionHealthResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TagHealth>> TAGS_FIELD = SdkField
            .<List<TagHealth>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribeResourceCollectionHealthResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagHealth> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagHealth::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD,
            SERVICE_FIELD, NEXT_TOKEN_FIELD, TAGS_FIELD));

    private final List<CloudFormationHealth> cloudFormation;

    private final List<ServiceHealth> service;

    private final String nextToken;

    private final List<TagHealth> tags;

    private DescribeResourceCollectionHealthResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFormation = builder.cloudFormation;
        this.service = builder.service;
        this.nextToken = builder.nextToken;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudFormation property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCloudFormation() {
        return cloudFormation != null && !(cloudFormation instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned <code>CloudFormationHealthOverview</code> object that contains an <code>InsightHealthOverview</code>
     * object with the requested system health information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudFormation} method.
     * </p>
     * 
     * @return The returned <code>CloudFormationHealthOverview</code> object that contains an
     *         <code>InsightHealthOverview</code> object with the requested system health information.
     */
    public final List<CloudFormationHealth> cloudFormation() {
        return cloudFormation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Service property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasService() {
        return service != null && !(service instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services
     * associated with the resources in the collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasService} method.
     * </p>
     * 
     * @return An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services
     *         services associated with the resources in the collection.
     */
    public final List<ServiceHealth> service() {
        return service;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services tags that are used by resources in the resource collection.
     * </p>
     * <p>
     * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support
     * tagging, so you can assign the same tag to resources from different services to indicate that the resources are
     * related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an
     * Lambda function. For more information about using tags, see the <a
     * href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper.
     * </p>
     * <p>
     * Each Amazon Web Services tag has two parts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
     * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>,
     * or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag
     * <i>values</i> are case-sensitive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Together these are known as <i>key</i>-<i>value</i> pairs.
     * </p>
     * <important>
     * <p>
     * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
     * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code> or
     * <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the <i>key</i>
     * can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works
     * with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and
     * these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     * <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>
     * .
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The Amazon Web Services tags that are used by resources in the resource collection.</p>
     *         <p>
     *         Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
     *         support tagging, so you can assign the same tag to resources from different services to indicate that the
     *         resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that
     *         you assign to an Lambda function. For more information about using tags, see the <a
     *         href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a>
     *         whitepaper.
     *         </p>
     *         <p>
     *         Each Amazon Web Services tag has two parts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>,
     *         or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
     *         <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty
     *         string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Together these are known as <i>key</i>-<i>value</i> pairs.
     *         </p>
     *         <important>
     *         <p>
     *         The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with
     *         the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
     *         <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
     *         create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
     *         create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
     *         <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
     *         different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     *         <code>Devops-Guru-production-application/RDS</code> or
     *         <code>Devops-Guru-production-application/containers</code>.
     *         </p>
     */
    public final List<TagHealth> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudFormation() ? cloudFormation() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasService() ? service() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceCollectionHealthResponse)) {
            return false;
        }
        DescribeResourceCollectionHealthResponse other = (DescribeResourceCollectionHealthResponse) obj;
        return hasCloudFormation() == other.hasCloudFormation() && Objects.equals(cloudFormation(), other.cloudFormation())
                && hasService() == other.hasService() && Objects.equals(service(), other.service())
                && Objects.equals(nextToken(), other.nextToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourceCollectionHealthResponse")
                .add("CloudFormation", hasCloudFormation() ? cloudFormation() : null)
                .add("Service", hasService() ? service() : null).add("NextToken", nextToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFormation":
            return Optional.ofNullable(clazz.cast(cloudFormation()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceCollectionHealthResponse, T> g) {
        return obj -> g.apply((DescribeResourceCollectionHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourceCollectionHealthResponse> {
        /**
         * <p>
         * The returned <code>CloudFormationHealthOverview</code> object that contains an
         * <code>InsightHealthOverview</code> object with the requested system health information.
         * </p>
         * 
         * @param cloudFormation
         *        The returned <code>CloudFormationHealthOverview</code> object that contains an
         *        <code>InsightHealthOverview</code> object with the requested system health information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(Collection<CloudFormationHealth> cloudFormation);

        /**
         * <p>
         * The returned <code>CloudFormationHealthOverview</code> object that contains an
         * <code>InsightHealthOverview</code> object with the requested system health information.
         * </p>
         * 
         * @param cloudFormation
         *        The returned <code>CloudFormationHealthOverview</code> object that contains an
         *        <code>InsightHealthOverview</code> object with the requested system health information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(CloudFormationHealth... cloudFormation);

        /**
         * <p>
         * The returned <code>CloudFormationHealthOverview</code> object that contains an
         * <code>InsightHealthOverview</code> object with the requested system health information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudFormation(List<CloudFormationHealth>)}.
         * 
         * @param cloudFormation
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormation(java.util.Collection<CloudFormationHealth>)
         */
        Builder cloudFormation(Consumer<CloudFormationHealth.Builder>... cloudFormation);

        /**
         * <p>
         * An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services
         * associated with the resources in the collection.
         * </p>
         * 
         * @param service
         *        An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services
         *        services associated with the resources in the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Collection<ServiceHealth> service);

        /**
         * <p>
         * An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services
         * associated with the resources in the collection.
         * </p>
         * 
         * @param service
         *        An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services
         *        services associated with the resources in the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(ServiceHealth... service);

        /**
         * <p>
         * An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services
         * associated with the resources in the collection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.ServiceHealth.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.devopsguru.model.ServiceHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.ServiceHealth.Builder#build()} is called immediately
         * and its result is passed to {@link #service(List<ServiceHealth>)}.
         * 
         * @param service
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.ServiceHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(java.util.Collection<ServiceHealth>)
         */
        Builder service(Consumer<ServiceHealth.Builder>... service);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Web Services tags that are used by resources in the resource collection.
         * </p>
         * <p>
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
         * support tagging, so you can assign the same tag to resources from different services to indicate that the
         * resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you
         * assign to an Lambda function. For more information about using tags, see the <a
         * href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a>
         * whitepaper.
         * </p>
         * <p>
         * Each Amazon Web Services tag has two parts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
         * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         * <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string.
         * Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Together these are known as <i>key</i>-<i>value</i> pairs.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important>
         * 
         * @param tags
         *        The Amazon Web Services tags that are used by resources in the resource collection.</p>
         *        <p>
         *        Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services
         *        services support tagging, so you can assign the same tag to resources from different services to
         *        indicate that the resources are related. For example, you can assign the same tag to an Amazon
         *        DynamoDB table resource that you assign to an Lambda function. For more information about using tags,
         *        see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best
         *        practices</a> whitepaper.
         *        </p>
         *        <p>
         *        Each Amazon Web Services tag has two parts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>
         *        , or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         *        <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty
         *        string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Together these are known as <i>key</i>-<i>value</i> pairs.
         *        </p>
         *        <important>
         *        <p>
         *        The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin
         *        with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
         *        <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
         *        create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
         *        create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
         *        <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
         *        different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
         *        <code>Devops-Guru-production-application/RDS</code> or
         *        <code>Devops-Guru-production-application/containers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagHealth> tags);

        /**
         * <p>
         * The Amazon Web Services tags that are used by resources in the resource collection.
         * </p>
         * <p>
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
         * support tagging, so you can assign the same tag to resources from different services to indicate that the
         * resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you
         * assign to an Lambda function. For more information about using tags, see the <a
         * href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a>
         * whitepaper.
         * </p>
         * <p>
         * Each Amazon Web Services tag has two parts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
         * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         * <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string.
         * Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Together these are known as <i>key</i>-<i>value</i> pairs.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important>
         * 
         * @param tags
         *        The Amazon Web Services tags that are used by resources in the resource collection.</p>
         *        <p>
         *        Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services
         *        services support tagging, so you can assign the same tag to resources from different services to
         *        indicate that the resources are related. For example, you can assign the same tag to an Amazon
         *        DynamoDB table resource that you assign to an Lambda function. For more information about using tags,
         *        see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best
         *        practices</a> whitepaper.
         *        </p>
         *        <p>
         *        Each Amazon Web Services tag has two parts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>
         *        , or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         *        <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty
         *        string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Together these are known as <i>key</i>-<i>value</i> pairs.
         *        </p>
         *        <important>
         *        <p>
         *        The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin
         *        with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
         *        <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
         *        create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
         *        create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
         *        <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
         *        different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
         *        <code>Devops-Guru-production-application/RDS</code> or
         *        <code>Devops-Guru-production-application/containers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagHealth... tags);

        /**
         * <p>
         * The Amazon Web Services tags that are used by resources in the resource collection.
         * </p>
         * <p>
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
         * support tagging, so you can assign the same tag to resources from different services to indicate that the
         * resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you
         * assign to an Lambda function. For more information about using tags, see the <a
         * href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a>
         * whitepaper.
         * </p>
         * <p>
         * Each Amazon Web Services tag has two parts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
         * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         * <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string.
         * Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Together these are known as <i>key</i>-<i>value</i> pairs.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.TagHealth.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.devopsguru.model.TagHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.TagHealth.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagHealth>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.TagHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagHealth>)
         */
        Builder tags(Consumer<TagHealth.Builder>... tags);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private List<CloudFormationHealth> cloudFormation = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceHealth> service = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<TagHealth> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceCollectionHealthResponse model) {
            super(model);
            cloudFormation(model.cloudFormation);
            service(model.service);
            nextToken(model.nextToken);
            tags(model.tags);
        }

        public final List<CloudFormationHealth.Builder> getCloudFormation() {
            List<CloudFormationHealth.Builder> result = CloudFormationHealthsCopier.copyToBuilder(this.cloudFormation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudFormation(Collection<CloudFormationHealth.BuilderImpl> cloudFormation) {
            this.cloudFormation = CloudFormationHealthsCopier.copyFromBuilder(cloudFormation);
        }

        @Override
        public final Builder cloudFormation(Collection<CloudFormationHealth> cloudFormation) {
            this.cloudFormation = CloudFormationHealthsCopier.copy(cloudFormation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudFormation(CloudFormationHealth... cloudFormation) {
            cloudFormation(Arrays.asList(cloudFormation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudFormation(Consumer<CloudFormationHealth.Builder>... cloudFormation) {
            cloudFormation(Stream.of(cloudFormation).map(c -> CloudFormationHealth.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceHealth.Builder> getService() {
            List<ServiceHealth.Builder> result = ServiceHealthsCopier.copyToBuilder(this.service);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setService(Collection<ServiceHealth.BuilderImpl> service) {
            this.service = ServiceHealthsCopier.copyFromBuilder(service);
        }

        @Override
        public final Builder service(Collection<ServiceHealth> service) {
            this.service = ServiceHealthsCopier.copy(service);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder service(ServiceHealth... service) {
            service(Arrays.asList(service));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder service(Consumer<ServiceHealth.Builder>... service) {
            service(Stream.of(service).map(c -> ServiceHealth.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TagHealth.Builder> getTags() {
            List<TagHealth.Builder> result = TagHealthsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagHealth.BuilderImpl> tags) {
            this.tags = TagHealthsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagHealth> tags) {
            this.tags = TagHealthsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagHealth... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagHealth.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagHealth.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeResourceCollectionHealthResponse build() {
            return new DescribeResourceCollectionHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
