/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about notification channels you have configured with DevOps Guru. The one supported notification channel
 * is Amazon Simple Notification Service (Amazon SNS).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationChannelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationChannelConfig.Builder, NotificationChannelConfig> {
    private static final SdkField<SnsChannelConfig> SNS_FIELD = SdkField.<SnsChannelConfig> builder(MarshallingType.SDK_POJO)
            .memberName("Sns").getter(getter(NotificationChannelConfig::sns)).setter(setter(Builder::sns))
            .constructor(SnsChannelConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sns").build()).build();

    private static final SdkField<NotificationFilterConfig> FILTERS_FIELD = SdkField
            .<NotificationFilterConfig> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(NotificationChannelConfig::filters)).setter(setter(Builder::filters))
            .constructor(NotificationFilterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_FIELD, FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SnsChannelConfig sns;

    private final NotificationFilterConfig filters;

    private NotificationChannelConfig(BuilderImpl builder) {
        this.sns = builder.sns;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * Information about a notification channel configured in DevOps Guru to send notifications when insights are
     * created.
     * </p>
     * <p>
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     * permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using
     * Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for
     * cross account Amazon SNS topics</a>.
     * </p>
     * <p>
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     * permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using
     * Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
     * </p>
     * <p>
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
     * customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon
     * Web Services KMS–encrypted Amazon SNS topics</a>.
     * </p>
     * 
     * @return Information about a notification channel configured in DevOps Guru to send notifications when insights
     *         are created. </p>
     *         <p>
     *         If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     *         permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications
     *         using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information,
     *         see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">
     *         Permissions for cross account Amazon SNS topics</a>.
     *         </p>
     *         <p>
     *         If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     *         permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications
     *         using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS
     *         topics.
     *         </p>
     *         <p>
     *         If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
     *         customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
     *         href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
     *         Amazon Web Services KMS–encrypted Amazon SNS topics</a>.
     */
    public final SnsChannelConfig sns() {
        return sns;
    }

    /**
     * <p>
     * The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide
     * filter configurations, the default configurations are to receive notifications for all message types of
     * <code>High</code> or <code>Medium</code> severity.
     * </p>
     * 
     * @return The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not
     *         provide filter configurations, the default configurations are to receive notifications for all message
     *         types of <code>High</code> or <code>Medium</code> severity.
     */
    public final NotificationFilterConfig filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sns());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationChannelConfig)) {
            return false;
        }
        NotificationChannelConfig other = (NotificationChannelConfig) obj;
        return Objects.equals(sns(), other.sns()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationChannelConfig").add("Sns", sns()).add("Filters", filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sns":
            return Optional.ofNullable(clazz.cast(sns()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationChannelConfig, T> g) {
        return obj -> g.apply((NotificationChannelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationChannelConfig> {
        /**
         * <p>
         * Information about a notification channel configured in DevOps Guru to send notifications when insights are
         * created.
         * </p>
         * <p>
         * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
         * permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications
         * using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
         * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for
         * cross account Amazon SNS topics</a>.
         * </p>
         * <p>
         * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
         * permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications
         * using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
         * </p>
         * <p>
         * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
         * customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
         * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
         * Amazon Web Services KMS–encrypted Amazon SNS topics</a>.
         * </p>
         * 
         * @param sns
         *        Information about a notification channel configured in DevOps Guru to send notifications when insights
         *        are created. </p>
         *        <p>
         *        If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps
         *        Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send
         *        notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html"
         *        >Permissions for cross account Amazon SNS topics</a>.
         *        </p>
         *        <p>
         *        If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps
         *        Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send
         *        notifications using Amazon SNS in your account. For more information, see Permissions for cross
         *        account Amazon SNS topics.
         *        </p>
         *        <p>
         *        If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
         *        customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
         *        href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions
         *        for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sns(SnsChannelConfig sns);

        /**
         * <p>
         * Information about a notification channel configured in DevOps Guru to send notifications when insights are
         * created.
         * </p>
         * <p>
         * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
         * permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications
         * using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
         * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for
         * cross account Amazon SNS topics</a>.
         * </p>
         * <p>
         * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
         * permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications
         * using Amazon SNS in your account. For more information, see Permissions for cross account Amazon SNS topics.
         * </p>
         * <p>
         * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
         * customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
         * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for
         * Amazon Web Services KMS–encrypted Amazon SNS topics</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnsChannelConfig.Builder} avoiding the
         * need to create one manually via {@link SnsChannelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnsChannelConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sns(SnsChannelConfig)}.
         * 
         * @param sns
         *        a consumer that will call methods on {@link SnsChannelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sns(SnsChannelConfig)
         */
        default Builder sns(Consumer<SnsChannelConfig.Builder> sns) {
            return sns(SnsChannelConfig.builder().applyMutation(sns).build());
        }

        /**
         * <p>
         * The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not
         * provide filter configurations, the default configurations are to receive notifications for all message types
         * of <code>High</code> or <code>Medium</code> severity.
         * </p>
         * 
         * @param filters
         *        The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do
         *        not provide filter configurations, the default configurations are to receive notifications for all
         *        message types of <code>High</code> or <code>Medium</code> severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(NotificationFilterConfig filters);

        /**
         * <p>
         * The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not
         * provide filter configurations, the default configurations are to receive notifications for all message types
         * of <code>High</code> or <code>Medium</code> severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationFilterConfig.Builder}
         * avoiding the need to create one manually via {@link NotificationFilterConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationFilterConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(NotificationFilterConfig)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link NotificationFilterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(NotificationFilterConfig)
         */
        default Builder filters(Consumer<NotificationFilterConfig.Builder> filters) {
            return filters(NotificationFilterConfig.builder().applyMutation(filters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SnsChannelConfig sns;

        private NotificationFilterConfig filters;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationChannelConfig model) {
            sns(model.sns);
            filters(model.filters);
        }

        public final SnsChannelConfig.Builder getSns() {
            return sns != null ? sns.toBuilder() : null;
        }

        public final void setSns(SnsChannelConfig.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        @Override
        public final Builder sns(SnsChannelConfig sns) {
            this.sns = sns;
            return this;
        }

        public final NotificationFilterConfig.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(NotificationFilterConfig.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(NotificationFilterConfig filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public NotificationChannelConfig build() {
            return new NotificationChannelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
