/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about updating the integration status of an Amazon Web Services service, such as Amazon Web Services
 * Systems Manager, with DevOps Guru.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceIntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateServiceIntegrationConfig.Builder, UpdateServiceIntegrationConfig> {
    private static final SdkField<OpsCenterIntegrationConfig> OPS_CENTER_FIELD = SdkField
            .<OpsCenterIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("OpsCenter")
            .getter(getter(UpdateServiceIntegrationConfig::opsCenter)).setter(setter(Builder::opsCenter))
            .constructor(OpsCenterIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenter").build()).build();

    private static final SdkField<LogsAnomalyDetectionIntegrationConfig> LOGS_ANOMALY_DETECTION_FIELD = SdkField
            .<LogsAnomalyDetectionIntegrationConfig> builder(MarshallingType.SDK_POJO).memberName("LogsAnomalyDetection")
            .getter(getter(UpdateServiceIntegrationConfig::logsAnomalyDetection)).setter(setter(Builder::logsAnomalyDetection))
            .constructor(LogsAnomalyDetectionIntegrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsAnomalyDetection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_CENTER_FIELD,
            LOGS_ANOMALY_DETECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final OpsCenterIntegrationConfig opsCenter;

    private final LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection;

    private UpdateServiceIntegrationConfig(BuilderImpl builder) {
        this.opsCenter = builder.opsCenter;
        this.logsAnomalyDetection = builder.logsAnomalyDetection;
    }

    /**
     * Returns the value of the OpsCenter property for this object.
     * 
     * @return The value of the OpsCenter property for this object.
     */
    public final OpsCenterIntegrationConfig opsCenter() {
        return opsCenter;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
     * groups.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch
     *         log groups.
     */
    public final LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection() {
        return logsAnomalyDetection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsCenter());
        hashCode = 31 * hashCode + Objects.hashCode(logsAnomalyDetection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceIntegrationConfig)) {
            return false;
        }
        UpdateServiceIntegrationConfig other = (UpdateServiceIntegrationConfig) obj;
        return Objects.equals(opsCenter(), other.opsCenter())
                && Objects.equals(logsAnomalyDetection(), other.logsAnomalyDetection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceIntegrationConfig").add("OpsCenter", opsCenter())
                .add("LogsAnomalyDetection", logsAnomalyDetection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsCenter":
            return Optional.ofNullable(clazz.cast(opsCenter()));
        case "LogsAnomalyDetection":
            return Optional.ofNullable(clazz.cast(logsAnomalyDetection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceIntegrationConfig, T> g) {
        return obj -> g.apply((UpdateServiceIntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateServiceIntegrationConfig> {
        /**
         * Sets the value of the OpsCenter property for this object.
         *
         * @param opsCenter
         *        The new value for the OpsCenter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenter(OpsCenterIntegrationConfig opsCenter);

        /**
         * Sets the value of the OpsCenter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OpsCenterIntegrationConfig.Builder}
         * avoiding the need to create one manually via {@link OpsCenterIntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpsCenterIntegrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #opsCenter(OpsCenterIntegrationConfig)}.
         * 
         * @param opsCenter
         *        a consumer that will call methods on {@link OpsCenterIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opsCenter(OpsCenterIntegrationConfig)
         */
        default Builder opsCenter(Consumer<OpsCenterIntegrationConfig.Builder> opsCenter) {
            return opsCenter(OpsCenterIntegrationConfig.builder().applyMutation(opsCenter).build());
        }

        /**
         * <p>
         * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
         * groups.
         * </p>
         * 
         * @param logsAnomalyDetection
         *        Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon
         *        CloudWatch log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log
         * groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LogsAnomalyDetectionIntegrationConfig.Builder} avoiding the need to create one manually via
         * {@link LogsAnomalyDetectionIntegrationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsAnomalyDetectionIntegrationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig)}.
         * 
         * @param logsAnomalyDetection
         *        a consumer that will call methods on {@link LogsAnomalyDetectionIntegrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig)
         */
        default Builder logsAnomalyDetection(Consumer<LogsAnomalyDetectionIntegrationConfig.Builder> logsAnomalyDetection) {
            return logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig.builder().applyMutation(logsAnomalyDetection)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpsCenterIntegrationConfig opsCenter;

        private LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceIntegrationConfig model) {
            opsCenter(model.opsCenter);
            logsAnomalyDetection(model.logsAnomalyDetection);
        }

        public final OpsCenterIntegrationConfig.Builder getOpsCenter() {
            return opsCenter != null ? opsCenter.toBuilder() : null;
        }

        public final void setOpsCenter(OpsCenterIntegrationConfig.BuilderImpl opsCenter) {
            this.opsCenter = opsCenter != null ? opsCenter.build() : null;
        }

        @Override
        public final Builder opsCenter(OpsCenterIntegrationConfig opsCenter) {
            this.opsCenter = opsCenter;
            return this;
        }

        public final LogsAnomalyDetectionIntegrationConfig.Builder getLogsAnomalyDetection() {
            return logsAnomalyDetection != null ? logsAnomalyDetection.toBuilder() : null;
        }

        public final void setLogsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig.BuilderImpl logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection != null ? logsAnomalyDetection.build() : null;
        }

        @Override
        public final Builder logsAnomalyDetection(LogsAnomalyDetectionIntegrationConfig logsAnomalyDetection) {
            this.logsAnomalyDetection = logsAnomalyDetection;
            return this;
        }

        @Override
        public UpdateServiceIntegrationConfig build() {
            return new UpdateServiceIntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
