/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the number of open reactive and proactive insights that can be used to gauge the health of your
 * system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountInsightHealth implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountInsightHealth.Builder, AccountInsightHealth> {
    private static final SdkField<Integer> OPEN_PROACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenProactiveInsights").getter(getter(AccountInsightHealth::openProactiveInsights))
            .setter(setter(Builder::openProactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenProactiveInsights").build())
            .build();

    private static final SdkField<Integer> OPEN_REACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenReactiveInsights").getter(getter(AccountInsightHealth::openReactiveInsights))
            .setter(setter(Builder::openReactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenReactiveInsights").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_PROACTIVE_INSIGHTS_FIELD,
            OPEN_REACTIVE_INSIGHTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer openProactiveInsights;

    private final Integer openReactiveInsights;

    private AccountInsightHealth(BuilderImpl builder) {
        this.openProactiveInsights = builder.openProactiveInsights;
        this.openReactiveInsights = builder.openReactiveInsights;
    }

    /**
     * <p>
     * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
     * </p>
     * 
     * @return An integer that specifies the number of open proactive insights in your Amazon Web Services account.
     */
    public final Integer openProactiveInsights() {
        return openProactiveInsights;
    }

    /**
     * <p>
     * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
     * </p>
     * 
     * @return An integer that specifies the number of open reactive insights in your Amazon Web Services account.
     */
    public final Integer openReactiveInsights() {
        return openReactiveInsights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openProactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(openReactiveInsights());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountInsightHealth)) {
            return false;
        }
        AccountInsightHealth other = (AccountInsightHealth) obj;
        return Objects.equals(openProactiveInsights(), other.openProactiveInsights())
                && Objects.equals(openReactiveInsights(), other.openReactiveInsights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountInsightHealth").add("OpenProactiveInsights", openProactiveInsights())
                .add("OpenReactiveInsights", openReactiveInsights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenProactiveInsights":
            return Optional.ofNullable(clazz.cast(openProactiveInsights()));
        case "OpenReactiveInsights":
            return Optional.ofNullable(clazz.cast(openReactiveInsights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountInsightHealth, T> g) {
        return obj -> g.apply((AccountInsightHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountInsightHealth> {
        /**
         * <p>
         * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param openProactiveInsights
         *        An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openProactiveInsights(Integer openProactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param openReactiveInsights
         *        An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openReactiveInsights(Integer openReactiveInsights);
    }

    static final class BuilderImpl implements Builder {
        private Integer openProactiveInsights;

        private Integer openReactiveInsights;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountInsightHealth model) {
            openProactiveInsights(model.openProactiveInsights);
            openReactiveInsights(model.openReactiveInsights);
        }

        public final Integer getOpenProactiveInsights() {
            return openProactiveInsights;
        }

        public final void setOpenProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
        }

        @Override
        public final Builder openProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
            return this;
        }

        public final Integer getOpenReactiveInsights() {
            return openReactiveInsights;
        }

        public final void setOpenReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
        }

        @Override
        public final Builder openReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
            return this;
        }

        @Override
        public AccountInsightHealth build() {
            return new AccountInsightHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
