/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the integration of DevOps Guru as consumer with another AWS service, such as AWS CodeGuru Profiler
 * via EventBridge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSourcesConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EventSourcesConfig.Builder, EventSourcesConfig> {
    private static final SdkField<AmazonCodeGuruProfilerIntegration> AMAZON_CODE_GURU_PROFILER_FIELD = SdkField
            .<AmazonCodeGuruProfilerIntegration> builder(MarshallingType.SDK_POJO).memberName("AmazonCodeGuruProfiler")
            .getter(getter(EventSourcesConfig::amazonCodeGuruProfiler)).setter(setter(Builder::amazonCodeGuruProfiler))
            .constructor(AmazonCodeGuruProfilerIntegration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonCodeGuruProfiler").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AMAZON_CODE_GURU_PROFILER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmazonCodeGuruProfilerIntegration amazonCodeGuruProfiler;

    private EventSourcesConfig(BuilderImpl builder) {
        this.amazonCodeGuruProfiler = builder.amazonCodeGuruProfiler;
    }

    /**
     * <p>
     * Information about whether DevOps Guru is configured to consume recommendations which are generated from AWS
     * CodeGuru Profiler.
     * </p>
     * 
     * @return Information about whether DevOps Guru is configured to consume recommendations which are generated from
     *         AWS CodeGuru Profiler.
     */
    public final AmazonCodeGuruProfilerIntegration amazonCodeGuruProfiler() {
        return amazonCodeGuruProfiler;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonCodeGuruProfiler());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSourcesConfig)) {
            return false;
        }
        EventSourcesConfig other = (EventSourcesConfig) obj;
        return Objects.equals(amazonCodeGuruProfiler(), other.amazonCodeGuruProfiler());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSourcesConfig").add("AmazonCodeGuruProfiler", amazonCodeGuruProfiler()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonCodeGuruProfiler":
            return Optional.ofNullable(clazz.cast(amazonCodeGuruProfiler()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSourcesConfig, T> g) {
        return obj -> g.apply((EventSourcesConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSourcesConfig> {
        /**
         * <p>
         * Information about whether DevOps Guru is configured to consume recommendations which are generated from AWS
         * CodeGuru Profiler.
         * </p>
         * 
         * @param amazonCodeGuruProfiler
         *        Information about whether DevOps Guru is configured to consume recommendations which are generated
         *        from AWS CodeGuru Profiler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonCodeGuruProfiler(AmazonCodeGuruProfilerIntegration amazonCodeGuruProfiler);

        /**
         * <p>
         * Information about whether DevOps Guru is configured to consume recommendations which are generated from AWS
         * CodeGuru Profiler.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonCodeGuruProfilerIntegration.Builder} avoiding the need to create one manually via
         * {@link AmazonCodeGuruProfilerIntegration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonCodeGuruProfilerIntegration.Builder#build()} is called
         * immediately and its result is passed to {@link #amazonCodeGuruProfiler(AmazonCodeGuruProfilerIntegration)}.
         * 
         * @param amazonCodeGuruProfiler
         *        a consumer that will call methods on {@link AmazonCodeGuruProfilerIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonCodeGuruProfiler(AmazonCodeGuruProfilerIntegration)
         */
        default Builder amazonCodeGuruProfiler(Consumer<AmazonCodeGuruProfilerIntegration.Builder> amazonCodeGuruProfiler) {
            return amazonCodeGuruProfiler(AmazonCodeGuruProfilerIntegration.builder().applyMutation(amazonCodeGuruProfiler)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmazonCodeGuruProfilerIntegration amazonCodeGuruProfiler;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSourcesConfig model) {
            amazonCodeGuruProfiler(model.amazonCodeGuruProfiler);
        }

        public final AmazonCodeGuruProfilerIntegration.Builder getAmazonCodeGuruProfiler() {
            return amazonCodeGuruProfiler != null ? amazonCodeGuruProfiler.toBuilder() : null;
        }

        public final void setAmazonCodeGuruProfiler(AmazonCodeGuruProfilerIntegration.BuilderImpl amazonCodeGuruProfiler) {
            this.amazonCodeGuruProfiler = amazonCodeGuruProfiler != null ? amazonCodeGuruProfiler.build() : null;
        }

        @Override
        public final Builder amazonCodeGuruProfiler(AmazonCodeGuruProfilerIntegration amazonCodeGuruProfiler) {
            this.amazonCodeGuruProfiler = amazonCodeGuruProfiler;
            return this;
        }

        @Override
        public EventSourcesConfig build() {
            return new EventSourcesConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
