/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter used by <code>ListInsights</code> to specify which insights to return.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInsightsStatusFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListInsightsStatusFilter.Builder, ListInsightsStatusFilter> {
    private static final SdkField<ListInsightsOngoingStatusFilter> ONGOING_FIELD = SdkField
            .<ListInsightsOngoingStatusFilter> builder(MarshallingType.SDK_POJO).memberName("Ongoing")
            .getter(getter(ListInsightsStatusFilter::ongoing)).setter(setter(Builder::ongoing))
            .constructor(ListInsightsOngoingStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ongoing").build()).build();

    private static final SdkField<ListInsightsClosedStatusFilter> CLOSED_FIELD = SdkField
            .<ListInsightsClosedStatusFilter> builder(MarshallingType.SDK_POJO).memberName("Closed")
            .getter(getter(ListInsightsStatusFilter::closed)).setter(setter(Builder::closed))
            .constructor(ListInsightsClosedStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Closed").build()).build();

    private static final SdkField<ListInsightsAnyStatusFilter> ANY_FIELD = SdkField
            .<ListInsightsAnyStatusFilter> builder(MarshallingType.SDK_POJO).memberName("Any")
            .getter(getter(ListInsightsStatusFilter::any)).setter(setter(Builder::any))
            .constructor(ListInsightsAnyStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Any").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONGOING_FIELD, CLOSED_FIELD,
            ANY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ListInsightsOngoingStatusFilter ongoing;

    private final ListInsightsClosedStatusFilter closed;

    private final ListInsightsAnyStatusFilter any;

    private ListInsightsStatusFilter(BuilderImpl builder) {
        this.ongoing = builder.ongoing;
        this.closed = builder.closed;
        this.any = builder.any;
    }

    /**
     * <p>
     * A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either <code>REACTIVE</code>
     * or <code>PROACTIVE</code>.
     * </p>
     * 
     * @return A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either
     *         <code>REACTIVE</code> or <code>PROACTIVE</code>.
     */
    public final ListInsightsOngoingStatusFilter ongoing() {
        return ongoing;
    }

    /**
     * <p>
     * A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either
     * <code>REACTIVE</code> or <code>PROACTIVE</code>.
     * </p>
     * 
     * @return A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either
     *         <code>REACTIVE</code> or <code>PROACTIVE</code>.
     */
    public final ListInsightsClosedStatusFilter closed() {
        return closed;
    }

    /**
     * <p>
     * A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either
     * <code>REACTIVE</code> or <code>PROACTIVE</code>.
     * </p>
     * 
     * @return A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either
     *         <code>REACTIVE</code> or <code>PROACTIVE</code>.
     */
    public final ListInsightsAnyStatusFilter any() {
        return any;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ongoing());
        hashCode = 31 * hashCode + Objects.hashCode(closed());
        hashCode = 31 * hashCode + Objects.hashCode(any());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsStatusFilter)) {
            return false;
        }
        ListInsightsStatusFilter other = (ListInsightsStatusFilter) obj;
        return Objects.equals(ongoing(), other.ongoing()) && Objects.equals(closed(), other.closed())
                && Objects.equals(any(), other.any());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInsightsStatusFilter").add("Ongoing", ongoing()).add("Closed", closed()).add("Any", any())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ongoing":
            return Optional.ofNullable(clazz.cast(ongoing()));
        case "Closed":
            return Optional.ofNullable(clazz.cast(closed()));
        case "Any":
            return Optional.ofNullable(clazz.cast(any()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsStatusFilter, T> g) {
        return obj -> g.apply((ListInsightsStatusFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListInsightsStatusFilter> {
        /**
         * <p>
         * A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either
         * <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * </p>
         * 
         * @param ongoing
         *        A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either
         *        <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ongoing(ListInsightsOngoingStatusFilter ongoing);

        /**
         * <p>
         * A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either
         * <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListInsightsOngoingStatusFilter.Builder}
         * avoiding the need to create one manually via {@link ListInsightsOngoingStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListInsightsOngoingStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ongoing(ListInsightsOngoingStatusFilter)}.
         * 
         * @param ongoing
         *        a consumer that will call methods on {@link ListInsightsOngoingStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ongoing(ListInsightsOngoingStatusFilter)
         */
        default Builder ongoing(Consumer<ListInsightsOngoingStatusFilter.Builder> ongoing) {
            return ongoing(ListInsightsOngoingStatusFilter.builder().applyMutation(ongoing).build());
        }

        /**
         * <p>
         * A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either
         * <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * </p>
         * 
         * @param closed
         *        A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either
         *        <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closed(ListInsightsClosedStatusFilter closed);

        /**
         * <p>
         * A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either
         * <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListInsightsClosedStatusFilter.Builder}
         * avoiding the need to create one manually via {@link ListInsightsClosedStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListInsightsClosedStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #closed(ListInsightsClosedStatusFilter)}.
         * 
         * @param closed
         *        a consumer that will call methods on {@link ListInsightsClosedStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closed(ListInsightsClosedStatusFilter)
         */
        default Builder closed(Consumer<ListInsightsClosedStatusFilter.Builder> closed) {
            return closed(ListInsightsClosedStatusFilter.builder().applyMutation(closed).build());
        }

        /**
         * <p>
         * A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either
         * <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * </p>
         * 
         * @param any
         *        A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either
         *        <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder any(ListInsightsAnyStatusFilter any);

        /**
         * <p>
         * A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either
         * <code>REACTIVE</code> or <code>PROACTIVE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListInsightsAnyStatusFilter.Builder}
         * avoiding the need to create one manually via {@link ListInsightsAnyStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListInsightsAnyStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #any(ListInsightsAnyStatusFilter)}.
         * 
         * @param any
         *        a consumer that will call methods on {@link ListInsightsAnyStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #any(ListInsightsAnyStatusFilter)
         */
        default Builder any(Consumer<ListInsightsAnyStatusFilter.Builder> any) {
            return any(ListInsightsAnyStatusFilter.builder().applyMutation(any).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ListInsightsOngoingStatusFilter ongoing;

        private ListInsightsClosedStatusFilter closed;

        private ListInsightsAnyStatusFilter any;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsStatusFilter model) {
            ongoing(model.ongoing);
            closed(model.closed);
            any(model.any);
        }

        public final ListInsightsOngoingStatusFilter.Builder getOngoing() {
            return ongoing != null ? ongoing.toBuilder() : null;
        }

        public final void setOngoing(ListInsightsOngoingStatusFilter.BuilderImpl ongoing) {
            this.ongoing = ongoing != null ? ongoing.build() : null;
        }

        @Override
        public final Builder ongoing(ListInsightsOngoingStatusFilter ongoing) {
            this.ongoing = ongoing;
            return this;
        }

        public final ListInsightsClosedStatusFilter.Builder getClosed() {
            return closed != null ? closed.toBuilder() : null;
        }

        public final void setClosed(ListInsightsClosedStatusFilter.BuilderImpl closed) {
            this.closed = closed != null ? closed.build() : null;
        }

        @Override
        public final Builder closed(ListInsightsClosedStatusFilter closed) {
            this.closed = closed;
            return this;
        }

        public final ListInsightsAnyStatusFilter.Builder getAny() {
            return any != null ? any.toBuilder() : null;
        }

        public final void setAny(ListInsightsAnyStatusFilter.BuilderImpl any) {
            this.any = any != null ? any.build() : null;
        }

        @Override
        public final Builder any(ListInsightsAnyStatusFilter any) {
            this.any = any;
            return this;
        }

        @Override
        public ListInsightsStatusFilter build() {
            return new ListInsightsStatusFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
