/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelRequest;
import software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelResponse;
import software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.DeleteInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListEventsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListEventsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest;
import software.amazon.awssdk.services.devopsguru.model.PutFeedbackResponse;
import software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest;
import software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelResponse;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.StartCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigResponse;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationResponse;
import software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListEventsPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListInsightsPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsPublisher;
import software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsPublisher;

/**
 * Service client for accessing Amazon DevOps Guru asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon DevOps Guru is a fully managed service that helps you identify anomalous behavior in business critical
 * operational applications. You specify the Amazon Web Services resources that you want DevOps Guru to cover, then the
 * Amazon CloudWatch metrics and Amazon Web Services CloudTrail events related to those resources are analyzed. When
 * anomalous behavior is detected, DevOps Guru creates an <i>insight</i> that includes recommendations, related events,
 * and related metrics that can help you improve your operational applications. For more information, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html">What is Amazon DevOps Guru</a>.
 * </p>
 * <p>
 * You can specify 1 or 2 Amazon Simple Notification Service topics so you are notified every time a new insight is
 * created. You can also enable DevOps Guru to generate an OpsItem in Amazon Web Services Systems Manager for each
 * insight to help you manage and track your work addressing insights.
 * </p>
 * <p>
 * To learn about the DevOps Guru workflow, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html#how-it-works">How DevOps Guru works</a>.
 * To learn about DevOps Guru concepts, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/concepts.html">Concepts in DevOps Guru</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DevOpsGuruAsyncClient extends AwsClient {
    String SERVICE_NAME = "devops-guru";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "devops-guru";

    /**
     * <p>
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps
     * Guru events, such as when an insight is generated.
     * </p>
     * <p>
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     * permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications
     * using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for
     * Amazon SNS topics</a>.
     * </p>
     * <p>
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
     * customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon
     * Web Services KMS–encrypted Amazon SNS topics</a>.
     * </p>
     *
     * @param addNotificationChannelRequest
     * @return A Java Future containing the result of the AddNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ServiceQuotaExceededException The request contains a value that exceeds a maximum quota.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.AddNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddNotificationChannelResponse> addNotificationChannel(
            AddNotificationChannelRequest addNotificationChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps
     * Guru events, such as when an insight is generated.
     * </p>
     * <p>
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     * permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications
     * using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for
     * Amazon SNS topics</a>.
     * </p>
     * <p>
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
     * customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon
     * Web Services KMS–encrypted Amazon SNS topics</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddNotificationChannelRequest.Builder} avoiding the
     * need to create one manually via {@link AddNotificationChannelRequest#builder()}
     * </p>
     *
     * @param addNotificationChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ServiceQuotaExceededException The request contains a value that exceeds a maximum quota.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.AddNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddNotificationChannelResponse> addNotificationChannel(
            Consumer<AddNotificationChannelRequest.Builder> addNotificationChannelRequest) {
        return addNotificationChannel(AddNotificationChannelRequest.builder().applyMutation(addNotificationChannelRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the insight along with the associated anomalies, events and recommendations.
     * </p>
     *
     * @param deleteInsightRequest
     * @return A Java Future containing the result of the DeleteInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInsightResponse> deleteInsight(DeleteInsightRequest deleteInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the insight along with the associated anomalies, events and recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInsightRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInsightRequest#builder()}
     * </p>
     *
     * @param deleteInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInsightResponse> deleteInsight(Consumer<DeleteInsightRequest.Builder> deleteInsightRequest) {
        return deleteInsight(DeleteInsightRequest.builder().applyMutation(deleteInsightRequest).build());
    }

    /**
     * <p>
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics
     * analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon
     * Web Services account.
     * </p>
     *
     * @param describeAccountHealthRequest
     * @return A Java Future containing the result of the DescribeAccountHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeAccountHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountHealthResponse> describeAccountHealth(
            DescribeAccountHealthRequest describeAccountHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics
     * analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon
     * Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountHealthRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountHealthRequest#builder()}
     * </p>
     *
     * @param describeAccountHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccountHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeAccountHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountHealthResponse> describeAccountHealth(
            Consumer<DescribeAccountHealthRequest.Builder> describeAccountHealthRequest) {
        return describeAccountHealth(DescribeAccountHealthRequest.builder().applyMutation(describeAccountHealthRequest).build());
    }

    /**
     * <p>
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open
     * proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     * </p>
     *
     * @param describeAccountOverviewRequest
     * @return A Java Future containing the result of the DescribeAccountOverview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeAccountOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountOverviewResponse> describeAccountOverview(
            DescribeAccountOverviewRequest describeAccountOverviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open
     * proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountOverviewRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountOverviewRequest#builder()}
     * </p>
     *
     * @param describeAccountOverviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeAccountOverview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeAccountOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountOverviewResponse> describeAccountOverview(
            Consumer<DescribeAccountOverviewRequest.Builder> describeAccountOverviewRequest) {
        return describeAccountOverview(DescribeAccountOverviewRequest.builder().applyMutation(describeAccountOverviewRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about an anomaly that you specify using its ID.
     * </p>
     *
     * @param describeAnomalyRequest
     * @return A Java Future containing the result of the DescribeAnomaly operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeAnomaly
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAnomalyResponse> describeAnomaly(DescribeAnomalyRequest describeAnomalyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an anomaly that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAnomalyRequest#builder()}
     * </p>
     *
     * @param describeAnomalyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAnomaly operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeAnomaly
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAnomalyResponse> describeAnomaly(
            Consumer<DescribeAnomalyRequest.Builder> describeAnomalyRequest) {
        return describeAnomaly(DescribeAnomalyRequest.builder().applyMutation(describeAnomalyRequest).build());
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The
     * one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive
     * recommendations which can be stored and viewed in DevOps Guru.
     * </p>
     *
     * @param describeEventSourcesConfigRequest
     * @return A Java Future containing the result of the DescribeEventSourcesConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSourcesConfigResponse> describeEventSourcesConfig(
            DescribeEventSourcesConfigRequest describeEventSourcesConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The
     * one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive
     * recommendations which can be stored and viewed in DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSourcesConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSourcesConfigRequest#builder()}
     * </p>
     *
     * @param describeEventSourcesConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEventSourcesConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSourcesConfigResponse> describeEventSourcesConfig(
            Consumer<DescribeEventSourcesConfigRequest.Builder> describeEventSourcesConfigRequest) {
        return describeEventSourcesConfig(DescribeEventSourcesConfigRequest.builder()
                .applyMutation(describeEventSourcesConfigRequest).build());
    }

    /**
     * <p>
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     * </p>
     *
     * @param describeFeedbackRequest
     * @return A Java Future containing the result of the DescribeFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFeedbackResponse> describeFeedback(DescribeFeedbackRequest describeFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFeedbackRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFeedbackRequest#builder()}
     * </p>
     *
     * @param describeFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFeedbackResponse> describeFeedback(
            Consumer<DescribeFeedbackRequest.Builder> describeFeedbackRequest) {
        return describeFeedback(DescribeFeedbackRequest.builder().applyMutation(describeFeedbackRequest).build());
    }

    /**
     * <p>
     * Returns details about an insight that you specify using its ID.
     * </p>
     *
     * @param describeInsightRequest
     * @return A Java Future containing the result of the DescribeInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInsightResponse> describeInsight(DescribeInsightRequest describeInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an insight that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInsightRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInsightRequest#builder()}
     * </p>
     *
     * @param describeInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInsightResponse> describeInsight(
            Consumer<DescribeInsightRequest.Builder> describeInsightRequest) {
        return describeInsight(DescribeInsightRequest.builder().applyMutation(describeInsightRequest).build());
    }

    /**
     * <p>
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     * </p>
     *
     * @param describeOrganizationHealthRequest
     * @return A Java Future containing the result of the DescribeOrganizationHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationHealthResponse> describeOrganizationHealth(
            DescribeOrganizationHealthRequest describeOrganizationHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationHealthRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOrganizationHealthRequest#builder()}
     * </p>
     *
     * @param describeOrganizationHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationHealthResponse> describeOrganizationHealth(
            Consumer<DescribeOrganizationHealthRequest.Builder> describeOrganizationHealthRequest) {
        return describeOrganizationHealth(DescribeOrganizationHealthRequest.builder()
                .applyMutation(describeOrganizationHealthRequest).build());
    }

    /**
     * <p>
     * Returns an overview of your organization's history based on the specified time range. The overview includes the
     * total reactive and proactive insights.
     * </p>
     *
     * @param describeOrganizationOverviewRequest
     * @return A Java Future containing the result of the DescribeOrganizationOverview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationOverviewResponse> describeOrganizationOverview(
            DescribeOrganizationOverviewRequest describeOrganizationOverviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an overview of your organization's history based on the specified time range. The overview includes the
     * total reactive and proactive insights.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationOverviewRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationOverviewRequest#builder()}
     * </p>
     *
     * @param describeOrganizationOverviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationOverview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationOverviewResponse> describeOrganizationOverview(
            Consumer<DescribeOrganizationOverviewRequest.Builder> describeOrganizationOverviewRequest) {
        return describeOrganizationOverview(DescribeOrganizationOverviewRequest.builder()
                .applyMutation(describeOrganizationOverviewRequest).build());
    }

    /**
     * <p>
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you
     * can filter those accounts using the <code>AccountIds</code> field.
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     * @return A Java Future containing the result of the DescribeOrganizationResourceCollectionHealth operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationResourceCollectionHealthResponse> describeOrganizationResourceCollectionHealth(
            DescribeOrganizationResourceCollectionHealthRequest describeOrganizationResourceCollectionHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you
     * can filter those accounts using the <code>AccountIds</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationResourceCollectionHealthRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrganizationResourceCollectionHealth operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationResourceCollectionHealthResponse> describeOrganizationResourceCollectionHealth(
            Consumer<DescribeOrganizationResourceCollectionHealthRequest.Builder> describeOrganizationResourceCollectionHealthRequest) {
        return describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthRequest.builder()
                .applyMutation(describeOrganizationResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you
     * can filter those accounts using the <code>AccountIds</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthPublisher publisher = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthPublisher publisher = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationResourceCollectionHealthPublisher describeOrganizationResourceCollectionHealthPaginator(
            DescribeOrganizationResourceCollectionHealthRequest describeOrganizationResourceCollectionHealthRequest) {
        return new DescribeOrganizationResourceCollectionHealthPublisher(this,
                describeOrganizationResourceCollectionHealthRequest);
    }

    /**
     * <p>
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you
     * can filter those accounts using the <code>AccountIds</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthPublisher publisher = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthPublisher publisher = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationResourceCollectionHealthRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationResourceCollectionHealthPublisher describeOrganizationResourceCollectionHealthPaginator(
            Consumer<DescribeOrganizationResourceCollectionHealthRequest.Builder> describeOrganizationResourceCollectionHealthRequest) {
        return describeOrganizationResourceCollectionHealthPaginator(DescribeOrganizationResourceCollectionHealthRequest
                .builder().applyMutation(describeOrganizationResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for
     * all closed insights in resource collections in your account. You specify the type of Amazon Web Services
     * resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     * @return A Java Future containing the result of the DescribeResourceCollectionHealth operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceCollectionHealthResponse> describeResourceCollectionHealth(
            DescribeResourceCollectionHealthRequest describeResourceCollectionHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for
     * all closed insights in resource collections in your account. You specify the type of Amazon Web Services
     * resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceCollectionHealthRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeResourceCollectionHealth operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceCollectionHealthResponse> describeResourceCollectionHealth(
            Consumer<DescribeResourceCollectionHealthRequest.Builder> describeResourceCollectionHealthRequest) {
        return describeResourceCollectionHealth(DescribeResourceCollectionHealthRequest.builder()
                .applyMutation(describeResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for
     * all closed insights in resource collections in your account. You specify the type of Amazon Web Services
     * resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthPublisher publisher = client.describeResourceCollectionHealthPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthPublisher publisher = client.describeResourceCollectionHealthPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceCollectionHealthPublisher describeResourceCollectionHealthPaginator(
            DescribeResourceCollectionHealthRequest describeResourceCollectionHealthRequest) {
        return new DescribeResourceCollectionHealthPublisher(this, describeResourceCollectionHealthRequest);
    }

    /**
     * <p>
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for
     * all closed insights in resource collections in your account. You specify the type of Amazon Web Services
     * resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthPublisher publisher = client.describeResourceCollectionHealthPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthPublisher publisher = client.describeResourceCollectionHealthPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceCollectionHealthRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceCollectionHealthPublisher describeResourceCollectionHealthPaginator(
            Consumer<DescribeResourceCollectionHealthRequest.Builder> describeResourceCollectionHealthRequest) {
        return describeResourceCollectionHealthPaginator(DescribeResourceCollectionHealthRequest.builder()
                .applyMutation(describeResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be
     * integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     *
     * @param describeServiceIntegrationRequest
     * @return A Java Future containing the result of the DescribeServiceIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceIntegrationResponse> describeServiceIntegration(
            DescribeServiceIntegrationRequest describeServiceIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be
     * integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceIntegrationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeServiceIntegrationRequest#builder()}
     * </p>
     *
     * @param describeServiceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeServiceIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.DescribeServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeServiceIntegrationResponse> describeServiceIntegration(
            Consumer<DescribeServiceIntegrationRequest.Builder> describeServiceIntegrationRequest) {
        return describeServiceIntegration(DescribeServiceIntegrationRequest.builder()
                .applyMutation(describeServiceIntegrationRequest).build());
    }

    /**
     * <p>
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more
     * information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate
     * your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
     * pricing</a>.
     * </p>
     *
     * @param getCostEstimationRequest
     * @return A Java Future containing the result of the GetCostEstimation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCostEstimationResponse> getCostEstimation(GetCostEstimationRequest getCostEstimationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more
     * information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate
     * your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
     * pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostEstimationRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostEstimationRequest#builder()}
     * </p>
     *
     * @param getCostEstimationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCostEstimation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCostEstimationResponse> getCostEstimation(
            Consumer<GetCostEstimationRequest.Builder> getCostEstimationRequest) {
        return getCostEstimation(GetCostEstimationRequest.builder().applyMutation(getCostEstimationRequest).build());
    }

    /**
     * <p>
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more
     * information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate
     * your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
     * pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationPublisher publisher = client.getCostEstimationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationPublisher publisher = client.getCostEstimationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCostEstimationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCostEstimationPublisher getCostEstimationPaginator(GetCostEstimationRequest getCostEstimationRequest) {
        return new GetCostEstimationPublisher(this, getCostEstimationRequest);
    }

    /**
     * <p>
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more
     * information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate
     * your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
     * pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationPublisher publisher = client.getCostEstimationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationPublisher publisher = client.getCostEstimationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostEstimationRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostEstimationRequest#builder()}
     * </p>
     *
     * @param getCostEstimationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCostEstimationPublisher getCostEstimationPaginator(
            Consumer<GetCostEstimationRequest.Builder> getCostEstimationRequest) {
        return getCostEstimationPaginator(GetCostEstimationRequest.builder().applyMutation(getCostEstimationRequest).build());
    }

    /**
     * <p>
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of
     * Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web
     * Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
     * Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>.
     * You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     *
     * @param getResourceCollectionRequest
     * @return A Java Future containing the result of the GetResourceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceCollectionResponse> getResourceCollection(
            GetResourceCollectionRequest getResourceCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of
     * Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web
     * Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
     * Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>.
     * You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceCollectionRequest#builder()}
     * </p>
     *
     * @param getResourceCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceCollectionResponse> getResourceCollection(
            Consumer<GetResourceCollectionRequest.Builder> getResourceCollectionRequest) {
        return getResourceCollection(GetResourceCollectionRequest.builder().applyMutation(getResourceCollectionRequest).build());
    }

    /**
     * <p>
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of
     * Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web
     * Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
     * Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>.
     * You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionPublisher publisher = client.getResourceCollectionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionPublisher publisher = client.getResourceCollectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceCollectionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceCollectionPublisher getResourceCollectionPaginator(
            GetResourceCollectionRequest getResourceCollectionRequest) {
        return new GetResourceCollectionPublisher(this, getResourceCollectionRequest);
    }

    /**
     * <p>
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of
     * Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web
     * Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
     * Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>.
     * You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionPublisher publisher = client.getResourceCollectionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionPublisher publisher = client.getResourceCollectionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceCollectionRequest#builder()}
     * </p>
     *
     * @param getResourceCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceCollectionPublisher getResourceCollectionPaginator(
            Consumer<GetResourceCollectionRequest.Builder> getResourceCollectionRequest) {
        return getResourceCollectionPaginator(GetResourceCollectionRequest.builder().applyMutation(getResourceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     * @return A Java Future containing the result of the ListAnomaliesForInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomaliesForInsightResponse> listAnomaliesForInsight(
            ListAnomaliesForInsightRequest listAnomaliesForInsightRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomaliesForInsightRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomaliesForInsightRequest#builder()}
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAnomaliesForInsight operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomaliesForInsightResponse> listAnomaliesForInsight(
            Consumer<ListAnomaliesForInsightRequest.Builder> listAnomaliesForInsightRequest) {
        return listAnomaliesForInsight(ListAnomaliesForInsightRequest.builder().applyMutation(listAnomaliesForInsightRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightPublisher publisher = client.listAnomaliesForInsightPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightPublisher publisher = client.listAnomaliesForInsightPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomaliesForInsightPublisher listAnomaliesForInsightPaginator(
            ListAnomaliesForInsightRequest listAnomaliesForInsightRequest) {
        return new ListAnomaliesForInsightPublisher(this, listAnomaliesForInsightRequest);
    }

    /**
     * <p>
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightPublisher publisher = client.listAnomaliesForInsightPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightPublisher publisher = client.listAnomaliesForInsightPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomaliesForInsightRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomaliesForInsightRequest#builder()}
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomaliesForInsightPublisher listAnomaliesForInsightPaginator(
            Consumer<ListAnomaliesForInsightRequest.Builder> listAnomaliesForInsightRequest) {
        return listAnomaliesForInsightPaginator(ListAnomaliesForInsightRequest.builder()
                .applyMutation(listAnomaliesForInsightRequest).build());
    }

    /**
     * <p>
     * Returns the list of log groups that contain log anomalies.
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     * @return A Java Future containing the result of the ListAnomalousLogGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalousLogGroupsResponse> listAnomalousLogGroups(
            ListAnomalousLogGroupsRequest listAnomalousLogGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of log groups that contain log anomalies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalousLogGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalousLogGroupsRequest#builder()}
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnomalousLogGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnomalousLogGroupsResponse> listAnomalousLogGroups(
            Consumer<ListAnomalousLogGroupsRequest.Builder> listAnomalousLogGroupsRequest) {
        return listAnomalousLogGroups(ListAnomalousLogGroupsRequest.builder().applyMutation(listAnomalousLogGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the list of log groups that contain log anomalies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsPublisher publisher = client.listAnomalousLogGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsPublisher publisher = client.listAnomalousLogGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalousLogGroupsPublisher listAnomalousLogGroupsPaginator(
            ListAnomalousLogGroupsRequest listAnomalousLogGroupsRequest) {
        return new ListAnomalousLogGroupsPublisher(this, listAnomalousLogGroupsRequest);
    }

    /**
     * <p>
     * Returns the list of log groups that contain log anomalies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsPublisher publisher = client.listAnomalousLogGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsPublisher publisher = client.listAnomalousLogGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalousLogGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalousLogGroupsRequest#builder()}
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalousLogGroupsPublisher listAnomalousLogGroupsPaginator(
            Consumer<ListAnomalousLogGroupsRequest.Builder> listAnomalousLogGroupsRequest) {
        return listAnomalousLogGroupsPaginator(ListAnomalousLogGroupsRequest.builder()
                .applyMutation(listAnomalousLogGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to
     * specify which events are returned.
     * </p>
     *
     * @param listEventsRequest
     * @return A Java Future containing the result of the ListEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEventsResponse> listEvents(ListEventsRequest listEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to
     * specify which events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEventsResponse> listEvents(Consumer<ListEventsRequest.Builder> listEventsRequest) {
        return listEvents(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to
     * specify which events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)} operation.</b>
     * </p>
     *
     * @param listEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventsPublisher listEventsPaginator(ListEventsRequest listEventsRequest) {
        return new ListEventsPublisher(this, listEventsRequest);
    }

    /**
     * <p>
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to
     * specify which events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsPublisher publisher = client.listEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListEventsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventsPublisher listEventsPaginator(Consumer<ListEventsRequest.Builder> listEventsRequest) {
        return listEventsPaginator(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>).
     * </p>
     *
     * @param listInsightsRequest
     * @return A Java Future containing the result of the ListInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInsightsResponse> listInsights(ListInsightsRequest listInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInsightsRequest#builder()}
     * </p>
     *
     * @param listInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInsightsResponse> listInsights(Consumer<ListInsightsRequest.Builder> listInsightsRequest) {
        return listInsights(ListInsightsRequest.builder().applyMutation(listInsightsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsPublisher publisher = client.listInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsPublisher publisher = client.listInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)} operation.</b>
     * </p>
     *
     * @param listInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInsightsPublisher listInsightsPaginator(ListInsightsRequest listInsightsRequest) {
        return new ListInsightsPublisher(this, listInsightsRequest);
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsPublisher publisher = client.listInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsPublisher publisher = client.listInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInsightsRequest#builder()}
     * </p>
     *
     * @param listInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInsightsPublisher listInsightsPaginator(Consumer<ListInsightsRequest.Builder> listInsightsRequest) {
        return listInsightsPaginator(ListInsightsRequest.builder().applyMutation(listInsightsRequest).build());
    }

    /**
     * <p>
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     * </p>
     *
     * @param listMonitoredResourcesRequest
     * @return A Java Future containing the result of the ListMonitoredResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMonitoredResourcesResponse> listMonitoredResources(
            ListMonitoredResourcesRequest listMonitoredResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitoredResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMonitoredResourcesRequest#builder()}
     * </p>
     *
     * @param listMonitoredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMonitoredResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMonitoredResourcesResponse> listMonitoredResources(
            Consumer<ListMonitoredResourcesRequest.Builder> listMonitoredResourcesRequest) {
        return listMonitoredResources(ListMonitoredResourcesRequest.builder().applyMutation(listMonitoredResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesPublisher publisher = client.listMonitoredResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesPublisher publisher = client.listMonitoredResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitoredResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitoredResourcesPublisher listMonitoredResourcesPaginator(
            ListMonitoredResourcesRequest listMonitoredResourcesRequest) {
        return new ListMonitoredResourcesPublisher(this, listMonitoredResourcesRequest);
    }

    /**
     * <p>
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesPublisher publisher = client.listMonitoredResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesPublisher publisher = client.listMonitoredResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitoredResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMonitoredResourcesRequest#builder()}
     * </p>
     *
     * @param listMonitoredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitoredResourcesPublisher listMonitoredResourcesPaginator(
            Consumer<ListMonitoredResourcesRequest.Builder> listMonitoredResourcesRequest) {
        return listMonitoredResourcesPaginator(ListMonitoredResourcesRequest.builder()
                .applyMutation(listMonitoredResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify
     * you when DevOps Guru generates an insight that contains information about how to improve your operations. The one
     * supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     * </p>
     *
     * @param listNotificationChannelsRequest
     * @return A Java Future containing the result of the ListNotificationChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationChannelsResponse> listNotificationChannels(
            ListNotificationChannelsRequest listNotificationChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify
     * you when DevOps Guru generates an insight that contains information about how to improve your operations. The one
     * supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNotificationChannelsRequest#builder()}
     * </p>
     *
     * @param listNotificationChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListNotificationChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotificationChannelsResponse> listNotificationChannels(
            Consumer<ListNotificationChannelsRequest.Builder> listNotificationChannelsRequest) {
        return listNotificationChannels(ListNotificationChannelsRequest.builder().applyMutation(listNotificationChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify
     * you when DevOps Guru generates an insight that contains information about how to improve your operations. The one
     * supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsPublisher publisher = client.listNotificationChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsPublisher publisher = client.listNotificationChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationChannelsPublisher listNotificationChannelsPaginator(
            ListNotificationChannelsRequest listNotificationChannelsRequest) {
        return new ListNotificationChannelsPublisher(this, listNotificationChannelsRequest);
    }

    /**
     * <p>
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify
     * you when DevOps Guru generates an insight that contains information about how to improve your operations. The one
     * supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsPublisher publisher = client.listNotificationChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsPublisher publisher = client.listNotificationChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNotificationChannelsRequest#builder()}
     * </p>
     *
     * @param listNotificationChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationChannelsPublisher listNotificationChannelsPaginator(
            Consumer<ListNotificationChannelsRequest.Builder> listNotificationChannelsRequest) {
        return listNotificationChannelsPaginator(ListNotificationChannelsRequest.builder()
                .applyMutation(listNotificationChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights associated with the account or OU Id.
     * </p>
     *
     * @param listOrganizationInsightsRequest
     * @return A Java Future containing the result of the ListOrganizationInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationInsightsResponse> listOrganizationInsights(
            ListOrganizationInsightsRequest listOrganizationInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights associated with the account or OU Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param listOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListOrganizationInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationInsightsResponse> listOrganizationInsights(
            Consumer<ListOrganizationInsightsRequest.Builder> listOrganizationInsightsRequest) {
        return listOrganizationInsights(ListOrganizationInsightsRequest.builder().applyMutation(listOrganizationInsightsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of insights associated with the account or OU Id.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsPublisher publisher = client.listOrganizationInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsPublisher publisher = client.listOrganizationInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationInsightsPublisher listOrganizationInsightsPaginator(
            ListOrganizationInsightsRequest listOrganizationInsightsRequest) {
        return new ListOrganizationInsightsPublisher(this, listOrganizationInsightsRequest);
    }

    /**
     * <p>
     * Returns a list of insights associated with the account or OU Id.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsPublisher publisher = client.listOrganizationInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsPublisher publisher = client.listOrganizationInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param listOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationInsightsPublisher listOrganizationInsightsPaginator(
            Consumer<ListOrganizationInsightsRequest.Builder> listOrganizationInsightsRequest) {
        return listOrganizationInsightsPaginator(ListOrganizationInsightsRequest.builder()
                .applyMutation(listOrganizationInsightsRequest).build());
    }

    /**
     * <p>
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics
     * and a list of related events.
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            ListRecommendationsRequest listRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics
     * and a list of related events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendations(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics
     * and a list of related events.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest) {
        return new ListRecommendationsPublisher(this, listRecommendationsRequest);
    }

    /**
     * <p>
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics
     * and a list of related events.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendationsPaginator(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Collects customer feedback about the specified insight.
     * </p>
     *
     * @param putFeedbackRequest
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(PutFeedbackRequest putFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Collects customer feedback about the specified insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest) {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <p>
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru
     * generates an insight that contains information about how to improve your operations.
     * </p>
     *
     * @param removeNotificationChannelRequest
     * @return A Java Future containing the result of the RemoveNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.RemoveNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveNotificationChannelResponse> removeNotificationChannel(
            RemoveNotificationChannelRequest removeNotificationChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru
     * generates an insight that contains information about how to improve your operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveNotificationChannelRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveNotificationChannelRequest#builder()}
     * </p>
     *
     * @param removeNotificationChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RemoveNotificationChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.RemoveNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveNotificationChannelResponse> removeNotificationChannel(
            Consumer<RemoveNotificationChannelRequest.Builder> removeNotificationChannelRequest) {
        return removeNotificationChannel(RemoveNotificationChannelRequest.builder()
                .applyMutation(removeNotificationChannelRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time, one or more statuses (<code>ONGOING</code> or <code>CLOSED</code>), one or more severities (
     * <code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     *
     * @param searchInsightsRequest
     * @return A Java Future containing the result of the SearchInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchInsightsResponse> searchInsights(SearchInsightsRequest searchInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time, one or more statuses (<code>ONGOING</code> or <code>CLOSED</code>), one or more severities (
     * <code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchInsightsRequest#builder()}
     * </p>
     *
     * @param searchInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchInsightsResponse> searchInsights(Consumer<SearchInsightsRequest.Builder> searchInsightsRequest) {
        return searchInsights(SearchInsightsRequest.builder().applyMutation(searchInsightsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time, one or more statuses (<code>ONGOING</code> or <code>CLOSED</code>), one or more severities (
     * <code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsPublisher publisher = client.searchInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsPublisher publisher = client.searchInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation.</b>
     * </p>
     *
     * @param searchInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchInsightsPublisher searchInsightsPaginator(SearchInsightsRequest searchInsightsRequest) {
        return new SearchInsightsPublisher(this, searchInsightsRequest);
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time, one or more statuses (<code>ONGOING</code> or <code>CLOSED</code>), one or more severities (
     * <code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsPublisher publisher = client.searchInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsPublisher publisher = client.searchInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchInsightsRequest#builder()}
     * </p>
     *
     * @param searchInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchInsightsPublisher searchInsightsPaginator(Consumer<SearchInsightsRequest.Builder> searchInsightsRequest) {
        return searchInsightsPaginator(SearchInsightsRequest.builder().applyMutation(searchInsightsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time,
     * one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
     * (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     * @return A Java Future containing the result of the SearchOrganizationInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchOrganizationInsightsResponse> searchOrganizationInsights(
            SearchOrganizationInsightsRequest searchOrganizationInsightsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time,
     * one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
     * (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SearchOrganizationInsights operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchOrganizationInsightsResponse> searchOrganizationInsights(
            Consumer<SearchOrganizationInsightsRequest.Builder> searchOrganizationInsightsRequest) {
        return searchOrganizationInsights(SearchOrganizationInsightsRequest.builder()
                .applyMutation(searchOrganizationInsightsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time,
     * one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
     * (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsPublisher publisher = client.searchOrganizationInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsPublisher publisher = client.searchOrganizationInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchOrganizationInsightsPublisher searchOrganizationInsightsPaginator(
            SearchOrganizationInsightsRequest searchOrganizationInsightsRequest) {
        return new SearchOrganizationInsightsPublisher(this, searchOrganizationInsightsRequest);
    }

    /**
     * <p>
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time,
     * one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
     * (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsPublisher publisher = client.searchOrganizationInsightsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsPublisher publisher = client.searchOrganizationInsightsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchOrganizationInsightsPublisher searchOrganizationInsightsPaginator(
            Consumer<SearchOrganizationInsightsRequest.Builder> searchOrganizationInsightsRequest) {
        return searchOrganizationInsightsPaginator(SearchOrganizationInsightsRequest.builder()
                .applyMutation(searchOrganizationInsightsRequest).build());
    }

    /**
     * <p>
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     * </p>
     *
     * @param startCostEstimationRequest
     * @return A Java Future containing the result of the StartCostEstimation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.StartCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/StartCostEstimation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCostEstimationResponse> startCostEstimation(
            StartCostEstimationRequest startCostEstimationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCostEstimationRequest.Builder} avoiding the
     * need to create one manually via {@link StartCostEstimationRequest#builder()}
     * </p>
     *
     * @param startCostEstimationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartCostEstimation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ResourceNotFoundException A requested resource could not be found</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.StartCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/StartCostEstimation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCostEstimationResponse> startCostEstimation(
            Consumer<StartCostEstimationRequest.Builder> startCostEstimationRequest) {
        return startCostEstimation(StartCostEstimationRequest.builder().applyMutation(startCostEstimationRequest).build());
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can
     * be stored and viewed in DevOps Guru.
     * </p>
     *
     * @param updateEventSourcesConfigRequest
     * @return A Java Future containing the result of the UpdateEventSourcesConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.UpdateEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventSourcesConfigResponse> updateEventSourcesConfig(
            UpdateEventSourcesConfigRequest updateEventSourcesConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can
     * be stored and viewed in DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventSourcesConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEventSourcesConfigRequest#builder()}
     * </p>
     *
     * @param updateEventSourcesConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateEventSourcesConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.UpdateEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventSourcesConfigResponse> updateEventSourcesConfig(
            Consumer<UpdateEventSourcesConfigRequest.Builder> updateEventSourcesConfigRequest) {
        return updateEventSourcesConfig(UpdateEventSourcesConfigRequest.builder().applyMutation(updateEventSourcesConfigRequest)
                .build());
    }

    /**
     * <p>
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource
     * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that
     * contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
     * resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to
     * 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use
     * DevOps Guru.
     * </p>
     *
     * @param updateResourceCollectionRequest
     * @return A Java Future containing the result of the UpdateResourceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.UpdateResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceCollectionResponse> updateResourceCollection(
            UpdateResourceCollectionRequest updateResourceCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource
     * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that
     * contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
     * resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to
     * 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use
     * DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateResourceCollectionRequest#builder()}
     * </p>
     *
     * @param updateResourceCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateResourceCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.UpdateResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceCollectionResponse> updateResourceCollection(
            Consumer<UpdateResourceCollectionRequest.Builder> updateResourceCollectionRequest) {
        return updateResourceCollection(UpdateResourceCollectionRequest.builder().applyMutation(updateResourceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     *
     * @param updateServiceIntegrationRequest
     * @return A Java Future containing the result of the UpdateServiceIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.UpdateServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceIntegrationResponse> updateServiceIntegration(
            UpdateServiceIntegrationRequest updateServiceIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceIntegrationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateServiceIntegrationRequest#builder()}
     * </p>
     *
     * @param updateServiceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateServiceIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The user or role
     *         that is making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>ConflictException An exception that is thrown when a conflict occurs.</li>
     *         <li>InternalServerException An internal failure in an Amazon service occurred.</li>
     *         <li>ThrottlingException The request was denied due to a request throttling.</li>
     *         <li>ValidationException Contains information about data passed in to a field during a request that is not
     *         valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DevOpsGuruException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DevOpsGuruAsyncClient.UpdateServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceIntegrationResponse> updateServiceIntegration(
            Consumer<UpdateServiceIntegrationRequest.Builder> updateServiceIntegrationRequest) {
        return updateServiceIntegration(UpdateServiceIntegrationRequest.builder().applyMutation(updateServiceIntegrationRequest)
                .build());
    }

    @Override
    default DevOpsGuruServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DevOpsGuruAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DevOpsGuruAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DevOpsGuruAsyncClient}.
     */
    static DevOpsGuruAsyncClientBuilder builder() {
        return new DefaultDevOpsGuruAsyncClientBuilder();
    }
}
