/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies one or more service names that are used to list anomalies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomaliesForInsightFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListAnomaliesForInsightFilters.Builder, ListAnomaliesForInsightFilters> {
    private static final SdkField<ServiceCollection> SERVICE_COLLECTION_FIELD = SdkField
            .<ServiceCollection> builder(MarshallingType.SDK_POJO).memberName("ServiceCollection")
            .getter(getter(ListAnomaliesForInsightFilters::serviceCollection)).setter(setter(Builder::serviceCollection))
            .constructor(ServiceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCollection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_COLLECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ServiceCollection serviceCollection;

    private ListAnomaliesForInsightFilters(BuilderImpl builder) {
        this.serviceCollection = builder.serviceCollection;
    }

    /**
     * Returns the value of the ServiceCollection property for this object.
     * 
     * @return The value of the ServiceCollection property for this object.
     */
    public final ServiceCollection serviceCollection() {
        return serviceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomaliesForInsightFilters)) {
            return false;
        }
        ListAnomaliesForInsightFilters other = (ListAnomaliesForInsightFilters) obj;
        return Objects.equals(serviceCollection(), other.serviceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomaliesForInsightFilters").add("ServiceCollection", serviceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCollection":
            return Optional.ofNullable(clazz.cast(serviceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomaliesForInsightFilters, T> g) {
        return obj -> g.apply((ListAnomaliesForInsightFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListAnomaliesForInsightFilters> {
        /**
         * Sets the value of the ServiceCollection property for this object.
         *
         * @param serviceCollection
         *        The new value for the ServiceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCollection(ServiceCollection serviceCollection);

        /**
         * Sets the value of the ServiceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ServiceCollection.Builder} avoiding the
         * need to create one manually via {@link ServiceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceCollection(ServiceCollection)}.
         * 
         * @param serviceCollection
         *        a consumer that will call methods on {@link ServiceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCollection(ServiceCollection)
         */
        default Builder serviceCollection(Consumer<ServiceCollection.Builder> serviceCollection) {
            return serviceCollection(ServiceCollection.builder().applyMutation(serviceCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceCollection serviceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomaliesForInsightFilters model) {
            serviceCollection(model.serviceCollection);
        }

        public final ServiceCollection.Builder getServiceCollection() {
            return serviceCollection != null ? serviceCollection.toBuilder() : null;
        }

        public final void setServiceCollection(ServiceCollection.BuilderImpl serviceCollection) {
            this.serviceCollection = serviceCollection != null ? serviceCollection.build() : null;
        }

        @Override
        public final Builder serviceCollection(ServiceCollection serviceCollection) {
            this.serviceCollection = serviceCollection;
            return this;
        }

        @Override
        public ListAnomaliesForInsightFilters build() {
            return new ListAnomaliesForInsightFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
