/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a public virtual interface to be provisioned on a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewPublicVirtualInterfaceAllocation implements SdkPojo, Serializable,
        ToCopyableBuilder<NewPublicVirtualInterfaceAllocation.Builder, NewPublicVirtualInterfaceAllocation> {
    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceName").getter(getter(NewPublicVirtualInterfaceAllocation::virtualInterfaceName))
            .setter(setter(Builder::virtualInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build())
            .build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("vlan")
            .getter(getter(NewPublicVirtualInterfaceAllocation::vlan)).setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()).build();

    private static final SdkField<Integer> ASN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("asn")
            .getter(getter(NewPublicVirtualInterfaceAllocation::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authKey").getter(getter(NewPublicVirtualInterfaceAllocation::authKey)).setter(setter(Builder::authKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()).build();

    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amazonAddress").getter(getter(NewPublicVirtualInterfaceAllocation::amazonAddress))
            .setter(setter(Builder::amazonAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()).build();

    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerAddress").getter(getter(NewPublicVirtualInterfaceAllocation::customerAddress))
            .setter(setter(Builder::customerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressFamily").getter(getter(NewPublicVirtualInterfaceAllocation::addressFamilyAsString))
            .setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()).build();

    private static final SdkField<List<RouteFilterPrefix>> ROUTE_FILTER_PREFIXES_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .memberName("routeFilterPrefixes")
            .getter(getter(NewPublicVirtualInterfaceAllocation::routeFilterPrefixes))
            .setter(setter(Builder::routeFilterPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeFilterPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(NewPublicVirtualInterfaceAllocation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_NAME_FIELD,
            VLAN_FIELD, ASN_FIELD, AUTH_KEY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, ADDRESS_FAMILY_FIELD,
            ROUTE_FILTER_PREFIXES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualInterfaceName;

    private final Integer vlan;

    private final Integer asn;

    private final String authKey;

    private final String amazonAddress;

    private final String customerAddress;

    private final String addressFamily;

    private final List<RouteFilterPrefix> routeFilterPrefixes;

    private final List<Tag> tags;

    private NewPublicVirtualInterfaceAllocation(BuilderImpl builder) {
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The
     * following are valid characters: a-z, 0-9 and a hyphen (-).
     * </p>
     * 
     * @return The name of the virtual interface assigned by the customer network. The name has a maximum of 100
     *         characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
     */
    public final String virtualInterfaceName() {
        return virtualInterfaceName;
    }

    /**
     * <p>
     * The ID of the VLAN.
     * </p>
     * 
     * @return The ID of the VLAN.
     */
    public final Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * </p>
     * <p>
     * The valid values are 1-2147483647.
     * </p>
     * 
     * @return The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
     *         <p>
     *         The valid values are 1-2147483647.
     */
    public final Integer asn() {
        return asn;
    }

    /**
     * <p>
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun
     * lenth of 80 characters.
     * </p>
     * 
     * @return The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
     *         maximun lenth of 80 characters.
     */
    public final String authKey() {
        return authKey;
    }

    /**
     * <p>
     * The IP address assigned to the Amazon interface.
     * </p>
     * 
     * @return The IP address assigned to the Amazon interface.
     */
    public final String amazonAddress() {
        return amazonAddress;
    }

    /**
     * <p>
     * The IP address assigned to the customer interface.
     * </p>
     * 
     * @return The IP address assigned to the customer interface.
     */
    public final String customerAddress() {
        return customerAddress;
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(addressFamily);
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final String addressFamilyAsString() {
        return addressFamily;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteFilterPrefixes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteFilterPrefixes() {
        return routeFilterPrefixes != null && !(routeFilterPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
     * interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteFilterPrefixes} method.
     * </p>
     * 
     * @return The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
     *         interfaces.
     */
    public final List<RouteFilterPrefix> routeFilterPrefixes() {
        return routeFilterPrefixes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the public virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the public virtual interface.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(authKey());
        hashCode = 31 * hashCode + Objects.hashCode(amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteFilterPrefixes() ? routeFilterPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewPublicVirtualInterfaceAllocation)) {
            return false;
        }
        NewPublicVirtualInterfaceAllocation other = (NewPublicVirtualInterfaceAllocation) obj;
        return Objects.equals(virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(asn(), other.asn()) && Objects.equals(authKey(), other.authKey())
                && Objects.equals(amazonAddress(), other.amazonAddress())
                && Objects.equals(customerAddress(), other.customerAddress())
                && Objects.equals(addressFamilyAsString(), other.addressFamilyAsString())
                && hasRouteFilterPrefixes() == other.hasRouteFilterPrefixes()
                && Objects.equals(routeFilterPrefixes(), other.routeFilterPrefixes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewPublicVirtualInterfaceAllocation").add("VirtualInterfaceName", virtualInterfaceName())
                .add("Vlan", vlan()).add("Asn", asn()).add("AuthKey", authKey()).add("AmazonAddress", amazonAddress())
                .add("CustomerAddress", customerAddress()).add("AddressFamily", addressFamilyAsString())
                .add("RouteFilterPrefixes", hasRouteFilterPrefixes() ? routeFilterPrefixes() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceName":
            return Optional.ofNullable(clazz.cast(virtualInterfaceName()));
        case "vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "authKey":
            return Optional.ofNullable(clazz.cast(authKey()));
        case "amazonAddress":
            return Optional.ofNullable(clazz.cast(amazonAddress()));
        case "customerAddress":
            return Optional.ofNullable(clazz.cast(customerAddress()));
        case "addressFamily":
            return Optional.ofNullable(clazz.cast(addressFamilyAsString()));
        case "routeFilterPrefixes":
            return Optional.ofNullable(clazz.cast(routeFilterPrefixes()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewPublicVirtualInterfaceAllocation, T> g) {
        return obj -> g.apply((NewPublicVirtualInterfaceAllocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewPublicVirtualInterfaceAllocation> {
        /**
         * <p>
         * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters.
         * The following are valid characters: a-z, 0-9 and a hyphen (-).
         * </p>
         * 
         * @param virtualInterfaceName
         *        The name of the virtual interface assigned by the customer network. The name has a maximum of 100
         *        characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceName(String virtualInterfaceName);

        /**
         * <p>
         * The ID of the VLAN.
         * </p>
         * 
         * @param vlan
         *        The ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * </p>
         * <p>
         * The valid values are 1-2147483647.
         * </p>
         * 
         * @param asn
         *        The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
         *        <p>
         *        The valid values are 1-2147483647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Integer asn);

        /**
         * <p>
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
         * maximun lenth of 80 characters.
         * </p>
         * 
         * @param authKey
         *        The authentication key for BGP configuration. This string has a minimum length of 6 characters and and
         *        a maximun lenth of 80 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authKey(String authKey);

        /**
         * <p>
         * The IP address assigned to the Amazon interface.
         * </p>
         * 
         * @param amazonAddress
         *        The IP address assigned to the Amazon interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonAddress(String amazonAddress);

        /**
         * <p>
         * The IP address assigned to the customer interface.
         * </p>
         * 
         * @param customerAddress
         *        The IP address assigned to the customer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAddress(String customerAddress);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(AddressFamily addressFamily);

        /**
         * <p>
         * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
         * interfaces.
         * </p>
         * 
         * @param routeFilterPrefixes
         *        The routes to be advertised to the Amazon Web Services network in this Region. Applies to public
         *        virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes);

        /**
         * <p>
         * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
         * interfaces.
         * </p>
         * 
         * @param routeFilterPrefixes
         *        The routes to be advertised to the Amazon Web Services network in this Region. Applies to public
         *        virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeFilterPrefixes(RouteFilterPrefix... routeFilterPrefixes);

        /**
         * <p>
         * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
         * interfaces.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder#build()} is called
         * immediately and its result is passed to {@link #routeFilterPrefixes(List<RouteFilterPrefix>)}.
         * 
         * @param routeFilterPrefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeFilterPrefixes(java.util.Collection<RouteFilterPrefix>)
         */
        Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder>... routeFilterPrefixes);

        /**
         * <p>
         * The tags associated with the public virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the public virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the public virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the public virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the public virtual interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.directconnect.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String virtualInterfaceName;

        private Integer vlan;

        private Integer asn;

        private String authKey;

        private String amazonAddress;

        private String customerAddress;

        private String addressFamily;

        private List<RouteFilterPrefix> routeFilterPrefixes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NewPublicVirtualInterfaceAllocation model) {
            virtualInterfaceName(model.virtualInterfaceName);
            vlan(model.vlan);
            asn(model.asn);
            authKey(model.authKey);
            amazonAddress(model.amazonAddress);
            customerAddress(model.customerAddress);
            addressFamily(model.addressFamily);
            routeFilterPrefixes(model.routeFilterPrefixes);
            tags(model.tags);
        }

        public final String getVirtualInterfaceName() {
            return virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final Integer getVlan() {
            return vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final Integer getAsn() {
            return asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final String getAuthKey() {
            return authKey;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final String getAmazonAddress() {
            return amazonAddress;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final String getCustomerAddress() {
            return customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final List<RouteFilterPrefix.Builder> getRouteFilterPrefixes() {
            List<RouteFilterPrefix.Builder> result = RouteFilterPrefixListCopier.copyToBuilder(this.routeFilterPrefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix.BuilderImpl> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copyFromBuilder(routeFilterPrefixes);
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix... routeFilterPrefixes) {
            routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder>... routeFilterPrefixes) {
            routeFilterPrefixes(Stream.of(routeFilterPrefixes).map(c -> RouteFilterPrefix.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NewPublicVirtualInterfaceAllocation build() {
            return new NewPublicVirtualInterfaceAllocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
