/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A snapshot of a Source Server used during recovery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoverySnapshot implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoverySnapshot.Builder, RecoverySnapshot> {
    private static final SdkField<List<String>> EBS_SNAPSHOTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ebsSnapshots")
            .getter(getter(RecoverySnapshot::ebsSnapshots))
            .setter(setter(Builder::ebsSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXPECTED_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedTimestamp").getter(getter(RecoverySnapshot::expectedTimestamp))
            .setter(setter(Builder::expectedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedTimestamp").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotID").getter(getter(RecoverySnapshot::snapshotID)).setter(setter(Builder::snapshotID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotID").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(RecoverySnapshot::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestamp").getter(getter(RecoverySnapshot::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_SNAPSHOTS_FIELD,
            EXPECTED_TIMESTAMP_FIELD, SNAPSHOT_ID_FIELD, SOURCE_SERVER_ID_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> ebsSnapshots;

    private final String expectedTimestamp;

    private final String snapshotID;

    private final String sourceServerID;

    private final String timestamp;

    private RecoverySnapshot(BuilderImpl builder) {
        this.ebsSnapshots = builder.ebsSnapshots;
        this.expectedTimestamp = builder.expectedTimestamp;
        this.snapshotID = builder.snapshotID;
        this.sourceServerID = builder.sourceServerID;
        this.timestamp = builder.timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the EbsSnapshots property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEbsSnapshots() {
        return ebsSnapshots != null && !(ebsSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EBS snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEbsSnapshots} method.
     * </p>
     * 
     * @return A list of EBS snapshots.
     */
    public final List<String> ebsSnapshots() {
        return ebsSnapshots;
    }

    /**
     * <p>
     * The timestamp of when we expect the snapshot to be taken.
     * </p>
     * 
     * @return The timestamp of when we expect the snapshot to be taken.
     */
    public final String expectedTimestamp() {
        return expectedTimestamp;
    }

    /**
     * <p>
     * The ID of the Recovery Snapshot.
     * </p>
     * 
     * @return The ID of the Recovery Snapshot.
     */
    public final String snapshotID() {
        return snapshotID;
    }

    /**
     * <p>
     * The ID of the Source Server that the snapshot was taken for.
     * </p>
     * 
     * @return The ID of the Source Server that the snapshot was taken for.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * The actual timestamp that the snapshot was taken.
     * </p>
     * 
     * @return The actual timestamp that the snapshot was taken.
     */
    public final String timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEbsSnapshots() ? ebsSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expectedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotID());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoverySnapshot)) {
            return false;
        }
        RecoverySnapshot other = (RecoverySnapshot) obj;
        return hasEbsSnapshots() == other.hasEbsSnapshots() && Objects.equals(ebsSnapshots(), other.ebsSnapshots())
                && Objects.equals(expectedTimestamp(), other.expectedTimestamp())
                && Objects.equals(snapshotID(), other.snapshotID()) && Objects.equals(sourceServerID(), other.sourceServerID())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoverySnapshot").add("EbsSnapshots", hasEbsSnapshots() ? ebsSnapshots() : null)
                .add("ExpectedTimestamp", expectedTimestamp()).add("SnapshotID", snapshotID())
                .add("SourceServerID", sourceServerID()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ebsSnapshots":
            return Optional.ofNullable(clazz.cast(ebsSnapshots()));
        case "expectedTimestamp":
            return Optional.ofNullable(clazz.cast(expectedTimestamp()));
        case "snapshotID":
            return Optional.ofNullable(clazz.cast(snapshotID()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoverySnapshot, T> g) {
        return obj -> g.apply((RecoverySnapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoverySnapshot> {
        /**
         * <p>
         * A list of EBS snapshots.
         * </p>
         * 
         * @param ebsSnapshots
         *        A list of EBS snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsSnapshots(Collection<String> ebsSnapshots);

        /**
         * <p>
         * A list of EBS snapshots.
         * </p>
         * 
         * @param ebsSnapshots
         *        A list of EBS snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsSnapshots(String... ebsSnapshots);

        /**
         * <p>
         * The timestamp of when we expect the snapshot to be taken.
         * </p>
         * 
         * @param expectedTimestamp
         *        The timestamp of when we expect the snapshot to be taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedTimestamp(String expectedTimestamp);

        /**
         * <p>
         * The ID of the Recovery Snapshot.
         * </p>
         * 
         * @param snapshotID
         *        The ID of the Recovery Snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotID(String snapshotID);

        /**
         * <p>
         * The ID of the Source Server that the snapshot was taken for.
         * </p>
         * 
         * @param sourceServerID
         *        The ID of the Source Server that the snapshot was taken for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * The actual timestamp that the snapshot was taken.
         * </p>
         * 
         * @param timestamp
         *        The actual timestamp that the snapshot was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ebsSnapshots = DefaultSdkAutoConstructList.getInstance();

        private String expectedTimestamp;

        private String snapshotID;

        private String sourceServerID;

        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoverySnapshot model) {
            ebsSnapshots(model.ebsSnapshots);
            expectedTimestamp(model.expectedTimestamp);
            snapshotID(model.snapshotID);
            sourceServerID(model.sourceServerID);
            timestamp(model.timestamp);
        }

        public final Collection<String> getEbsSnapshots() {
            if (ebsSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return ebsSnapshots;
        }

        public final void setEbsSnapshots(Collection<String> ebsSnapshots) {
            this.ebsSnapshots = EbsSnapshotsListCopier.copy(ebsSnapshots);
        }

        @Override
        public final Builder ebsSnapshots(Collection<String> ebsSnapshots) {
            this.ebsSnapshots = EbsSnapshotsListCopier.copy(ebsSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsSnapshots(String... ebsSnapshots) {
            ebsSnapshots(Arrays.asList(ebsSnapshots));
            return this;
        }

        public final String getExpectedTimestamp() {
            return expectedTimestamp;
        }

        public final void setExpectedTimestamp(String expectedTimestamp) {
            this.expectedTimestamp = expectedTimestamp;
        }

        @Override
        public final Builder expectedTimestamp(String expectedTimestamp) {
            this.expectedTimestamp = expectedTimestamp;
            return this;
        }

        public final String getSnapshotID() {
            return snapshotID;
        }

        public final void setSnapshotID(String snapshotID) {
            this.snapshotID = snapshotID;
        }

        @Override
        public final Builder snapshotID(String snapshotID) {
            this.snapshotID = snapshotID;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public RecoverySnapshot build() {
            return new RecoverySnapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
