/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSourceNetworkRecoveryRequest extends DrsRequest implements
        ToCopyableBuilder<StartSourceNetworkRecoveryRequest.Builder, StartSourceNetworkRecoveryRequest> {
    private static final SdkField<Boolean> DEPLOY_AS_NEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deployAsNew").getter(getter(StartSourceNetworkRecoveryRequest::deployAsNew))
            .setter(setter(Builder::deployAsNew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployAsNew").build()).build();

    private static final SdkField<List<StartSourceNetworkRecoveryRequestNetworkEntry>> SOURCE_NETWORKS_FIELD = SdkField
            .<List<StartSourceNetworkRecoveryRequestNetworkEntry>> builder(MarshallingType.LIST)
            .memberName("sourceNetworks")
            .getter(getter(StartSourceNetworkRecoveryRequest::sourceNetworks))
            .setter(setter(Builder::sourceNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StartSourceNetworkRecoveryRequestNetworkEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(StartSourceNetworkRecoveryRequestNetworkEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartSourceNetworkRecoveryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOY_AS_NEW_FIELD,
            SOURCE_NETWORKS_FIELD, TAGS_FIELD));

    private final Boolean deployAsNew;

    private final List<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks;

    private final Map<String, String> tags;

    private StartSourceNetworkRecoveryRequest(BuilderImpl builder) {
        super(builder);
        this.deployAsNew = builder.deployAsNew;
        this.sourceNetworks = builder.sourceNetworks;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Don't update existing CloudFormation Stack, recover the network using a new stack.
     * </p>
     * 
     * @return Don't update existing CloudFormation Stack, recover the network using a new stack.
     */
    public final Boolean deployAsNew() {
        return deployAsNew;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceNetworks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceNetworks() {
        return sourceNetworks != null && !(sourceNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Source Networks that we want to start a Recovery Job for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceNetworks} method.
     * </p>
     * 
     * @return The Source Networks that we want to start a Recovery Job for.
     */
    public final List<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks() {
        return sourceNetworks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be associated with the Source Network recovery Job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be associated with the Source Network recovery Job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deployAsNew());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceNetworks() ? sourceNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSourceNetworkRecoveryRequest)) {
            return false;
        }
        StartSourceNetworkRecoveryRequest other = (StartSourceNetworkRecoveryRequest) obj;
        return Objects.equals(deployAsNew(), other.deployAsNew()) && hasSourceNetworks() == other.hasSourceNetworks()
                && Objects.equals(sourceNetworks(), other.sourceNetworks()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSourceNetworkRecoveryRequest").add("DeployAsNew", deployAsNew())
                .add("SourceNetworks", hasSourceNetworks() ? sourceNetworks() : null)
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deployAsNew":
            return Optional.ofNullable(clazz.cast(deployAsNew()));
        case "sourceNetworks":
            return Optional.ofNullable(clazz.cast(sourceNetworks()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSourceNetworkRecoveryRequest, T> g) {
        return obj -> g.apply((StartSourceNetworkRecoveryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSourceNetworkRecoveryRequest> {
        /**
         * <p>
         * Don't update existing CloudFormation Stack, recover the network using a new stack.
         * </p>
         * 
         * @param deployAsNew
         *        Don't update existing CloudFormation Stack, recover the network using a new stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployAsNew(Boolean deployAsNew);

        /**
         * <p>
         * The Source Networks that we want to start a Recovery Job for.
         * </p>
         * 
         * @param sourceNetworks
         *        The Source Networks that we want to start a Recovery Job for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks);

        /**
         * <p>
         * The Source Networks that we want to start a Recovery Job for.
         * </p>
         * 
         * @param sourceNetworks
         *        The Source Networks that we want to start a Recovery Job for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworks(StartSourceNetworkRecoveryRequestNetworkEntry... sourceNetworks);

        /**
         * <p>
         * The Source Networks that we want to start a Recovery Job for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryRequestNetworkEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryRequestNetworkEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryRequestNetworkEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #sourceNetworks(List<StartSourceNetworkRecoveryRequestNetworkEntry>)}.
         * 
         * @param sourceNetworks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.StartSourceNetworkRecoveryRequestNetworkEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceNetworks(java.util.Collection<StartSourceNetworkRecoveryRequestNetworkEntry>)
         */
        Builder sourceNetworks(Consumer<StartSourceNetworkRecoveryRequestNetworkEntry.Builder>... sourceNetworks);

        /**
         * <p>
         * The tags to be associated with the Source Network recovery Job.
         * </p>
         * 
         * @param tags
         *        The tags to be associated with the Source Network recovery Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private Boolean deployAsNew;

        private List<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSourceNetworkRecoveryRequest model) {
            super(model);
            deployAsNew(model.deployAsNew);
            sourceNetworks(model.sourceNetworks);
            tags(model.tags);
        }

        public final Boolean getDeployAsNew() {
            return deployAsNew;
        }

        public final void setDeployAsNew(Boolean deployAsNew) {
            this.deployAsNew = deployAsNew;
        }

        @Override
        public final Builder deployAsNew(Boolean deployAsNew) {
            this.deployAsNew = deployAsNew;
            return this;
        }

        public final List<StartSourceNetworkRecoveryRequestNetworkEntry.Builder> getSourceNetworks() {
            List<StartSourceNetworkRecoveryRequestNetworkEntry.Builder> result = StartSourceNetworkRecoveryRequestNetworkEntriesCopier
                    .copyToBuilder(this.sourceNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry.BuilderImpl> sourceNetworks) {
            this.sourceNetworks = StartSourceNetworkRecoveryRequestNetworkEntriesCopier.copyFromBuilder(sourceNetworks);
        }

        @Override
        public final Builder sourceNetworks(Collection<StartSourceNetworkRecoveryRequestNetworkEntry> sourceNetworks) {
            this.sourceNetworks = StartSourceNetworkRecoveryRequestNetworkEntriesCopier.copy(sourceNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNetworks(StartSourceNetworkRecoveryRequestNetworkEntry... sourceNetworks) {
            sourceNetworks(Arrays.asList(sourceNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNetworks(Consumer<StartSourceNetworkRecoveryRequestNetworkEntry.Builder>... sourceNetworks) {
            sourceNetworks(Stream.of(sourceNetworks)
                    .map(c -> StartSourceNetworkRecoveryRequestNetworkEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSourceNetworkRecoveryRequest build() {
            return new StartSourceNetworkRecoveryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
