/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSpotFleetRequestsRequest extends Ec2Request implements
        ToCopyableBuilder<CancelSpotFleetRequestsRequest.Builder, CancelSpotFleetRequestsRequest> {
    private static final SdkField<List<String>> SPOT_FLEET_REQUEST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SpotFleetRequestIds")
            .getter(getter(CancelSpotFleetRequestsRequest::spotFleetRequestIds))
            .setter(setter(Builder::spotFleetRequestIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId")
                    .unmarshallLocationName("spotFleetRequestId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminateInstances")
            .getter(getter(CancelSpotFleetRequestsRequest::terminateInstances))
            .setter(setter(Builder::terminateInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstances")
                    .unmarshallLocationName("terminateInstances").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_FLEET_REQUEST_IDS_FIELD,
            TERMINATE_INSTANCES_FIELD));

    private final List<String> spotFleetRequestIds;

    private final Boolean terminateInstances;

    private CancelSpotFleetRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.spotFleetRequestIds = builder.spotFleetRequestIds;
        this.terminateInstances = builder.terminateInstances;
    }

    /**
     * Returns true if the SpotFleetRequestIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSpotFleetRequestIds() {
        return spotFleetRequestIds != null && !(spotFleetRequestIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Spot Fleet requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSpotFleetRequestIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the Spot Fleet requests.
     */
    public List<String> spotFleetRequestIds() {
        return spotFleetRequestIds;
    }

    /**
     * <p>
     * Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.
     * </p>
     * 
     * @return Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.
     */
    public Boolean terminateInstances() {
        return terminateInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestIds());
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsRequest)) {
            return false;
        }
        CancelSpotFleetRequestsRequest other = (CancelSpotFleetRequestsRequest) obj;
        return Objects.equals(spotFleetRequestIds(), other.spotFleetRequestIds())
                && Objects.equals(terminateInstances(), other.terminateInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CancelSpotFleetRequestsRequest").add("SpotFleetRequestIds", spotFleetRequestIds())
                .add("TerminateInstances", terminateInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotFleetRequestIds":
            return Optional.ofNullable(clazz.cast(spotFleetRequestIds()));
        case "TerminateInstances":
            return Optional.ofNullable(clazz.cast(terminateInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotFleetRequestsRequest, T> g) {
        return obj -> g.apply((CancelSpotFleetRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CancelSpotFleetRequestsRequest> {
        /**
         * <p>
         * The IDs of the Spot Fleet requests.
         * </p>
         * 
         * @param spotFleetRequestIds
         *        The IDs of the Spot Fleet requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds);

        /**
         * <p>
         * The IDs of the Spot Fleet requests.
         * </p>
         * 
         * @param spotFleetRequestIds
         *        The IDs of the Spot Fleet requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestIds(String... spotFleetRequestIds);

        /**
         * <p>
         * Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.
         * </p>
         * 
         * @param terminateInstances
         *        Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstances(Boolean terminateInstances);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> spotFleetRequestIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean terminateInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsRequest model) {
            super(model);
            spotFleetRequestIds(model.spotFleetRequestIds);
            terminateInstances(model.terminateInstances);
        }

        public final Collection<String> getSpotFleetRequestIds() {
            return spotFleetRequestIds;
        }

        @Override
        public final Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = SpotFleetRequestIdListCopier.copy(spotFleetRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestIds(String... spotFleetRequestIds) {
            spotFleetRequestIds(Arrays.asList(spotFleetRequestIds));
            return this;
        }

        public final void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = SpotFleetRequestIdListCopier.copy(spotFleetRequestIds);
        }

        public final Boolean getTerminateInstances() {
            return terminateInstances;
        }

        @Override
        public final Builder terminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
            return this;
        }

        public final void setTerminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelSpotFleetRequestsRequest build() {
            return new CancelSpotFleetRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
