/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Capacity Reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservation implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservation.Builder, CapacityReservation> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(CapacityReservation::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(CapacityReservation::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationArn")
            .getter(getter(CapacityReservation::capacityReservationArn))
            .setter(setter(Builder::capacityReservationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationArn")
                    .unmarshallLocationName("capacityReservationArn").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(CapacityReservation::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(CapacityReservation::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstancePlatform")
            .getter(getter(CapacityReservation::instancePlatformAsString))
            .setter(setter(Builder::instancePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform")
                    .unmarshallLocationName("instancePlatform").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CapacityReservation::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Tenancy")
            .getter(getter(CapacityReservation::tenancyAsString))
            .setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy")
                    .unmarshallLocationName("tenancy").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount")
            .getter(getter(CapacityReservation::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount")
                    .unmarshallLocationName("totalInstanceCount").build()).build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount")
            .getter(getter(CapacityReservation::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount")
                    .unmarshallLocationName("availableInstanceCount").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(CapacityReservation::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<Boolean> EPHEMERAL_STORAGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EphemeralStorage")
            .getter(getter(CapacityReservation::ephemeralStorage))
            .setter(setter(Builder::ephemeralStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage")
                    .unmarshallLocationName("ephemeralStorage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(CapacityReservation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate")
            .getter(getter(CapacityReservation::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("endDate").build()).build();

    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EndDateType")
            .getter(getter(CapacityReservation::endDateTypeAsString))
            .setter(setter(Builder::endDateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType")
                    .unmarshallLocationName("endDateType").build()).build();

    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceMatchCriteria")
            .getter(getter(CapacityReservation::instanceMatchCriteriaAsString))
            .setter(setter(Builder::instanceMatchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria")
                    .unmarshallLocationName("instanceMatchCriteria").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate")
            .getter(getter(CapacityReservation::createDate))
            .setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate")
                    .unmarshallLocationName("createDate").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CapacityReservation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            OWNER_ID_FIELD, CAPACITY_RESERVATION_ARN_FIELD, AVAILABILITY_ZONE_ID_FIELD, INSTANCE_TYPE_FIELD,
            INSTANCE_PLATFORM_FIELD, AVAILABILITY_ZONE_FIELD, TENANCY_FIELD, TOTAL_INSTANCE_COUNT_FIELD,
            AVAILABLE_INSTANCE_COUNT_FIELD, EBS_OPTIMIZED_FIELD, EPHEMERAL_STORAGE_FIELD, STATE_FIELD, END_DATE_FIELD,
            END_DATE_TYPE_FIELD, INSTANCE_MATCH_CRITERIA_FIELD, CREATE_DATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacityReservationId;

    private final String ownerId;

    private final String capacityReservationArn;

    private final String availabilityZoneId;

    private final String instanceType;

    private final String instancePlatform;

    private final String availabilityZone;

    private final String tenancy;

    private final Integer totalInstanceCount;

    private final Integer availableInstanceCount;

    private final Boolean ebsOptimized;

    private final Boolean ephemeralStorage;

    private final String state;

    private final Instant endDate;

    private final String endDateType;

    private final String instanceMatchCriteria;

    private final Instant createDate;

    private final List<Tag> tags;

    private CapacityReservation(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.ownerId = builder.ownerId;
        this.capacityReservationArn = builder.capacityReservationArn;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.availabilityZone = builder.availabilityZone;
        this.tenancy = builder.tenancy;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.ebsOptimized = builder.ebsOptimized;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.state = builder.state;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.createDate = builder.createDate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the AWS account that owns the Capacity Reservation.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Capacity Reservation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Capacity Reservation.
     */
    public String capacityReservationArn() {
        return capacityReservationArn;
    }

    /**
     * <p>
     * The Availability Zone ID of the Capacity Reservation.
     * </p>
     * 
     * @return The Availability Zone ID of the Capacity Reservation.
     */
    public String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The type of instance for which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The type of instance for which the Capacity Reservation reserves capacity.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(instancePlatform);
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public String instancePlatformAsString() {
        return instancePlatform;
    }

    /**
     * <p>
     * The Availability Zone in which the capacity is reserved.
     * </p>
     * 
     * @return The Availability Zone in which the capacity is reserved.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy
     * settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
     * single AWS account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
     *         tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS
     *         accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated
     *         to a single AWS account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy
     * settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
     * single AWS account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
     *         tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS
     *         accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated
     *         to a single AWS account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * The total number of instances for which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The total number of instances for which the Capacity Reservation reserves capacity.
     */
    public Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     * </p>
     * 
     * @return The remaining capacity. Indicates the number of instances that can be launched in the Capacity
     *         Reservation.
     */
    public Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated
     * throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
     * optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized
     * instance.
     * </p>
     * 
     * @return Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
     *         dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O
     *         performance. This optimization isn't available with all instance types. Additional usage charges apply
     *         when using an EBS- optimized instance.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     * </p>
     * 
     * @return Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    public Boolean ephemeralStorage() {
        return ephemeralStorage;
    }

    /**
     * <p>
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
     * request. The reserved capacity is no longer available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
     * available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
     * pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request
     * parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
     *         states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in
     *         your request. The reserved capacity is no longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
     *         longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is
     *         still pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
     *         request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for
     *         60 minutes.
     *         </p>
     *         </li>
     * @see CapacityReservationState
     */
    public CapacityReservationState state() {
        return CapacityReservationState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
     * request. The reserved capacity is no longer available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
     * available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
     * pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request
     * parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
     *         states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in
     *         your request. The reserved capacity is no longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
     *         longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is
     *         still pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
     *         request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for
     *         60 minutes.
     *         </p>
     *         </li>
     * @see CapacityReservationState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
     * capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * <code>expired</code> when it reaches its end date and time.
     * </p>
     * 
     * @return The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
     *         reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
     *         state changes to <code>expired</code> when it reaches its end date and time.
     */
    public Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public EndDateType endDateType() {
        return EndDateType.fromValue(endDateType);
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public String endDateTypeAsString() {
        return endDateType;
    }

    /**
     * <p>
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type,
     * platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation
     * automatically without specifying any additional parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance
     * type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
     *         (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the
     *         Capacity Reservation automatically without specifying any additional parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
     *         (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
     *         ensures that only permitted instances can use the reserved capacity.
     *         </p>
     *         </li>
     * @see InstanceMatchCriteria
     */
    public InstanceMatchCriteria instanceMatchCriteria() {
        return InstanceMatchCriteria.fromValue(instanceMatchCriteria);
    }

    /**
     * <p>
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type,
     * platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation
     * automatically without specifying any additional parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance
     * type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
     *         (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the
     *         Capacity Reservation automatically without specifying any additional parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
     *         (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
     *         ensures that only permitted instances can use the reserved capacity.
     *         </p>
     *         </li>
     * @see InstanceMatchCriteria
     */
    public String instanceMatchCriteriaAsString() {
        return instanceMatchCriteria;
    }

    /**
     * <p>
     * The date and time at which the Capacity Reservation was created.
     * </p>
     * 
     * @return The date and time at which the Capacity Reservation was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the Capacity Reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the Capacity Reservation.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservation)) {
            return false;
        }
        CapacityReservation other = (CapacityReservation) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(capacityReservationArn(), other.capacityReservationArn())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(instancePlatformAsString(), other.instancePlatformAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(ephemeralStorage(), other.ephemeralStorage())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(endDateTypeAsString(), other.endDateTypeAsString())
                && Objects.equals(instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CapacityReservation").add("CapacityReservationId", capacityReservationId())
                .add("OwnerId", ownerId()).add("CapacityReservationArn", capacityReservationArn())
                .add("AvailabilityZoneId", availabilityZoneId()).add("InstanceType", instanceType())
                .add("InstancePlatform", instancePlatformAsString()).add("AvailabilityZone", availabilityZone())
                .add("Tenancy", tenancyAsString()).add("TotalInstanceCount", totalInstanceCount())
                .add("AvailableInstanceCount", availableInstanceCount()).add("EbsOptimized", ebsOptimized())
                .add("EphemeralStorage", ephemeralStorage()).add("State", stateAsString()).add("EndDate", endDate())
                .add("EndDateType", endDateTypeAsString()).add("InstanceMatchCriteria", instanceMatchCriteriaAsString())
                .add("CreateDate", createDate()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CapacityReservationArn":
            return Optional.ofNullable(clazz.cast(capacityReservationArn()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstancePlatform":
            return Optional.ofNullable(clazz.cast(instancePlatformAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "EphemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "EndDateType":
            return Optional.ofNullable(clazz.cast(endDateTypeAsString()));
        case "InstanceMatchCriteria":
            return Optional.ofNullable(clazz.cast(instanceMatchCriteriaAsString()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservation, T> g) {
        return obj -> g.apply((CapacityReservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservation> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The ID of the AWS account that owns the Capacity Reservation.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that owns the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationArn
         *        The Amazon Resource Name (ARN) of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationArn(String capacityReservationArn);

        /**
         * <p>
         * The Availability Zone ID of the Capacity Reservation.
         * </p>
         * 
         * @param availabilityZoneId
         *        The Availability Zone ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The type of instance for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The type of instance for which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(String instancePlatform);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform);

        /**
         * <p>
         * The Availability Zone in which the capacity is reserved.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the capacity is reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
         * tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS
         * accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single AWS account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS
         *        accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single AWS account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
         * tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS
         * accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single AWS account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS
         *        accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single AWS account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(CapacityReservationTenancy tenancy);

        /**
         * <p>
         * The total number of instances for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param totalInstanceCount
         *        The total number of instances for which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         * </p>
         * 
         * @param availableInstanceCount
         *        The remaining capacity. Indicates the number of instances that can be launched in the Capacity
         *        Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
         * dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance.
         * This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-
         * optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization
         *        provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal
         *        I/O performance. This optimization isn't available with all instance types. Additional usage charges
         *        apply when using an EBS- optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
         * </p>
         * 
         * @param ephemeralStorage
         *        Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(Boolean ephemeralStorage);

        /**
         * <p>
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
         * available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         * request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60
         * minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
         *        longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         *        request parameters, capacity constraints, or instance limit constraints. Failed requests are retained
         *        for 60 minutes.
         *        </p>
         *        </li>
         * @see CapacityReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
         * available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         * request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60
         * minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
         *        longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         *        request parameters, capacity constraints, or instance limit constraints. Failed requests are retained
         *        for 60 minutes.
         *        </p>
         *        </li>
         * @see CapacityReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationState
         */
        Builder state(CapacityReservationState state);

        /**
         * <p>
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         * reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
         * state changes to <code>expired</code> when it reaches its end date and time.
         * </p>
         * 
         * @param endDate
         *        The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         *        reserved capacity is released and you can no longer launch instances into it. The Capacity
         *        Reservation's state changes to <code>expired</code> when it reaches its end date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(String endDateType);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(EndDateType endDateType);

        /**
         * <p>
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance
         * type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity
         * Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceMatchCriteria
         *        Indicates the type of instance launches that the Capacity Reservation accepts. The options
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
         *        (instance type, platform, and Availability Zone). Instances that have matching attributes launch into
         *        the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(String instanceMatchCriteria);

        /**
         * <p>
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance
         * type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity
         * Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceMatchCriteria
         *        Indicates the type of instance launches that the Capacity Reservation accepts. The options
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
         *        (instance type, platform, and Availability Zone). Instances that have matching attributes launch into
         *        the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria);

        /**
         * <p>
         * The date and time at which the Capacity Reservation was created.
         * </p>
         * 
         * @param createDate
         *        The date and time at which the Capacity Reservation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * Any tags assigned to the Capacity Reservation.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the Capacity Reservation.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the Capacity Reservation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationId;

        private String ownerId;

        private String capacityReservationArn;

        private String availabilityZoneId;

        private String instanceType;

        private String instancePlatform;

        private String availabilityZone;

        private String tenancy;

        private Integer totalInstanceCount;

        private Integer availableInstanceCount;

        private Boolean ebsOptimized;

        private Boolean ephemeralStorage;

        private String state;

        private Instant endDate;

        private String endDateType;

        private String instanceMatchCriteria;

        private Instant createDate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservation model) {
            capacityReservationId(model.capacityReservationId);
            ownerId(model.ownerId);
            capacityReservationArn(model.capacityReservationArn);
            availabilityZoneId(model.availabilityZoneId);
            instanceType(model.instanceType);
            instancePlatform(model.instancePlatform);
            availabilityZone(model.availabilityZone);
            tenancy(model.tenancy);
            totalInstanceCount(model.totalInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            ebsOptimized(model.ebsOptimized);
            ephemeralStorage(model.ephemeralStorage);
            state(model.state);
            endDate(model.endDate);
            endDateType(model.endDateType);
            instanceMatchCriteria(model.instanceMatchCriteria);
            createDate(model.createDate);
            tags(model.tags);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCapacityReservationArn() {
            return capacityReservationArn;
        }

        @Override
        public final Builder capacityReservationArn(String capacityReservationArn) {
            this.capacityReservationArn = capacityReservationArn;
            return this;
        }

        public final void setCapacityReservationArn(String capacityReservationArn) {
            this.capacityReservationArn = capacityReservationArn;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getInstancePlatform() {
            return instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEphemeralStorage() {
            return ephemeralStorage;
        }

        @Override
        public final Builder ephemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final void setEphemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final String getEndDateType() {
            return endDateType;
        }

        @Override
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        public final String getInstanceMatchCriteria() {
            return instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public CapacityReservation build() {
            return new CapacityReservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
