/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlacementGroupRequest extends Ec2Request implements
        ToCopyableBuilder<CreatePlacementGroupRequest.Builder, CreatePlacementGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(CreatePlacementGroupRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Strategy")
            .getter(getter(CreatePlacementGroupRequest::strategyAsString))
            .setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy")
                    .unmarshallLocationName("strategy").build()).build();

    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionCount")
            .getter(getter(CreatePlacementGroupRequest::partitionCount))
            .setter(setter(Builder::partitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionCount")
                    .unmarshallLocationName("PartitionCount").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreatePlacementGroupRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            STRATEGY_FIELD, PARTITION_COUNT_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String groupName;

    private final String strategy;

    private final Integer partitionCount;

    private final List<TagSpecification> tagSpecifications;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
        this.partitionCount = builder.partitionCount;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * A name for the placement group. Must be unique within the scope of your account for the Region.
     * </p>
     * <p>
     * Constraints: Up to 255 ASCII characters
     * </p>
     * 
     * @return A name for the placement group. Must be unique within the scope of your account for the Region.</p>
     *         <p>
     *         Constraints: Up to 255 ASCII characters
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
     * </p>
     * 
     * @return The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
     */
    public Integer partitionCount() {
        return partitionCount;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the new placement group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply to the new placement group.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(strategyAsString(), other.strategyAsString())
                && Objects.equals(partitionCount(), other.partitionCount())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePlacementGroupRequest").add("GroupName", groupName()).add("Strategy", strategyAsString())
                .add("PartitionCount", partitionCount()).add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "PartitionCount":
            return Optional.ofNullable(clazz.cast(partitionCount()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlacementGroupRequest, T> g) {
        return obj -> g.apply((CreatePlacementGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        /**
         * <p>
         * A name for the placement group. Must be unique within the scope of your account for the Region.
         * </p>
         * <p>
         * Constraints: Up to 255 ASCII characters
         * </p>
         * 
         * @param groupName
         *        A name for the placement group. Must be unique within the scope of your account for the Region.</p>
         *        <p>
         *        Constraints: Up to 255 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(PlacementStrategy strategy);

        /**
         * <p>
         * The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
         * </p>
         * 
         * @param partitionCount
         *        The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionCount(Integer partitionCount);

        /**
         * <p>
         * The tags to apply to the new placement group.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new placement group.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new placement group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String groupName;

        private String strategy;

        private Integer partitionCount;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            super(model);
            groupName(model.groupName);
            strategy(model.strategy);
            partitionCount(model.partitionCount);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStrategy() {
            return strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final Integer getPartitionCount() {
            return partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
