/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReservedInstancesListingRequest extends Ec2Request implements
        ToCopyableBuilder<CreateReservedInstancesListingRequest.Builder, CreateReservedInstancesListingRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateReservedInstancesListingRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(CreateReservedInstancesListingRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<List<PriceScheduleSpecification>> PRICE_SCHEDULES_FIELD = SdkField
            .<List<PriceScheduleSpecification>> builder(MarshallingType.LIST)
            .memberName("PriceSchedules")
            .getter(getter(CreateReservedInstancesListingRequest::priceSchedules))
            .setter(setter(Builder::priceSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceSchedules")
                    .unmarshallLocationName("priceSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PriceScheduleSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PriceScheduleSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedInstancesId")
            .getter(getter(CreateReservedInstancesListingRequest::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("reservedInstancesId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            INSTANCE_COUNT_FIELD, PRICE_SCHEDULES_FIELD, RESERVED_INSTANCES_ID_FIELD));

    private final String clientToken;

    private final Integer instanceCount;

    private final List<PriceScheduleSpecification> priceSchedules;

    private final String reservedInstancesId;

    private CreateReservedInstancesListingRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate
     * listings. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
     *         duplicate listings. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance
     * Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance
     * ID specified in this call.
     * </p>
     * 
     * @return The number of instances that are a part of a Reserved Instance account to be listed in the Reserved
     *         Instance Marketplace. This number should be less than or equal to the instance count associated with the
     *         Reserved Instance ID specified in this call.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * Returns true if the PriceSchedules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPriceSchedules() {
        return priceSchedules != null && !(priceSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance
     * term.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPriceSchedules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
     *         Instance term.
     */
    public List<PriceScheduleSpecification> priceSchedules() {
        return priceSchedules;
    }

    /**
     * <p>
     * The ID of the active Standard Reserved Instance.
     * </p>
     * 
     * @return The ID of the active Standard Reserved Instance.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(priceSchedules(), other.priceSchedules())
                && Objects.equals(reservedInstancesId(), other.reservedInstancesId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReservedInstancesListingRequest").add("ClientToken", clientToken())
                .add("InstanceCount", instanceCount()).add("PriceSchedules", priceSchedules())
                .add("ReservedInstancesId", reservedInstancesId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "PriceSchedules":
            return Optional.ofNullable(clazz.cast(priceSchedules()));
        case "ReservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReservedInstancesListingRequest, T> g) {
        return obj -> g.apply((CreateReservedInstancesListingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
         * duplicate listings. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid
         *        duplicate listings. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance
         * Marketplace. This number should be less than or equal to the instance count associated with the Reserved
         * Instance ID specified in this call.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that are a part of a Reserved Instance account to be listed in the Reserved
         *        Instance Marketplace. This number should be less than or equal to the instance count associated with
         *        the Reserved Instance ID specified in this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * 
         * @param priceSchedules
         *        A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         *        Instance term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * 
         * @param priceSchedules
         *        A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         *        Instance term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(PriceScheduleSpecification... priceSchedules);

        /**
         * <p>
         * A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved
         * Instance term.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PriceScheduleSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<PriceScheduleSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PriceScheduleSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #priceSchedules(List<PriceScheduleSpecification>)}.
         * 
         * @param priceSchedules
         *        a consumer that will call methods on {@link List<PriceScheduleSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #priceSchedules(List<PriceScheduleSpecification>)
         */
        Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder>... priceSchedules);

        /**
         * <p>
         * The ID of the active Standard Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the active Standard Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private Integer instanceCount;

        private List<PriceScheduleSpecification> priceSchedules = DefaultSdkAutoConstructList.getInstance();

        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingRequest model) {
            super(model);
            clientToken(model.clientToken);
            instanceCount(model.instanceCount);
            priceSchedules(model.priceSchedules);
            reservedInstancesId(model.reservedInstancesId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<PriceScheduleSpecification.Builder> getPriceSchedules() {
            return priceSchedules != null ? priceSchedules.stream().map(PriceScheduleSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceScheduleSpecification... priceSchedules) {
            priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder>... priceSchedules) {
            priceSchedules(Stream.of(priceSchedules).map(c -> PriceScheduleSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceScheduleSpecification.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReservedInstancesListingRequest build() {
            return new CreateReservedInstancesListingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
