/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointConnectionNotificationRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVpcEndpointConnectionNotificationRequest.Builder, CreateVpcEndpointConnectionNotificationRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceId")
            .getter(getter(CreateVpcEndpointConnectionNotificationRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("ServiceId").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId")
            .getter(getter(CreateVpcEndpointConnectionNotificationRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("VpcEndpointId").build()).build();

    private static final SdkField<String> CONNECTION_NOTIFICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionNotificationArn")
            .getter(getter(CreateVpcEndpointConnectionNotificationRequest::connectionNotificationArn))
            .setter(setter(Builder::connectionNotificationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationArn")
                    .unmarshallLocationName("ConnectionNotificationArn").build()).build();

    private static final SdkField<List<String>> CONNECTION_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConnectionEvents")
            .getter(getter(CreateVpcEndpointConnectionNotificationRequest::connectionEvents))
            .setter(setter(Builder::connectionEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEvents")
                    .unmarshallLocationName("ConnectionEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateVpcEndpointConnectionNotificationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            VPC_ENDPOINT_ID_FIELD, CONNECTION_NOTIFICATION_ARN_FIELD, CONNECTION_EVENTS_FIELD, CLIENT_TOKEN_FIELD));

    private final String serviceId;

    private final String vpcEndpointId;

    private final String connectionNotificationArn;

    private final List<String> connectionEvents;

    private final String clientToken;

    private CreateVpcEndpointConnectionNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.connectionNotificationArn = builder.connectionNotificationArn;
        this.connectionEvents = builder.connectionEvents;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the endpoint service.
     * </p>
     * 
     * @return The ID of the endpoint service.
     */
    public String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The ID of the endpoint.
     * </p>
     * 
     * @return The ID of the endpoint.
     */
    public String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The ARN of the SNS topic for the notifications.
     * </p>
     * 
     * @return The ARN of the SNS topic for the notifications.
     */
    public String connectionNotificationArn() {
        return connectionNotificationArn;
    }

    /**
     * Returns true if the ConnectionEvents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConnectionEvents() {
        return connectionEvents != null && !(connectionEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>,
     * <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectionEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>,
     *         <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.
     */
    public List<String> connectionEvents() {
        return connectionEvents;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionEvents());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointConnectionNotificationRequest)) {
            return false;
        }
        CreateVpcEndpointConnectionNotificationRequest other = (CreateVpcEndpointConnectionNotificationRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(connectionNotificationArn(), other.connectionNotificationArn())
                && Objects.equals(connectionEvents(), other.connectionEvents())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcEndpointConnectionNotificationRequest").add("ServiceId", serviceId())
                .add("VpcEndpointId", vpcEndpointId()).add("ConnectionNotificationArn", connectionNotificationArn())
                .add("ConnectionEvents", connectionEvents()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "ConnectionNotificationArn":
            return Optional.ofNullable(clazz.cast(connectionNotificationArn()));
        case "ConnectionEvents":
            return Optional.ofNullable(clazz.cast(connectionEvents()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointConnectionNotificationRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointConnectionNotificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcEndpointConnectionNotificationRequest> {
        /**
         * <p>
         * The ID of the endpoint service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The ID of the endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The ARN of the SNS topic for the notifications.
         * </p>
         * 
         * @param connectionNotificationArn
         *        The ARN of the SNS topic for the notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationArn(String connectionNotificationArn);

        /**
         * <p>
         * One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>,
         * <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.
         * </p>
         * 
         * @param connectionEvents
         *        One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>,
         *        <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEvents(Collection<String> connectionEvents);

        /**
         * <p>
         * One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>,
         * <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.
         * </p>
         * 
         * @param connectionEvents
         *        One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>,
         *        <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEvents(String... connectionEvents);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String serviceId;

        private String vpcEndpointId;

        private String connectionNotificationArn;

        private List<String> connectionEvents = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointConnectionNotificationRequest model) {
            super(model);
            serviceId(model.serviceId);
            vpcEndpointId(model.vpcEndpointId);
            connectionNotificationArn(model.connectionNotificationArn);
            connectionEvents(model.connectionEvents);
            clientToken(model.clientToken);
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getConnectionNotificationArn() {
            return connectionNotificationArn;
        }

        @Override
        public final Builder connectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        public final void setConnectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
        }

        public final Collection<String> getConnectionEvents() {
            return connectionEvents;
        }

        @Override
        public final Builder connectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionEvents(String... connectionEvents) {
            connectionEvents(Arrays.asList(connectionEvents));
            return this;
        }

        public final void setConnectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointConnectionNotificationRequest build() {
            return new CreateVpcEndpointConnectionNotificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
