/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcPeeringConnectionRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVpcPeeringConnectionRequest.Builder, CreateVpcPeeringConnectionRequest> {
    private static final SdkField<String> PEER_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerOwnerId")
            .getter(getter(CreateVpcPeeringConnectionRequest::peerOwnerId))
            .setter(setter(Builder::peerOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerOwnerId")
                    .unmarshallLocationName("peerOwnerId").build()).build();

    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcId")
            .getter(getter(CreateVpcPeeringConnectionRequest::peerVpcId))
            .setter(setter(Builder::peerVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId")
                    .unmarshallLocationName("peerVpcId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(CreateVpcPeeringConnectionRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> PEER_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerRegion")
            .getter(getter(CreateVpcPeeringConnectionRequest::peerRegion))
            .setter(setter(Builder::peerRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerRegion")
                    .unmarshallLocationName("PeerRegion").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateVpcPeeringConnectionRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEER_OWNER_ID_FIELD,
            PEER_VPC_ID_FIELD, VPC_ID_FIELD, PEER_REGION_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String peerOwnerId;

    private final String peerVpcId;

    private final String vpcId;

    private final String peerRegion;

    private final List<TagSpecification> tagSpecifications;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.peerOwnerId = builder.peerOwnerId;
        this.peerVpcId = builder.peerVpcId;
        this.vpcId = builder.vpcId;
        this.peerRegion = builder.peerRegion;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the accepter VPC.
     * </p>
     * <p>
     * Default: Your AWS account ID
     * </p>
     * 
     * @return The AWS account ID of the owner of the accepter VPC.</p>
     *         <p>
     *         Default: Your AWS account ID
     */
    public String peerOwnerId() {
        return peerOwnerId;
    }

    /**
     * <p>
     * The ID of the VPC with which you are creating the VPC peering connection. You must specify this parameter in the
     * request.
     * </p>
     * 
     * @return The ID of the VPC with which you are creating the VPC peering connection. You must specify this parameter
     *         in the request.
     */
    public String peerVpcId() {
        return peerVpcId;
    }

    /**
     * <p>
     * The ID of the requester VPC. You must specify this parameter in the request.
     * </p>
     * 
     * @return The ID of the requester VPC. You must specify this parameter in the request.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The Region code for the accepter VPC, if the accepter VPC is located in a Region other than the Region in which
     * you make the request.
     * </p>
     * <p>
     * Default: The Region in which you make the request.
     * </p>
     * 
     * @return The Region code for the accepter VPC, if the accepter VPC is located in a Region other than the Region in
     *         which you make the request.</p>
     *         <p>
     *         Default: The Region in which you make the request.
     */
    public String peerRegion() {
        return peerRegion;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the peering connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to assign to the peering connection.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(peerOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(peerRegion());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest) obj;
        return Objects.equals(peerOwnerId(), other.peerOwnerId()) && Objects.equals(peerVpcId(), other.peerVpcId())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(peerRegion(), other.peerRegion())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcPeeringConnectionRequest").add("PeerOwnerId", peerOwnerId())
                .add("PeerVpcId", peerVpcId()).add("VpcId", vpcId()).add("PeerRegion", peerRegion())
                .add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeerOwnerId":
            return Optional.ofNullable(clazz.cast(peerOwnerId()));
        case "PeerVpcId":
            return Optional.ofNullable(clazz.cast(peerVpcId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "PeerRegion":
            return Optional.ofNullable(clazz.cast(peerRegion()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcPeeringConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcPeeringConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        /**
         * <p>
         * The AWS account ID of the owner of the accepter VPC.
         * </p>
         * <p>
         * Default: Your AWS account ID
         * </p>
         * 
         * @param peerOwnerId
         *        The AWS account ID of the owner of the accepter VPC.</p>
         *        <p>
         *        Default: Your AWS account ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerOwnerId(String peerOwnerId);

        /**
         * <p>
         * The ID of the VPC with which you are creating the VPC peering connection. You must specify this parameter in
         * the request.
         * </p>
         * 
         * @param peerVpcId
         *        The ID of the VPC with which you are creating the VPC peering connection. You must specify this
         *        parameter in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        /**
         * <p>
         * The ID of the requester VPC. You must specify this parameter in the request.
         * </p>
         * 
         * @param vpcId
         *        The ID of the requester VPC. You must specify this parameter in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The Region code for the accepter VPC, if the accepter VPC is located in a Region other than the Region in
         * which you make the request.
         * </p>
         * <p>
         * Default: The Region in which you make the request.
         * </p>
         * 
         * @param peerRegion
         *        The Region code for the accepter VPC, if the accepter VPC is located in a Region other than the Region
         *        in which you make the request.</p>
         *        <p>
         *        Default: The Region in which you make the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerRegion(String peerRegion);

        /**
         * <p>
         * The tags to assign to the peering connection.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to the peering connection.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to the peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String peerOwnerId;

        private String peerVpcId;

        private String vpcId;

        private String peerRegion;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            super(model);
            peerOwnerId(model.peerOwnerId);
            peerVpcId(model.peerVpcId);
            vpcId(model.vpcId);
            peerRegion(model.peerRegion);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getPeerOwnerId() {
            return peerOwnerId;
        }

        @Override
        public final Builder peerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
            return this;
        }

        public final void setPeerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getPeerRegion() {
            return peerRegion;
        }

        @Override
        public final Builder peerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
            return this;
        }

        public final void setPeerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
