/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcRequest extends Ec2Request implements ToCopyableBuilder<CreateVpcRequest.Builder, CreateVpcRequest> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(CreateVpcRequest::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("CidrBlock").build()).build();

    private static final SdkField<Boolean> AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AmazonProvidedIpv6CidrBlock")
            .getter(getter(CreateVpcRequest::amazonProvidedIpv6CidrBlock))
            .setter(setter(Builder::amazonProvidedIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonProvidedIpv6CidrBlock")
                    .unmarshallLocationName("amazonProvidedIpv6CidrBlock").build()).build();

    private static final SdkField<String> IPV6_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Pool")
            .getter(getter(CreateVpcRequest::ipv6Pool))
            .setter(setter(Builder::ipv6Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Pool")
                    .unmarshallLocationName("Ipv6Pool").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlock")
            .getter(getter(CreateVpcRequest::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("Ipv6CidrBlock").build()).build();

    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceTenancy")
            .getter(getter(CreateVpcRequest::instanceTenancyAsString))
            .setter(setter(Builder::instanceTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy")
                    .unmarshallLocationName("instanceTenancy").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6CidrBlockNetworkBorderGroup")
            .getter(getter(CreateVpcRequest::ipv6CidrBlockNetworkBorderGroup))
            .setter(setter(Builder::ipv6CidrBlockNetworkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockNetworkBorderGroup")
                    .unmarshallLocationName("Ipv6CidrBlockNetworkBorderGroup").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateVpcRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD,
            AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD, IPV6_POOL_FIELD, IPV6_CIDR_BLOCK_FIELD, INSTANCE_TENANCY_FIELD,
            IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String cidrBlock;

    private final Boolean amazonProvidedIpv6CidrBlock;

    private final String ipv6Pool;

    private final String ipv6CidrBlock;

    private final String instanceTenancy;

    private final String ipv6CidrBlockNetworkBorderGroup;

    private final List<TagSpecification> tagSpecifications;

    private CreateVpcRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.ipv6Pool = builder.ipv6Pool;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockNetworkBorderGroup = builder.ipv6CidrBlockNetworkBorderGroup;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>. We modify the
     * specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it
     * to <code>100.68.0.0/18</code>.
     * </p>
     * 
     * @return The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>. We modify
     *         the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>,
     *         we modify it to <code>100.68.0.0/18</code>.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of
     * IP addresses, or the size of the CIDR block.
     * </p>
     * 
     * @return Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
     *         range of IP addresses, or the size of the CIDR block.
     */
    public Boolean amazonProvidedIpv6CidrBlock() {
        return amazonProvidedIpv6CidrBlock;
    }

    /**
     * <p>
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     * </p>
     * 
     * @return The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    public String ipv6Pool() {
        return ipv6Pool;
    }

    /**
     * <p>
     * The IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.
     * </p>
     * <p>
     * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     * </p>
     * 
     * @return The IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the
     *         request.</p>
     *         <p>
     *         To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    public String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched with
     * shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
     * <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch
     * instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC.
     * </p>
     * <p>
     * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or
     * <code>dedicated</code> values only.
     * </p>
     * <p>
     * Default: <code>default</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched
     *         with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
     *         <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only
     *         launch instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy
     *         VPC. </p>
     *         <p>
     *         <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
     *         <code>default</code> or <code>dedicated</code> values only.
     *         </p>
     *         <p>
     *         Default: <code>default</code>
     * @see Tenancy
     */
    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched with
     * shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
     * <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch
     * instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC.
     * </p>
     * <p>
     * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or
     * <code>dedicated</code> values only.
     * </p>
     * <p>
     * Default: <code>default</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched
     *         with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
     *         <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only
     *         launch instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy
     *         VPC. </p>
     *         <p>
     *         <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
     *         <code>default</code> or <code>dedicated</code> values only.
     *         </p>
     *         <p>
     *         Default: <code>default</code>
     * @see Tenancy
     */
    public String instanceTenancyAsString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to
     * this location.
     * </p>
     * <p>
     * You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
     * </p>
     * 
     * @return The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the
     *         address to this location.</p>
     *         <p>
     *         You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
     */
    public String ipv6CidrBlockNetworkBorderGroup() {
        return ipv6CidrBlockNetworkBorderGroup;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to assign to the VPC.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(amazonProvidedIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Pool());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockNetworkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock())
                && Objects.equals(amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock())
                && Objects.equals(ipv6Pool(), other.ipv6Pool()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(instanceTenancyAsString(), other.instanceTenancyAsString())
                && Objects.equals(ipv6CidrBlockNetworkBorderGroup(), other.ipv6CidrBlockNetworkBorderGroup())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcRequest").add("CidrBlock", cidrBlock())
                .add("AmazonProvidedIpv6CidrBlock", amazonProvidedIpv6CidrBlock()).add("Ipv6Pool", ipv6Pool())
                .add("Ipv6CidrBlock", ipv6CidrBlock()).add("InstanceTenancy", instanceTenancyAsString())
                .add("Ipv6CidrBlockNetworkBorderGroup", ipv6CidrBlockNetworkBorderGroup())
                .add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "AmazonProvidedIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(amazonProvidedIpv6CidrBlock()));
        case "Ipv6Pool":
            return Optional.ofNullable(clazz.cast(ipv6Pool()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "InstanceTenancy":
            return Optional.ofNullable(clazz.cast(instanceTenancyAsString()));
        case "Ipv6CidrBlockNetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockNetworkBorderGroup()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcRequest, T> g) {
        return obj -> g.apply((CreateVpcRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcRequest> {
        /**
         * <p>
         * The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>. We modify the
         * specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we
         * modify it to <code>100.68.0.0/18</code>.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>. We modify
         *        the specified CIDR block to its canonical form; for example, if you specify
         *        <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
         * range of IP addresses, or the size of the CIDR block.
         * </p>
         * 
         * @param amazonProvidedIpv6CidrBlock
         *        Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify
         *        the range of IP addresses, or the size of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock);

        /**
         * <p>
         * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         * </p>
         * 
         * @param ipv6Pool
         *        The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Pool(String ipv6Pool);

        /**
         * <p>
         * The IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.
         * </p>
         * <p>
         * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the
         *        request.</p>
         *        <p>
         *        To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched
         * with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
         * <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch
         * instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC.
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy options for instances launched into the VPC. For <code>default</code>, instances are
         *        launched with shared tenancy by default. You can launch instances with any tenancy into a shared
         *        tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy instances by
         *        default. You can only launch instances with a tenancy of <code>dedicated</code> or <code>host</code>
         *        into a dedicated tenancy VPC. </p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched
         * with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For
         * <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch
         * instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC.
         * </p>
         * <p>
         * <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         * <code>default</code> or <code>dedicated</code> values only.
         * </p>
         * <p>
         * Default: <code>default</code>
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy options for instances launched into the VPC. For <code>default</code>, instances are
         *        launched with shared tenancy by default. You can launch instances with any tenancy into a shared
         *        tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy instances by
         *        default. You can only launch instances with a tenancy of <code>dedicated</code> or <code>host</code>
         *        into a dedicated tenancy VPC. </p>
         *        <p>
         *        <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the
         *        <code>default</code> or <code>dedicated</code> values only.
         *        </p>
         *        <p>
         *        Default: <code>default</code>
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address
         * to this location.
         * </p>
         * <p>
         * You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
         * </p>
         * 
         * @param ipv6CidrBlockNetworkBorderGroup
         *        The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the
         *        address to this location.</p>
         *        <p>
         *        You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup);

        /**
         * <p>
         * The tags to assign to the VPC.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to the VPC.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidrBlock;

        private Boolean amazonProvidedIpv6CidrBlock;

        private String ipv6Pool;

        private String ipv6CidrBlock;

        private String instanceTenancy;

        private String ipv6CidrBlockNetworkBorderGroup;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcRequest model) {
            super(model);
            cidrBlock(model.cidrBlock);
            amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            ipv6Pool(model.ipv6Pool);
            ipv6CidrBlock(model.ipv6CidrBlock);
            instanceTenancy(model.instanceTenancy);
            ipv6CidrBlockNetworkBorderGroup(model.ipv6CidrBlockNetworkBorderGroup);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        public final String getIpv6Pool() {
            return ipv6Pool;
        }

        @Override
        public final Builder ipv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
            return this;
        }

        public final void setIpv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final String getIpv6CidrBlockNetworkBorderGroup() {
            return ipv6CidrBlockNetworkBorderGroup;
        }

        @Override
        public final Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
            return this;
        }

        public final void setIpv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcRequest build() {
            return new CreateVpcRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
