/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeFleetsResponse.Builder, DescribeFleetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeFleetsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<FleetData>> FLEETS_FIELD = SdkField
            .<List<FleetData>> builder(MarshallingType.LIST)
            .memberName("Fleets")
            .getter(getter(DescribeFleetsResponse::fleets))
            .setter(setter(Builder::fleets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetSet")
                    .unmarshallLocationName("fleetSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FleetData> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, FLEETS_FIELD));

    private final String nextToken;

    private final List<FleetData> fleets;

    private DescribeFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.fleets = builder.fleets;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Fleets property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFleets() {
        return fleets != null && !(fleets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the EC2 Fleets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFleets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the EC2 Fleets.
     */
    public List<FleetData> fleets() {
        return fleets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(fleets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsResponse)) {
            return false;
        }
        DescribeFleetsResponse other = (DescribeFleetsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(fleets(), other.fleets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFleetsResponse").add("NextToken", nextToken()).add("Fleets", fleets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Fleets":
            return Optional.ofNullable(clazz.cast(fleets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetsResponse, T> g) {
        return obj -> g.apply((DescribeFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetsResponse> {
        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the EC2 Fleets.
         * </p>
         * 
         * @param fleets
         *        Information about the EC2 Fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Collection<FleetData> fleets);

        /**
         * <p>
         * Information about the EC2 Fleets.
         * </p>
         * 
         * @param fleets
         *        Information about the EC2 Fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(FleetData... fleets);

        /**
         * <p>
         * Information about the EC2 Fleets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FleetData>.Builder} avoiding the need to
         * create one manually via {@link List<FleetData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetData>.Builder#build()} is called immediately and its
         * result is passed to {@link #fleets(List<FleetData>)}.
         * 
         * @param fleets
         *        a consumer that will call methods on {@link List<FleetData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleets(List<FleetData>)
         */
        Builder fleets(Consumer<FleetData.Builder>... fleets);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<FleetData> fleets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsResponse model) {
            super(model);
            nextToken(model.nextToken);
            fleets(model.fleets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<FleetData.Builder> getFleets() {
            return fleets != null ? fleets.stream().map(FleetData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleets(Collection<FleetData> fleets) {
            this.fleets = FleetSetCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(FleetData... fleets) {
            fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Consumer<FleetData.Builder>... fleets) {
            fleets(Stream.of(fleets).map(c -> FleetData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFleets(Collection<FleetData.BuilderImpl> fleets) {
            this.fleets = FleetSetCopier.copyFromBuilder(fleets);
        }

        @Override
        public DescribeFleetsResponse build() {
            return new DescribeFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
