/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVolumesModificationsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeVolumesModificationsRequest.Builder, DescribeVolumesModificationsRequest> {
    private static final SdkField<List<String>> VOLUME_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VolumeIds")
            .getter(getter(DescribeVolumesModificationsRequest::volumeIds))
            .setter(setter(Builder::volumeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("VolumeId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VolumeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VolumeId").unmarshallLocationName("VolumeId").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeVolumesModificationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeVolumesModificationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeVolumesModificationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_IDS_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> volumeIds;

    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeVolumesModificationsRequest(BuilderImpl builder) {
        super(builder);
        this.volumeIds = builder.volumeIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the VolumeIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVolumeIds() {
        return volumeIds != null && !(volumeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumeIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the volumes.
     */
    public List<String> volumeIds() {
        return volumeIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>modification-state</code> - The current modification state (modifying | optimizing | completed | failed).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>original-iops</code> - The original IOPS rate of the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>original-size</code> - The original size of the volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2 | sc1 |
     * st1).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true | false).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start-time</code> - The modification start time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target-iops</code> - The target IOPS rate of the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target-size</code> - The target size of the volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 | sc1 | st1).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true | false).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-id</code> - The ID of the volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>modification-state</code> - The current modification state (modifying | optimizing | completed |
     *         failed).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>original-iops</code> - The original IOPS rate of the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>original-size</code> - The original size of the volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2 |
     *         sc1 | st1).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true |
     *         false).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-time</code> - The modification start time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target-iops</code> - The target IOPS rate of the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target-size</code> - The target size of the volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 | sc1
     *         | st1).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true |
     *         false).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-id</code> - The ID of the volume.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned by a previous paginated request.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned by a previous paginated request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results (up to a limit of 500) to be returned in a paginated request.
     * </p>
     * 
     * @return The maximum number of results (up to a limit of 500) to be returned in a paginated request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsRequest)) {
            return false;
        }
        DescribeVolumesModificationsRequest other = (DescribeVolumesModificationsRequest) obj;
        return Objects.equals(volumeIds(), other.volumeIds()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVolumesModificationsRequest").add("VolumeIds", volumeIds()).add("Filters", filters())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeIds":
            return Optional.ofNullable(clazz.cast(volumeIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumesModificationsRequest, T> g) {
        return obj -> g.apply((DescribeVolumesModificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVolumesModificationsRequest> {
        /**
         * <p>
         * The IDs of the volumes.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * The IDs of the volumes.
         * </p>
         * 
         * @param volumeIds
         *        The IDs of the volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>modification-state</code> - The current modification state (modifying | optimizing | completed |
         * failed).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-iops</code> - The original IOPS rate of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-size</code> - The original size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2 | sc1
         * | st1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true | false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The modification start time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-iops</code> - The target IOPS rate of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-size</code> - The target size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 | sc1 |
         * st1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true |
         * false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>modification-state</code> - The current modification state (modifying | optimizing | completed |
         *        failed).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-iops</code> - The original IOPS rate of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-size</code> - The original size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2
         *        | sc1 | st1).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true |
         *        false).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The modification start time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target-iops</code> - The target IOPS rate of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target-size</code> - The target size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 |
         *        sc1 | st1).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true
         *        | false).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>modification-state</code> - The current modification state (modifying | optimizing | completed |
         * failed).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-iops</code> - The original IOPS rate of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-size</code> - The original size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2 | sc1
         * | st1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true | false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The modification start time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-iops</code> - The target IOPS rate of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-size</code> - The target size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 | sc1 |
         * st1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true |
         * false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>modification-state</code> - The current modification state (modifying | optimizing | completed |
         *        failed).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-iops</code> - The original IOPS rate of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-size</code> - The original size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2
         *        | sc1 | st1).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true |
         *        false).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The modification start time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target-iops</code> - The target IOPS rate of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target-size</code> - The target size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 |
         *        sc1 | st1).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true
         *        | false).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>modification-state</code> - The current modification state (modifying | optimizing | completed |
         * failed).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-iops</code> - The original IOPS rate of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-size</code> - The original size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2 | sc1
         * | st1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true | false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The modification start time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-iops</code> - The target IOPS rate of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-size</code> - The target size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 | sc1 |
         * st1).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true |
         * false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The <code>nextToken</code> value returned by a previous paginated request.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned by a previous paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results (up to a limit of 500) to be returned in a paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results (up to a limit of 500) to be returned in a paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> volumeIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsRequest model) {
            super(model);
            volumeIds(model.volumeIds);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getVolumeIds() {
            return volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumesModificationsRequest build() {
            return new DescribeVolumesModificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
