/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an egress-only internet gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EgressOnlyInternetGateway implements SdkPojo, Serializable,
        ToCopyableBuilder<EgressOnlyInternetGateway.Builder, EgressOnlyInternetGateway> {
    private static final SdkField<List<InternetGatewayAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<InternetGatewayAttachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(EgressOnlyInternetGateway::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSet")
                    .unmarshallLocationName("attachmentSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InternetGatewayAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(InternetGatewayAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EgressOnlyInternetGatewayId")
            .getter(getter(EgressOnlyInternetGateway::egressOnlyInternetGatewayId))
            .setter(setter(Builder::egressOnlyInternetGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewayId")
                    .unmarshallLocationName("egressOnlyInternetGatewayId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(EgressOnlyInternetGateway::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD,
            EGRESS_ONLY_INTERNET_GATEWAY_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InternetGatewayAttachment> attachments;

    private final String egressOnlyInternetGatewayId;

    private final List<Tag> tags;

    private EgressOnlyInternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.tags = builder.tags;
    }

    /**
     * Returns true if the Attachments property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the attachment of the egress-only internet gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the attachment of the egress-only internet gateway.
     */
    public List<InternetGatewayAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The ID of the egress-only internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only internet gateway.
     */
    public String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the egress-only internet gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the egress-only internet gateway.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressOnlyInternetGateway)) {
            return false;
        }
        EgressOnlyInternetGateway other = (EgressOnlyInternetGateway) obj;
        return Objects.equals(attachments(), other.attachments())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EgressOnlyInternetGateway").add("Attachments", attachments())
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "EgressOnlyInternetGatewayId":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGatewayId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EgressOnlyInternetGateway, T> g) {
        return obj -> g.apply((EgressOnlyInternetGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EgressOnlyInternetGateway> {
        /**
         * <p>
         * Information about the attachment of the egress-only internet gateway.
         * </p>
         * 
         * @param attachments
         *        Information about the attachment of the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<InternetGatewayAttachment> attachments);

        /**
         * <p>
         * Information about the attachment of the egress-only internet gateway.
         * </p>
         * 
         * @param attachments
         *        Information about the attachment of the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(InternetGatewayAttachment... attachments);

        /**
         * <p>
         * Information about the attachment of the egress-only internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InternetGatewayAttachment>.Builder}
         * avoiding the need to create one manually via {@link List<InternetGatewayAttachment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InternetGatewayAttachment>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<InternetGatewayAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<InternetGatewayAttachment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<InternetGatewayAttachment>)
         */
        Builder attachments(Consumer<InternetGatewayAttachment.Builder>... attachments);

        /**
         * <p>
         * The ID of the egress-only internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The tags assigned to the egress-only internet gateway.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the egress-only internet gateway.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the egress-only internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the egress-only internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private List<InternetGatewayAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private String egressOnlyInternetGatewayId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EgressOnlyInternetGateway model) {
            attachments(model.attachments);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            tags(model.tags);
        }

        public final Collection<InternetGatewayAttachment.Builder> getAttachments() {
            return attachments != null ? attachments.stream().map(InternetGatewayAttachment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<InternetGatewayAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> InternetGatewayAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment.BuilderImpl> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copyFromBuilder(attachments);
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public EgressOnlyInternetGateway build() {
            return new EgressOnlyInternetGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
