/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of GetReservedInstancesExchangeQuote.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservedInstancesExchangeQuoteResponse extends Ec2Response implements
        ToCopyableBuilder<GetReservedInstancesExchangeQuoteResponse.Builder, GetReservedInstancesExchangeQuoteResponse> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<Boolean> IS_VALID_EXCHANGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsValidExchange")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::isValidExchange))
            .setter(setter(Builder::isValidExchange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsValidExchange")
                    .unmarshallLocationName("isValidExchange").build()).build();

    private static final SdkField<Instant> OUTPUT_RESERVED_INSTANCES_WILL_EXPIRE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("OutputReservedInstancesWillExpireAt")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::outputReservedInstancesWillExpireAt))
            .setter(setter(Builder::outputReservedInstancesWillExpireAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OutputReservedInstancesWillExpireAt")
                    .unmarshallLocationName("outputReservedInstancesWillExpireAt").build()).build();

    private static final SdkField<String> PAYMENT_DUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PaymentDue")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::paymentDue))
            .setter(setter(Builder::paymentDue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentDue")
                    .unmarshallLocationName("paymentDue").build()).build();

    private static final SdkField<ReservationValue> RESERVED_INSTANCE_VALUE_ROLLUP_FIELD = SdkField
            .<ReservationValue> builder(MarshallingType.SDK_POJO)
            .memberName("ReservedInstanceValueRollup")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::reservedInstanceValueRollup))
            .setter(setter(Builder::reservedInstanceValueRollup))
            .constructor(ReservationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceValueRollup")
                    .unmarshallLocationName("reservedInstanceValueRollup").build()).build();

    private static final SdkField<List<ReservedInstanceReservationValue>> RESERVED_INSTANCE_VALUE_SET_FIELD = SdkField
            .<List<ReservedInstanceReservationValue>> builder(MarshallingType.LIST)
            .memberName("ReservedInstanceValueSet")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::reservedInstanceValueSet))
            .setter(setter(Builder::reservedInstanceValueSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceValueSet")
                    .unmarshallLocationName("reservedInstanceValueSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstanceReservationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstanceReservationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<ReservationValue> TARGET_CONFIGURATION_VALUE_ROLLUP_FIELD = SdkField
            .<ReservationValue> builder(MarshallingType.SDK_POJO)
            .memberName("TargetConfigurationValueRollup")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::targetConfigurationValueRollup))
            .setter(setter(Builder::targetConfigurationValueRollup))
            .constructor(ReservationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationValueRollup")
                    .unmarshallLocationName("targetConfigurationValueRollup").build()).build();

    private static final SdkField<List<TargetReservationValue>> TARGET_CONFIGURATION_VALUE_SET_FIELD = SdkField
            .<List<TargetReservationValue>> builder(MarshallingType.LIST)
            .memberName("TargetConfigurationValueSet")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::targetConfigurationValueSet))
            .setter(setter(Builder::targetConfigurationValueSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationValueSet")
                    .unmarshallLocationName("targetConfigurationValueSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TargetReservationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetReservationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VALIDATION_FAILURE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ValidationFailureReason")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::validationFailureReason))
            .setter(setter(Builder::validationFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailureReason")
                    .unmarshallLocationName("validationFailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            IS_VALID_EXCHANGE_FIELD, OUTPUT_RESERVED_INSTANCES_WILL_EXPIRE_AT_FIELD, PAYMENT_DUE_FIELD,
            RESERVED_INSTANCE_VALUE_ROLLUP_FIELD, RESERVED_INSTANCE_VALUE_SET_FIELD, TARGET_CONFIGURATION_VALUE_ROLLUP_FIELD,
            TARGET_CONFIGURATION_VALUE_SET_FIELD, VALIDATION_FAILURE_REASON_FIELD));

    private final String currencyCode;

    private final Boolean isValidExchange;

    private final Instant outputReservedInstancesWillExpireAt;

    private final String paymentDue;

    private final ReservationValue reservedInstanceValueRollup;

    private final List<ReservedInstanceReservationValue> reservedInstanceValueSet;

    private final ReservationValue targetConfigurationValueRollup;

    private final List<TargetReservationValue> targetConfigurationValueSet;

    private final String validationFailureReason;

    private GetReservedInstancesExchangeQuoteResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.isValidExchange = builder.isValidExchange;
        this.outputReservedInstancesWillExpireAt = builder.outputReservedInstancesWillExpireAt;
        this.paymentDue = builder.paymentDue;
        this.reservedInstanceValueRollup = builder.reservedInstanceValueRollup;
        this.reservedInstanceValueSet = builder.reservedInstanceValueSet;
        this.targetConfigurationValueRollup = builder.targetConfigurationValueRollup;
        this.targetConfigurationValueSet = builder.targetConfigurationValueSet;
        this.validationFailureReason = builder.validationFailureReason;
    }

    /**
     * <p>
     * The currency of the transaction.
     * </p>
     * 
     * @return The currency of the transaction.
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
     * </p>
     * 
     * @return If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
     */
    public Boolean isValidExchange() {
        return isValidExchange;
    }

    /**
     * <p>
     * The new end date of the reservation term.
     * </p>
     * 
     * @return The new end date of the reservation term.
     */
    public Instant outputReservedInstancesWillExpireAt() {
        return outputReservedInstancesWillExpireAt;
    }

    /**
     * <p>
     * The total true upfront charge for the exchange.
     * </p>
     * 
     * @return The total true upfront charge for the exchange.
     */
    public String paymentDue() {
        return paymentDue;
    }

    /**
     * <p>
     * The cost associated with the Reserved Instance.
     * </p>
     * 
     * @return The cost associated with the Reserved Instance.
     */
    public ReservationValue reservedInstanceValueRollup() {
        return reservedInstanceValueRollup;
    }

    /**
     * Returns true if the ReservedInstanceValueSet property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReservedInstanceValueSet() {
        return reservedInstanceValueSet != null && !(reservedInstanceValueSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of your Convertible Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedInstanceValueSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration of your Convertible Reserved Instances.
     */
    public List<ReservedInstanceReservationValue> reservedInstanceValueSet() {
        return reservedInstanceValueSet;
    }

    /**
     * <p>
     * The cost associated with the Reserved Instance.
     * </p>
     * 
     * @return The cost associated with the Reserved Instance.
     */
    public ReservationValue targetConfigurationValueRollup() {
        return targetConfigurationValueRollup;
    }

    /**
     * Returns true if the TargetConfigurationValueSet property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasTargetConfigurationValueSet() {
        return targetConfigurationValueSet != null && !(targetConfigurationValueSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of the target Convertible Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetConfigurationValueSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values of the target Convertible Reserved Instances.
     */
    public List<TargetReservationValue> targetConfigurationValueSet() {
        return targetConfigurationValueSet;
    }

    /**
     * <p>
     * Describes the reason why the exchange cannot be completed.
     * </p>
     * 
     * @return Describes the reason why the exchange cannot be completed.
     */
    public String validationFailureReason() {
        return validationFailureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(isValidExchange());
        hashCode = 31 * hashCode + Objects.hashCode(outputReservedInstancesWillExpireAt());
        hashCode = 31 * hashCode + Objects.hashCode(paymentDue());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceValueSet());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfigurationValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfigurationValueSet());
        hashCode = 31 * hashCode + Objects.hashCode(validationFailureReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteResponse)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteResponse other = (GetReservedInstancesExchangeQuoteResponse) obj;
        return Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(isValidExchange(), other.isValidExchange())
                && Objects.equals(outputReservedInstancesWillExpireAt(), other.outputReservedInstancesWillExpireAt())
                && Objects.equals(paymentDue(), other.paymentDue())
                && Objects.equals(reservedInstanceValueRollup(), other.reservedInstanceValueRollup())
                && Objects.equals(reservedInstanceValueSet(), other.reservedInstanceValueSet())
                && Objects.equals(targetConfigurationValueRollup(), other.targetConfigurationValueRollup())
                && Objects.equals(targetConfigurationValueSet(), other.targetConfigurationValueSet())
                && Objects.equals(validationFailureReason(), other.validationFailureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetReservedInstancesExchangeQuoteResponse").add("CurrencyCode", currencyCode())
                .add("IsValidExchange", isValidExchange())
                .add("OutputReservedInstancesWillExpireAt", outputReservedInstancesWillExpireAt())
                .add("PaymentDue", paymentDue()).add("ReservedInstanceValueRollup", reservedInstanceValueRollup())
                .add("ReservedInstanceValueSet", reservedInstanceValueSet())
                .add("TargetConfigurationValueRollup", targetConfigurationValueRollup())
                .add("TargetConfigurationValueSet", targetConfigurationValueSet())
                .add("ValidationFailureReason", validationFailureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "IsValidExchange":
            return Optional.ofNullable(clazz.cast(isValidExchange()));
        case "OutputReservedInstancesWillExpireAt":
            return Optional.ofNullable(clazz.cast(outputReservedInstancesWillExpireAt()));
        case "PaymentDue":
            return Optional.ofNullable(clazz.cast(paymentDue()));
        case "ReservedInstanceValueRollup":
            return Optional.ofNullable(clazz.cast(reservedInstanceValueRollup()));
        case "ReservedInstanceValueSet":
            return Optional.ofNullable(clazz.cast(reservedInstanceValueSet()));
        case "TargetConfigurationValueRollup":
            return Optional.ofNullable(clazz.cast(targetConfigurationValueRollup()));
        case "TargetConfigurationValueSet":
            return Optional.ofNullable(clazz.cast(targetConfigurationValueSet()));
        case "ValidationFailureReason":
            return Optional.ofNullable(clazz.cast(validationFailureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservedInstancesExchangeQuoteResponse, T> g) {
        return obj -> g.apply((GetReservedInstancesExchangeQuoteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
        /**
         * <p>
         * The currency of the transaction.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
         * </p>
         * 
         * @param isValidExchange
         *        If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isValidExchange(Boolean isValidExchange);

        /**
         * <p>
         * The new end date of the reservation term.
         * </p>
         * 
         * @param outputReservedInstancesWillExpireAt
         *        The new end date of the reservation term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt);

        /**
         * <p>
         * The total true upfront charge for the exchange.
         * </p>
         * 
         * @param paymentDue
         *        The total true upfront charge for the exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentDue(String paymentDue);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * 
         * @param reservedInstanceValueRollup
         *        The cost associated with the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservationValue.Builder} avoiding the need to
         * create one manually via {@link ReservationValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #reservedInstanceValueRollup(ReservationValue)}.
         * 
         * @param reservedInstanceValueRollup
         *        a consumer that will call methods on {@link ReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstanceValueRollup(ReservationValue)
         */
        default Builder reservedInstanceValueRollup(Consumer<ReservationValue.Builder> reservedInstanceValueRollup) {
            return reservedInstanceValueRollup(ReservationValue.builder().applyMutation(reservedInstanceValueRollup).build());
        }

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * 
         * @param reservedInstanceValueSet
         *        The configuration of your Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet);

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * 
         * @param reservedInstanceValueSet
         *        The configuration of your Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueSet(ReservedInstanceReservationValue... reservedInstanceValueSet);

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstanceReservationValue>.Builder}
         * avoiding the need to create one manually via {@link List<ReservedInstanceReservationValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstanceReservationValue>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #reservedInstanceValueSet(List<ReservedInstanceReservationValue>)}.
         * 
         * @param reservedInstanceValueSet
         *        a consumer that will call methods on {@link List<ReservedInstanceReservationValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstanceValueSet(List<ReservedInstanceReservationValue>)
         */
        Builder reservedInstanceValueSet(Consumer<ReservedInstanceReservationValue.Builder>... reservedInstanceValueSet);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * 
         * @param targetConfigurationValueRollup
         *        The cost associated with the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservationValue.Builder} avoiding the need to
         * create one manually via {@link ReservationValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #targetConfigurationValueRollup(ReservationValue)}.
         * 
         * @param targetConfigurationValueRollup
         *        a consumer that will call methods on {@link ReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfigurationValueRollup(ReservationValue)
         */
        default Builder targetConfigurationValueRollup(Consumer<ReservationValue.Builder> targetConfigurationValueRollup) {
            return targetConfigurationValueRollup(ReservationValue.builder().applyMutation(targetConfigurationValueRollup)
                    .build());
        }

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * 
         * @param targetConfigurationValueSet
         *        The values of the target Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet);

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * 
         * @param targetConfigurationValueSet
         *        The values of the target Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueSet(TargetReservationValue... targetConfigurationValueSet);

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetReservationValue>.Builder} avoiding
         * the need to create one manually via {@link List<TargetReservationValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetReservationValue>.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfigurationValueSet(List<TargetReservationValue>)}.
         * 
         * @param targetConfigurationValueSet
         *        a consumer that will call methods on {@link List<TargetReservationValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfigurationValueSet(List<TargetReservationValue>)
         */
        Builder targetConfigurationValueSet(Consumer<TargetReservationValue.Builder>... targetConfigurationValueSet);

        /**
         * <p>
         * Describes the reason why the exchange cannot be completed.
         * </p>
         * 
         * @param validationFailureReason
         *        Describes the reason why the exchange cannot be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailureReason(String validationFailureReason);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String currencyCode;

        private Boolean isValidExchange;

        private Instant outputReservedInstancesWillExpireAt;

        private String paymentDue;

        private ReservationValue reservedInstanceValueRollup;

        private List<ReservedInstanceReservationValue> reservedInstanceValueSet = DefaultSdkAutoConstructList.getInstance();

        private ReservationValue targetConfigurationValueRollup;

        private List<TargetReservationValue> targetConfigurationValueSet = DefaultSdkAutoConstructList.getInstance();

        private String validationFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteResponse model) {
            super(model);
            currencyCode(model.currencyCode);
            isValidExchange(model.isValidExchange);
            outputReservedInstancesWillExpireAt(model.outputReservedInstancesWillExpireAt);
            paymentDue(model.paymentDue);
            reservedInstanceValueRollup(model.reservedInstanceValueRollup);
            reservedInstanceValueSet(model.reservedInstanceValueSet);
            targetConfigurationValueRollup(model.targetConfigurationValueRollup);
            targetConfigurationValueSet(model.targetConfigurationValueSet);
            validationFailureReason(model.validationFailureReason);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Boolean getIsValidExchange() {
            return isValidExchange;
        }

        @Override
        public final Builder isValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
            return this;
        }

        public final void setIsValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
        }

        public final Instant getOutputReservedInstancesWillExpireAt() {
            return outputReservedInstancesWillExpireAt;
        }

        @Override
        public final Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
            return this;
        }

        public final void setOutputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
        }

        public final String getPaymentDue() {
            return paymentDue;
        }

        @Override
        public final Builder paymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
            return this;
        }

        public final void setPaymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
        }

        public final ReservationValue.Builder getReservedInstanceValueRollup() {
            return reservedInstanceValueRollup != null ? reservedInstanceValueRollup.toBuilder() : null;
        }

        @Override
        public final Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup;
            return this;
        }

        public final void setReservedInstanceValueRollup(ReservationValue.BuilderImpl reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup != null ? reservedInstanceValueRollup.build() : null;
        }

        public final Collection<ReservedInstanceReservationValue.Builder> getReservedInstanceValueSet() {
            return reservedInstanceValueSet != null ? reservedInstanceValueSet.stream()
                    .map(ReservedInstanceReservationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copy(reservedInstanceValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceValueSet(ReservedInstanceReservationValue... reservedInstanceValueSet) {
            reservedInstanceValueSet(Arrays.asList(reservedInstanceValueSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceValueSet(
                Consumer<ReservedInstanceReservationValue.Builder>... reservedInstanceValueSet) {
            reservedInstanceValueSet(Stream.of(reservedInstanceValueSet)
                    .map(c -> ReservedInstanceReservationValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstanceValueSet(
                Collection<ReservedInstanceReservationValue.BuilderImpl> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copyFromBuilder(reservedInstanceValueSet);
        }

        public final ReservationValue.Builder getTargetConfigurationValueRollup() {
            return targetConfigurationValueRollup != null ? targetConfigurationValueRollup.toBuilder() : null;
        }

        @Override
        public final Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup;
            return this;
        }

        public final void setTargetConfigurationValueRollup(ReservationValue.BuilderImpl targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup != null ? targetConfigurationValueRollup.build()
                    : null;
        }

        public final Collection<TargetReservationValue.Builder> getTargetConfigurationValueSet() {
            return targetConfigurationValueSet != null ? targetConfigurationValueSet.stream()
                    .map(TargetReservationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copy(targetConfigurationValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurationValueSet(TargetReservationValue... targetConfigurationValueSet) {
            targetConfigurationValueSet(Arrays.asList(targetConfigurationValueSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurationValueSet(Consumer<TargetReservationValue.Builder>... targetConfigurationValueSet) {
            targetConfigurationValueSet(Stream.of(targetConfigurationValueSet)
                    .map(c -> TargetReservationValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetConfigurationValueSet(
                Collection<TargetReservationValue.BuilderImpl> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copyFromBuilder(targetConfigurationValueSet);
        }

        public final String getValidationFailureReason() {
            return validationFailureReason;
        }

        @Override
        public final Builder validationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
            return this;
        }

        public final void setValidationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
        }

        @Override
        public GetReservedInstancesExchangeQuoteResponse build() {
            return new GetReservedInstancesExchangeQuoteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
