/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a local gateway route table and a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayRouteTableVpcAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalGatewayRouteTableVpcAssociation.Builder, LocalGatewayRouteTableVpcAssociation> {
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableVpcAssociationId")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::localGatewayRouteTableVpcAssociationId))
            .setter(setter(Builder::localGatewayRouteTableVpcAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayRouteTableVpcAssociationId")
                    .unmarshallLocationName("localGatewayRouteTableVpcAssociationId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableId")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::localGatewayRouteTableId))
            .setter(setter(Builder::localGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId")
                    .unmarshallLocationName("localGatewayRouteTableId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableArn")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::localGatewayRouteTableArn))
            .setter(setter(Builder::localGatewayRouteTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableArn")
                    .unmarshallLocationName("localGatewayRouteTableArn").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LocalGatewayRouteTableVpcAssociation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION_ID_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD,
            LOCAL_GATEWAY_ROUTE_TABLE_ARN_FIELD, LOCAL_GATEWAY_ID_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localGatewayRouteTableVpcAssociationId;

    private final String localGatewayRouteTableId;

    private final String localGatewayRouteTableArn;

    private final String localGatewayId;

    private final String vpcId;

    private final String ownerId;

    private final String state;

    private final List<Tag> tags;

    private LocalGatewayRouteTableVpcAssociation(BuilderImpl builder) {
        this.localGatewayRouteTableVpcAssociationId = builder.localGatewayRouteTableVpcAssociationId;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayRouteTableArn = builder.localGatewayRouteTableArn;
        this.localGatewayId = builder.localGatewayId;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public String localGatewayRouteTableVpcAssociationId() {
        return localGatewayRouteTableVpcAssociationId;
    }

    /**
     * <p>
     * The ID of the local gateway route table.
     * </p>
     * 
     * @return The ID of the local gateway route table.
     */
    public String localGatewayRouteTableId() {
        return localGatewayRouteTableId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the local gateway route table for the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the local gateway route table for the association.
     */
    public String localGatewayRouteTableArn() {
        return localGatewayRouteTableArn;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The AWS account ID that owns the local gateway route table for the association.
     * </p>
     * 
     * @return The AWS account ID that owns the local gateway route table for the association.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * 
     * @return The state of the association.
     */
    public String state() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the association.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableVpcAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayRouteTableVpcAssociation)) {
            return false;
        }
        LocalGatewayRouteTableVpcAssociation other = (LocalGatewayRouteTableVpcAssociation) obj;
        return Objects.equals(localGatewayRouteTableVpcAssociationId(), other.localGatewayRouteTableVpcAssociationId())
                && Objects.equals(localGatewayRouteTableId(), other.localGatewayRouteTableId())
                && Objects.equals(localGatewayRouteTableArn(), other.localGatewayRouteTableArn())
                && Objects.equals(localGatewayId(), other.localGatewayId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(state(), other.state())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocalGatewayRouteTableVpcAssociation")
                .add("LocalGatewayRouteTableVpcAssociationId", localGatewayRouteTableVpcAssociationId())
                .add("LocalGatewayRouteTableId", localGatewayRouteTableId())
                .add("LocalGatewayRouteTableArn", localGatewayRouteTableArn()).add("LocalGatewayId", localGatewayId())
                .add("VpcId", vpcId()).add("OwnerId", ownerId()).add("State", state()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTableVpcAssociationId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableVpcAssociationId()));
        case "LocalGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableId()));
        case "LocalGatewayRouteTableArn":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableArn()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayRouteTableVpcAssociation, T> g) {
        return obj -> g.apply((LocalGatewayRouteTableVpcAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayRouteTableVpcAssociation> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param localGatewayRouteTableVpcAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId);

        /**
         * <p>
         * The ID of the local gateway route table.
         * </p>
         * 
         * @param localGatewayRouteTableId
         *        The ID of the local gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableId(String localGatewayRouteTableId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the local gateway route table for the association.
         * </p>
         * 
         * @param localGatewayRouteTableArn
         *        The Amazon Resource Name (ARN) of the local gateway route table for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableArn(String localGatewayRouteTableArn);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The AWS account ID that owns the local gateway route table for the association.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID that owns the local gateway route table for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the association.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayRouteTableVpcAssociationId;

        private String localGatewayRouteTableId;

        private String localGatewayRouteTableArn;

        private String localGatewayId;

        private String vpcId;

        private String ownerId;

        private String state;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayRouteTableVpcAssociation model) {
            localGatewayRouteTableVpcAssociationId(model.localGatewayRouteTableVpcAssociationId);
            localGatewayRouteTableId(model.localGatewayRouteTableId);
            localGatewayRouteTableArn(model.localGatewayRouteTableArn);
            localGatewayId(model.localGatewayId);
            vpcId(model.vpcId);
            ownerId(model.ownerId);
            state(model.state);
            tags(model.tags);
        }

        public final String getLocalGatewayRouteTableVpcAssociationId() {
            return localGatewayRouteTableVpcAssociationId;
        }

        @Override
        public final Builder localGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId) {
            this.localGatewayRouteTableVpcAssociationId = localGatewayRouteTableVpcAssociationId;
            return this;
        }

        public final void setLocalGatewayRouteTableVpcAssociationId(String localGatewayRouteTableVpcAssociationId) {
            this.localGatewayRouteTableVpcAssociationId = localGatewayRouteTableVpcAssociationId;
        }

        public final String getLocalGatewayRouteTableId() {
            return localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        public final String getLocalGatewayRouteTableArn() {
            return localGatewayRouteTableArn;
        }

        @Override
        public final Builder localGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
            return this;
        }

        public final void setLocalGatewayRouteTableArn(String localGatewayRouteTableArn) {
            this.localGatewayRouteTableArn = localGatewayRouteTableArn;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public LocalGatewayRouteTableVpcAssociation build() {
            return new LocalGatewayRouteTableVpcAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
