/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a local gateway virtual interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayVirtualInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalGatewayVirtualInterface.Builder, LocalGatewayVirtualInterface> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayVirtualInterfaceId")
            .getter(getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceId))
            .setter(setter(Builder::localGatewayVirtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayId")
            .getter(getter(LocalGatewayVirtualInterface::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Vlan")
            .getter(getter(LocalGatewayVirtualInterface::vlan))
            .setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan")
                    .unmarshallLocationName("vlan").build()).build();

    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalAddress")
            .getter(getter(LocalGatewayVirtualInterface::localAddress))
            .setter(setter(Builder::localAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress")
                    .unmarshallLocationName("localAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(LocalGatewayVirtualInterface::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("peerAddress").build()).build();

    private static final SdkField<Integer> LOCAL_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LocalBgpAsn")
            .getter(getter(LocalGatewayVirtualInterface::localBgpAsn))
            .setter(setter(Builder::localBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalBgpAsn")
                    .unmarshallLocationName("localBgpAsn").build()).build();

    private static final SdkField<Integer> PEER_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeerBgpAsn")
            .getter(getter(LocalGatewayVirtualInterface::peerBgpAsn))
            .setter(setter(Builder::peerBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn")
                    .unmarshallLocationName("peerBgpAsn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LocalGatewayVirtualInterface::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, VLAN_FIELD, LOCAL_ADDRESS_FIELD,
            PEER_ADDRESS_FIELD, LOCAL_BGP_ASN_FIELD, PEER_BGP_ASN_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localGatewayVirtualInterfaceId;

    private final String localGatewayId;

    private final Integer vlan;

    private final String localAddress;

    private final String peerAddress;

    private final Integer localBgpAsn;

    private final Integer peerBgpAsn;

    private final List<Tag> tags;

    private LocalGatewayVirtualInterface(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceId = builder.localGatewayVirtualInterfaceId;
        this.localGatewayId = builder.localGatewayId;
        this.vlan = builder.vlan;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.localBgpAsn = builder.localBgpAsn;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public String localGatewayVirtualInterfaceId() {
        return localGatewayVirtualInterfaceId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the VLAN.
     * </p>
     * 
     * @return The ID of the VLAN.
     */
    public Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The local address.
     * </p>
     * 
     * @return The local address.
     */
    public String localAddress() {
        return localAddress;
    }

    /**
     * <p>
     * The peer address.
     * </p>
     * 
     * @return The peer address.
     */
    public String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     * </p>
     * 
     * @return The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     */
    public Integer localBgpAsn() {
        return localBgpAsn;
    }

    /**
     * <p>
     * The peer BGP ASN.
     * </p>
     * 
     * @return The peer BGP ASN.
     */
    public Integer peerBgpAsn() {
        return peerBgpAsn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the virtual interface.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(localBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterface)) {
            return false;
        }
        LocalGatewayVirtualInterface other = (LocalGatewayVirtualInterface) obj;
        return Objects.equals(localGatewayVirtualInterfaceId(), other.localGatewayVirtualInterfaceId())
                && Objects.equals(localGatewayId(), other.localGatewayId()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(localAddress(), other.localAddress()) && Objects.equals(peerAddress(), other.peerAddress())
                && Objects.equals(localBgpAsn(), other.localBgpAsn()) && Objects.equals(peerBgpAsn(), other.peerBgpAsn())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocalGatewayVirtualInterface")
                .add("LocalGatewayVirtualInterfaceId", localGatewayVirtualInterfaceId()).add("LocalGatewayId", localGatewayId())
                .add("Vlan", vlan()).add("LocalAddress", localAddress()).add("PeerAddress", peerAddress())
                .add("LocalBgpAsn", localBgpAsn()).add("PeerBgpAsn", peerBgpAsn()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayVirtualInterfaceId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "Vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "LocalAddress":
            return Optional.ofNullable(clazz.cast(localAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "LocalBgpAsn":
            return Optional.ofNullable(clazz.cast(localBgpAsn()));
        case "PeerBgpAsn":
            return Optional.ofNullable(clazz.cast(peerBgpAsn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterface, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayVirtualInterface> {
        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the VLAN.
         * </p>
         * 
         * @param vlan
         *        The ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The local address.
         * </p>
         * 
         * @param localAddress
         *        The local address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localAddress(String localAddress);

        /**
         * <p>
         * The peer address.
         * </p>
         * 
         * @param peerAddress
         *        The peer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         * </p>
         * 
         * @param localBgpAsn
         *        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localBgpAsn(Integer localBgpAsn);

        /**
         * <p>
         * The peer BGP ASN.
         * </p>
         * 
         * @param peerBgpAsn
         *        The peer BGP ASN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerBgpAsn(Integer peerBgpAsn);

        /**
         * <p>
         * The tags assigned to the virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the virtual interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayVirtualInterfaceId;

        private String localGatewayId;

        private Integer vlan;

        private String localAddress;

        private String peerAddress;

        private Integer localBgpAsn;

        private Integer peerBgpAsn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterface model) {
            localGatewayVirtualInterfaceId(model.localGatewayVirtualInterfaceId);
            localGatewayId(model.localGatewayId);
            vlan(model.vlan);
            localAddress(model.localAddress);
            peerAddress(model.peerAddress);
            localBgpAsn(model.localBgpAsn);
            peerBgpAsn(model.peerBgpAsn);
            tags(model.tags);
        }

        public final String getLocalGatewayVirtualInterfaceId() {
            return localGatewayVirtualInterfaceId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
            return this;
        }

        public final void setLocalGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final Integer getVlan() {
            return vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final String getLocalAddress() {
            return localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        public final Integer getLocalBgpAsn() {
            return localBgpAsn;
        }

        @Override
        public final Builder localBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
            return this;
        }

        public final void setLocalBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
        }

        public final Integer getPeerBgpAsn() {
            return peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final void setPeerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public LocalGatewayVirtualInterface build() {
            return new LocalGatewayVirtualInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
