/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<MonitorInstancesResponse.Builder, MonitorInstancesResponse> {
    private static final SdkField<List<InstanceMonitoring>> INSTANCE_MONITORINGS_FIELD = SdkField
            .<List<InstanceMonitoring>> builder(MarshallingType.LIST)
            .memberName("InstanceMonitorings")
            .getter(getter(MonitorInstancesResponse::instanceMonitorings))
            .setter(setter(Builder::instanceMonitorings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceMonitoring> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceMonitoring::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_MONITORINGS_FIELD));

    private final List<InstanceMonitoring> instanceMonitorings;

    private MonitorInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceMonitorings = builder.instanceMonitorings;
    }

    /**
     * Returns true if the InstanceMonitorings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInstanceMonitorings() {
        return instanceMonitorings != null && !(instanceMonitorings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The monitoring information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceMonitorings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The monitoring information.
     */
    public List<InstanceMonitoring> instanceMonitorings() {
        return instanceMonitorings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceMonitorings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorInstancesResponse)) {
            return false;
        }
        MonitorInstancesResponse other = (MonitorInstancesResponse) obj;
        return Objects.equals(instanceMonitorings(), other.instanceMonitorings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MonitorInstancesResponse").add("InstanceMonitorings", instanceMonitorings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceMonitorings":
            return Optional.ofNullable(clazz.cast(instanceMonitorings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitorInstancesResponse, T> g) {
        return obj -> g.apply((MonitorInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, MonitorInstancesResponse> {
        /**
         * <p>
         * The monitoring information.
         * </p>
         * 
         * @param instanceMonitorings
         *        The monitoring information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings);

        /**
         * <p>
         * The monitoring information.
         * </p>
         * 
         * @param instanceMonitorings
         *        The monitoring information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitorings(InstanceMonitoring... instanceMonitorings);

        /**
         * <p>
         * The monitoring information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceMonitoring>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceMonitoring>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceMonitoring>.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceMonitorings(List<InstanceMonitoring>)}.
         * 
         * @param instanceMonitorings
         *        a consumer that will call methods on {@link List<InstanceMonitoring>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMonitorings(List<InstanceMonitoring>)
         */
        Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder>... instanceMonitorings);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceMonitoring> instanceMonitorings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorInstancesResponse model) {
            super(model);
            instanceMonitorings(model.instanceMonitorings);
        }

        public final Collection<InstanceMonitoring.Builder> getInstanceMonitorings() {
            return instanceMonitorings != null ? instanceMonitorings.stream().map(InstanceMonitoring::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copy(instanceMonitorings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(InstanceMonitoring... instanceMonitorings) {
            instanceMonitorings(Arrays.asList(instanceMonitorings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder>... instanceMonitorings) {
            instanceMonitorings(Stream.of(instanceMonitorings).map(c -> InstanceMonitoring.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceMonitorings(Collection<InstanceMonitoring.BuilderImpl> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copyFromBuilder(instanceMonitorings);
        }

        @Override
        public MonitorInstancesResponse build() {
            return new MonitorInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
