/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the networking features of the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInfo implements SdkPojo, Serializable, ToCopyableBuilder<NetworkInfo.Builder, NetworkInfo> {
    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkPerformance")
            .getter(getter(NetworkInfo::networkPerformance))
            .setter(setter(Builder::networkPerformance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance")
                    .unmarshallLocationName("networkPerformance").build()).build();

    private static final SdkField<Integer> MAXIMUM_NETWORK_INTERFACES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumNetworkInterfaces")
            .getter(getter(NetworkInfo::maximumNetworkInterfaces))
            .setter(setter(Builder::maximumNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkInterfaces")
                    .unmarshallLocationName("maximumNetworkInterfaces").build()).build();

    private static final SdkField<Integer> IPV4_ADDRESSES_PER_INTERFACE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4AddressesPerInterface")
            .getter(getter(NetworkInfo::ipv4AddressesPerInterface))
            .setter(setter(Builder::ipv4AddressesPerInterface))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4AddressesPerInterface")
                    .unmarshallLocationName("ipv4AddressesPerInterface").build()).build();

    private static final SdkField<Integer> IPV6_ADDRESSES_PER_INTERFACE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressesPerInterface")
            .getter(getter(NetworkInfo::ipv6AddressesPerInterface))
            .setter(setter(Builder::ipv6AddressesPerInterface))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesPerInterface")
                    .unmarshallLocationName("ipv6AddressesPerInterface").build()).build();

    private static final SdkField<Boolean> IPV6_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Ipv6Supported")
            .getter(getter(NetworkInfo::ipv6Supported))
            .setter(setter(Builder::ipv6Supported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Supported")
                    .unmarshallLocationName("ipv6Supported").build()).build();

    private static final SdkField<String> ENA_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnaSupport")
            .getter(getter(NetworkInfo::enaSupportAsString))
            .setter(setter(Builder::enaSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<Boolean> EFA_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EfaSupported")
            .getter(getter(NetworkInfo::efaSupported))
            .setter(setter(Builder::efaSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfaSupported")
                    .unmarshallLocationName("efaSupported").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PERFORMANCE_FIELD,
            MAXIMUM_NETWORK_INTERFACES_FIELD, IPV4_ADDRESSES_PER_INTERFACE_FIELD, IPV6_ADDRESSES_PER_INTERFACE_FIELD,
            IPV6_SUPPORTED_FIELD, ENA_SUPPORT_FIELD, EFA_SUPPORTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkPerformance;

    private final Integer maximumNetworkInterfaces;

    private final Integer ipv4AddressesPerInterface;

    private final Integer ipv6AddressesPerInterface;

    private final Boolean ipv6Supported;

    private final String enaSupport;

    private final Boolean efaSupported;

    private NetworkInfo(BuilderImpl builder) {
        this.networkPerformance = builder.networkPerformance;
        this.maximumNetworkInterfaces = builder.maximumNetworkInterfaces;
        this.ipv4AddressesPerInterface = builder.ipv4AddressesPerInterface;
        this.ipv6AddressesPerInterface = builder.ipv6AddressesPerInterface;
        this.ipv6Supported = builder.ipv6Supported;
        this.enaSupport = builder.enaSupport;
        this.efaSupported = builder.efaSupported;
    }

    /**
     * <p>
     * Describes the network performance.
     * </p>
     * 
     * @return Describes the network performance.
     */
    public String networkPerformance() {
        return networkPerformance;
    }

    /**
     * <p>
     * The maximum number of network interfaces for the instance type.
     * </p>
     * 
     * @return The maximum number of network interfaces for the instance type.
     */
    public Integer maximumNetworkInterfaces() {
        return maximumNetworkInterfaces;
    }

    /**
     * <p>
     * The maximum number of IPv4 addresses per network interface.
     * </p>
     * 
     * @return The maximum number of IPv4 addresses per network interface.
     */
    public Integer ipv4AddressesPerInterface() {
        return ipv4AddressesPerInterface;
    }

    /**
     * <p>
     * The maximum number of IPv6 addresses per network interface.
     * </p>
     * 
     * @return The maximum number of IPv6 addresses per network interface.
     */
    public Integer ipv6AddressesPerInterface() {
        return ipv6AddressesPerInterface;
    }

    /**
     * <p>
     * Indicates whether IPv6 is supported.
     * </p>
     * 
     * @return Indicates whether IPv6 is supported.
     */
    public Boolean ipv6Supported() {
        return ipv6Supported;
    }

    /**
     * <p>
     * Indicates whether Elastic Network Adapter (ENA) is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enaSupport} will
     * return {@link EnaSupport#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enaSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Elastic Network Adapter (ENA) is supported.
     * @see EnaSupport
     */
    public EnaSupport enaSupport() {
        return EnaSupport.fromValue(enaSupport);
    }

    /**
     * <p>
     * Indicates whether Elastic Network Adapter (ENA) is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enaSupport} will
     * return {@link EnaSupport#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enaSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Elastic Network Adapter (ENA) is supported.
     * @see EnaSupport
     */
    public String enaSupportAsString() {
        return enaSupport;
    }

    /**
     * <p>
     * Indicates whether Elastic Fabric Adapter (EFA) is supported.
     * </p>
     * 
     * @return Indicates whether Elastic Fabric Adapter (EFA) is supported.
     */
    public Boolean efaSupported() {
        return efaSupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(maximumNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(ipv4AddressesPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressesPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Supported());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(efaSupported());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInfo)) {
            return false;
        }
        NetworkInfo other = (NetworkInfo) obj;
        return Objects.equals(networkPerformance(), other.networkPerformance())
                && Objects.equals(maximumNetworkInterfaces(), other.maximumNetworkInterfaces())
                && Objects.equals(ipv4AddressesPerInterface(), other.ipv4AddressesPerInterface())
                && Objects.equals(ipv6AddressesPerInterface(), other.ipv6AddressesPerInterface())
                && Objects.equals(ipv6Supported(), other.ipv6Supported())
                && Objects.equals(enaSupportAsString(), other.enaSupportAsString())
                && Objects.equals(efaSupported(), other.efaSupported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInfo").add("NetworkPerformance", networkPerformance())
                .add("MaximumNetworkInterfaces", maximumNetworkInterfaces())
                .add("Ipv4AddressesPerInterface", ipv4AddressesPerInterface())
                .add("Ipv6AddressesPerInterface", ipv6AddressesPerInterface()).add("Ipv6Supported", ipv6Supported())
                .add("EnaSupport", enaSupportAsString()).add("EfaSupported", efaSupported()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkPerformance":
            return Optional.ofNullable(clazz.cast(networkPerformance()));
        case "MaximumNetworkInterfaces":
            return Optional.ofNullable(clazz.cast(maximumNetworkInterfaces()));
        case "Ipv4AddressesPerInterface":
            return Optional.ofNullable(clazz.cast(ipv4AddressesPerInterface()));
        case "Ipv6AddressesPerInterface":
            return Optional.ofNullable(clazz.cast(ipv6AddressesPerInterface()));
        case "Ipv6Supported":
            return Optional.ofNullable(clazz.cast(ipv6Supported()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupportAsString()));
        case "EfaSupported":
            return Optional.ofNullable(clazz.cast(efaSupported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInfo, T> g) {
        return obj -> g.apply((NetworkInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInfo> {
        /**
         * <p>
         * Describes the network performance.
         * </p>
         * 
         * @param networkPerformance
         *        Describes the network performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPerformance(String networkPerformance);

        /**
         * <p>
         * The maximum number of network interfaces for the instance type.
         * </p>
         * 
         * @param maximumNetworkInterfaces
         *        The maximum number of network interfaces for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces);

        /**
         * <p>
         * The maximum number of IPv4 addresses per network interface.
         * </p>
         * 
         * @param ipv4AddressesPerInterface
         *        The maximum number of IPv4 addresses per network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4AddressesPerInterface(Integer ipv4AddressesPerInterface);

        /**
         * <p>
         * The maximum number of IPv6 addresses per network interface.
         * </p>
         * 
         * @param ipv6AddressesPerInterface
         *        The maximum number of IPv6 addresses per network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressesPerInterface(Integer ipv6AddressesPerInterface);

        /**
         * <p>
         * Indicates whether IPv6 is supported.
         * </p>
         * 
         * @param ipv6Supported
         *        Indicates whether IPv6 is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Supported(Boolean ipv6Supported);

        /**
         * <p>
         * Indicates whether Elastic Network Adapter (ENA) is supported.
         * </p>
         * 
         * @param enaSupport
         *        Indicates whether Elastic Network Adapter (ENA) is supported.
         * @see EnaSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnaSupport
         */
        Builder enaSupport(String enaSupport);

        /**
         * <p>
         * Indicates whether Elastic Network Adapter (ENA) is supported.
         * </p>
         * 
         * @param enaSupport
         *        Indicates whether Elastic Network Adapter (ENA) is supported.
         * @see EnaSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnaSupport
         */
        Builder enaSupport(EnaSupport enaSupport);

        /**
         * <p>
         * Indicates whether Elastic Fabric Adapter (EFA) is supported.
         * </p>
         * 
         * @param efaSupported
         *        Indicates whether Elastic Fabric Adapter (EFA) is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efaSupported(Boolean efaSupported);
    }

    static final class BuilderImpl implements Builder {
        private String networkPerformance;

        private Integer maximumNetworkInterfaces;

        private Integer ipv4AddressesPerInterface;

        private Integer ipv6AddressesPerInterface;

        private Boolean ipv6Supported;

        private String enaSupport;

        private Boolean efaSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInfo model) {
            networkPerformance(model.networkPerformance);
            maximumNetworkInterfaces(model.maximumNetworkInterfaces);
            ipv4AddressesPerInterface(model.ipv4AddressesPerInterface);
            ipv6AddressesPerInterface(model.ipv6AddressesPerInterface);
            ipv6Supported(model.ipv6Supported);
            enaSupport(model.enaSupport);
            efaSupported(model.efaSupported);
        }

        public final String getNetworkPerformance() {
            return networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        public final Integer getMaximumNetworkInterfaces() {
            return maximumNetworkInterfaces;
        }

        @Override
        public final Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
            return this;
        }

        public final void setMaximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
        }

        public final Integer getIpv4AddressesPerInterface() {
            return ipv4AddressesPerInterface;
        }

        @Override
        public final Builder ipv4AddressesPerInterface(Integer ipv4AddressesPerInterface) {
            this.ipv4AddressesPerInterface = ipv4AddressesPerInterface;
            return this;
        }

        public final void setIpv4AddressesPerInterface(Integer ipv4AddressesPerInterface) {
            this.ipv4AddressesPerInterface = ipv4AddressesPerInterface;
        }

        public final Integer getIpv6AddressesPerInterface() {
            return ipv6AddressesPerInterface;
        }

        @Override
        public final Builder ipv6AddressesPerInterface(Integer ipv6AddressesPerInterface) {
            this.ipv6AddressesPerInterface = ipv6AddressesPerInterface;
            return this;
        }

        public final void setIpv6AddressesPerInterface(Integer ipv6AddressesPerInterface) {
            this.ipv6AddressesPerInterface = ipv6AddressesPerInterface;
        }

        public final Boolean getIpv6Supported() {
            return ipv6Supported;
        }

        @Override
        public final Builder ipv6Supported(Boolean ipv6Supported) {
            this.ipv6Supported = ipv6Supported;
            return this;
        }

        public final void setIpv6Supported(Boolean ipv6Supported) {
            this.ipv6Supported = ipv6Supported;
        }

        public final String getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(String enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        @Override
        public final Builder enaSupport(EnaSupport enaSupport) {
            this.enaSupport(enaSupport == null ? null : enaSupport.toString());
            return this;
        }

        public final void setEnaSupport(String enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Boolean getEfaSupported() {
            return efaSupported;
        }

        @Override
        public final Builder efaSupported(Boolean efaSupported) {
            this.efaSupported = efaSupported;
            return this;
        }

        public final void setEfaSupported(Boolean efaSupported) {
            this.efaSupported = efaSupported;
        }

        @Override
        public NetworkInfo build() {
            return new NetworkInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
