/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subnet implements SdkPojo, Serializable, ToCopyableBuilder<Subnet.Builder, Subnet> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(Subnet::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(Subnet::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<Integer> AVAILABLE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableIpAddressCount")
            .getter(getter(Subnet::availableIpAddressCount))
            .setter(setter(Builder::availableIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableIpAddressCount")
                    .unmarshallLocationName("availableIpAddressCount").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock")
            .getter(getter(Subnet::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("cidrBlock").build()).build();

    private static final SdkField<Boolean> DEFAULT_FOR_AZ_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultForAz")
            .getter(getter(Subnet::defaultForAz))
            .setter(setter(Builder::defaultForAz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultForAz")
                    .unmarshallLocationName("defaultForAz").build()).build();

    private static final SdkField<Boolean> MAP_PUBLIC_IP_ON_LAUNCH_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MapPublicIpOnLaunch")
            .getter(getter(Subnet::mapPublicIpOnLaunch))
            .setter(setter(Builder::mapPublicIpOnLaunch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapPublicIpOnLaunch")
                    .unmarshallLocationName("mapPublicIpOnLaunch").build()).build();

    private static final SdkField<Boolean> MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MapCustomerOwnedIpOnLaunch")
            .getter(getter(Subnet::mapCustomerOwnedIpOnLaunch))
            .setter(setter(Builder::mapCustomerOwnedIpOnLaunch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapCustomerOwnedIpOnLaunch")
                    .unmarshallLocationName("mapCustomerOwnedIpOnLaunch").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIpv4Pool")
            .getter(getter(Subnet::customerOwnedIpv4Pool))
            .setter(setter(Builder::customerOwnedIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool")
                    .unmarshallLocationName("customerOwnedIpv4Pool").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(Subnet::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(Subnet::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(Subnet::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(Subnet::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<Boolean> ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssignIpv6AddressOnCreation")
            .getter(getter(Subnet::assignIpv6AddressOnCreation))
            .setter(setter(Builder::assignIpv6AddressOnCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignIpv6AddressOnCreation")
                    .unmarshallLocationName("assignIpv6AddressOnCreation").build()).build();

    private static final SdkField<List<SubnetIpv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField
            .<List<SubnetIpv6CidrBlockAssociation>> builder(MarshallingType.LIST)
            .memberName("Ipv6CidrBlockAssociationSet")
            .getter(getter(Subnet::ipv6CidrBlockAssociationSet))
            .setter(setter(Builder::ipv6CidrBlockAssociationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet")
                    .unmarshallLocationName("ipv6CidrBlockAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SubnetIpv6CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetIpv6CidrBlockAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Subnet::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetArn")
            .getter(getter(Subnet::subnetArn))
            .setter(setter(Builder::subnetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn")
                    .unmarshallLocationName("subnetArn").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(Subnet::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, AVAILABLE_IP_ADDRESS_COUNT_FIELD, CIDR_BLOCK_FIELD, DEFAULT_FOR_AZ_FIELD,
            MAP_PUBLIC_IP_ON_LAUNCH_FIELD, MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, STATE_FIELD,
            SUBNET_ID_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD, ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD,
            IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD, TAGS_FIELD, SUBNET_ARN_FIELD, OUTPOST_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Integer availableIpAddressCount;

    private final String cidrBlock;

    private final Boolean defaultForAz;

    private final Boolean mapPublicIpOnLaunch;

    private final Boolean mapCustomerOwnedIpOnLaunch;

    private final String customerOwnedIpv4Pool;

    private final String state;

    private final String subnetId;

    private final String vpcId;

    private final String ownerId;

    private final Boolean assignIpv6AddressOnCreation;

    private final List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private final List<Tag> tags;

    private final String subnetArn;

    private final String outpostArn;

    private Subnet(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availableIpAddressCount = builder.availableIpAddressCount;
        this.cidrBlock = builder.cidrBlock;
        this.defaultForAz = builder.defaultForAz;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.mapCustomerOwnedIpOnLaunch = builder.mapCustomerOwnedIpOnLaunch;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.tags = builder.tags;
        this.subnetArn = builder.subnetArn;
        this.outpostArn = builder.outpostArn;
    }

    /**
     * <p>
     * The Availability Zone of the subnet.
     * </p>
     * 
     * @return The Availability Zone of the subnet.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AZ ID of the subnet.
     * </p>
     * 
     * @return The AZ ID of the subnet.
     */
    public String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any stopped instances are
     * considered unavailable.
     * </p>
     * 
     * @return The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any stopped instances
     *         are considered unavailable.
     */
    public Integer availableIpAddressCount() {
        return availableIpAddressCount;
    }

    /**
     * <p>
     * The IPv4 CIDR block assigned to the subnet.
     * </p>
     * 
     * @return The IPv4 CIDR block assigned to the subnet.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Indicates whether this is the default subnet for the Availability Zone.
     * </p>
     * 
     * @return Indicates whether this is the default subnet for the Availability Zone.
     */
    public Boolean defaultForAz() {
        return defaultForAz;
    }

    /**
     * <p>
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     * </p>
     * 
     * @return Indicates whether instances launched in this subnet receive a public IPv4 address.
     */
    public Boolean mapPublicIpOnLaunch() {
        return mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * Indicates whether a network interface created in this subnet (including a network interface created by
     * <a>RunInstances</a>) receives a customer-owned IPv4 address.
     * </p>
     * 
     * @return Indicates whether a network interface created in this subnet (including a network interface created by
     *         <a>RunInstances</a>) receives a customer-owned IPv4 address.
     */
    public Boolean mapCustomerOwnedIpOnLaunch() {
        return mapCustomerOwnedIpOnLaunch;
    }

    /**
     * <p>
     * The customer-owned IPv4 address pool associated with the subnet.
     * </p>
     * 
     * @return The customer-owned IPv4 address pool associated with the subnet.
     */
    public String customerOwnedIpv4Pool() {
        return customerOwnedIpv4Pool;
    }

    /**
     * <p>
     * The current state of the subnet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SubnetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the subnet.
     * @see SubnetState
     */
    public SubnetState state() {
        return SubnetState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the subnet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SubnetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the subnet.
     * @see SubnetState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the VPC the subnet is in.
     * </p>
     * 
     * @return The ID of the VPC the subnet is in.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the subnet.
     * </p>
     * 
     * @return The ID of the AWS account that owns the subnet.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Indicates whether a network interface created in this subnet (including a network interface created by
     * <a>RunInstances</a>) receives an IPv6 address.
     * </p>
     * 
     * @return Indicates whether a network interface created in this subnet (including a network interface created by
     *         <a>RunInstances</a>) receives an IPv6 address.
     */
    public Boolean assignIpv6AddressOnCreation() {
        return assignIpv6AddressOnCreation;
    }

    /**
     * Returns true if the Ipv6CidrBlockAssociationSet property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasIpv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet != null && !(ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv6 CIDR blocks associated with the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6CidrBlockAssociationSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the IPv6 CIDR blocks associated with the subnet.
     */
    public List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the subnet.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the subnet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the subnet.
     */
    public String subnetArn() {
        return subnetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public String outpostArn() {
        return outpostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(availableIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(defaultForAz());
        hashCode = 31 * hashCode + Objects.hashCode(mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(mapCustomerOwnedIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockAssociationSet());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(subnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(availableIpAddressCount(), other.availableIpAddressCount())
                && Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(defaultForAz(), other.defaultForAz())
                && Objects.equals(mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch())
                && Objects.equals(mapCustomerOwnedIpOnLaunch(), other.mapCustomerOwnedIpOnLaunch())
                && Objects.equals(customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation())
                && Objects.equals(ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet())
                && Objects.equals(tags(), other.tags()) && Objects.equals(subnetArn(), other.subnetArn())
                && Objects.equals(outpostArn(), other.outpostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Subnet").add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("AvailableIpAddressCount", availableIpAddressCount())
                .add("CidrBlock", cidrBlock()).add("DefaultForAz", defaultForAz())
                .add("MapPublicIpOnLaunch", mapPublicIpOnLaunch())
                .add("MapCustomerOwnedIpOnLaunch", mapCustomerOwnedIpOnLaunch())
                .add("CustomerOwnedIpv4Pool", customerOwnedIpv4Pool()).add("State", stateAsString()).add("SubnetId", subnetId())
                .add("VpcId", vpcId()).add("OwnerId", ownerId())
                .add("AssignIpv6AddressOnCreation", assignIpv6AddressOnCreation())
                .add("Ipv6CidrBlockAssociationSet", ipv6CidrBlockAssociationSet()).add("Tags", tags())
                .add("SubnetArn", subnetArn()).add("OutpostArn", outpostArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "AvailableIpAddressCount":
            return Optional.ofNullable(clazz.cast(availableIpAddressCount()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "DefaultForAz":
            return Optional.ofNullable(clazz.cast(defaultForAz()));
        case "MapPublicIpOnLaunch":
            return Optional.ofNullable(clazz.cast(mapPublicIpOnLaunch()));
        case "MapCustomerOwnedIpOnLaunch":
            return Optional.ofNullable(clazz.cast(mapCustomerOwnedIpOnLaunch()));
        case "CustomerOwnedIpv4Pool":
            return Optional.ofNullable(clazz.cast(customerOwnedIpv4Pool()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "AssignIpv6AddressOnCreation":
            return Optional.ofNullable(clazz.cast(assignIpv6AddressOnCreation()));
        case "Ipv6CidrBlockAssociationSet":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockAssociationSet()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SubnetArn":
            return Optional.ofNullable(clazz.cast(subnetArn()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subnet> {
        /**
         * <p>
         * The Availability Zone of the subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AZ ID of the subnet.
         * </p>
         * 
         * @param availabilityZoneId
         *        The AZ ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any stopped instances are
         * considered unavailable.
         * </p>
         * 
         * @param availableIpAddressCount
         *        The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any stopped
         *        instances are considered unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableIpAddressCount(Integer availableIpAddressCount);

        /**
         * <p>
         * The IPv4 CIDR block assigned to the subnet.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Indicates whether this is the default subnet for the Availability Zone.
         * </p>
         * 
         * @param defaultForAz
         *        Indicates whether this is the default subnet for the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultForAz(Boolean defaultForAz);

        /**
         * <p>
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         * </p>
         * 
         * @param mapPublicIpOnLaunch
         *        Indicates whether instances launched in this subnet receive a public IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch);

        /**
         * <p>
         * Indicates whether a network interface created in this subnet (including a network interface created by
         * <a>RunInstances</a>) receives a customer-owned IPv4 address.
         * </p>
         * 
         * @param mapCustomerOwnedIpOnLaunch
         *        Indicates whether a network interface created in this subnet (including a network interface created by
         *        <a>RunInstances</a>) receives a customer-owned IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapCustomerOwnedIpOnLaunch(Boolean mapCustomerOwnedIpOnLaunch);

        /**
         * <p>
         * The customer-owned IPv4 address pool associated with the subnet.
         * </p>
         * 
         * @param customerOwnedIpv4Pool
         *        The customer-owned IPv4 address pool associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool);

        /**
         * <p>
         * The current state of the subnet.
         * </p>
         * 
         * @param state
         *        The current state of the subnet.
         * @see SubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the subnet.
         * </p>
         * 
         * @param state
         *        The current state of the subnet.
         * @see SubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetState
         */
        Builder state(SubnetState state);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the VPC the subnet is in.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC the subnet is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the AWS account that owns the subnet.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that owns the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Indicates whether a network interface created in this subnet (including a network interface created by
         * <a>RunInstances</a>) receives an IPv6 address.
         * </p>
         * 
         * @param assignIpv6AddressOnCreation
         *        Indicates whether a network interface created in this subnet (including a network interface created by
         *        <a>RunInstances</a>) receives an IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubnetIpv6CidrBlockAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<SubnetIpv6CidrBlockAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubnetIpv6CidrBlockAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #ipv6CidrBlockAssociationSet(List<SubnetIpv6CidrBlockAssociation>)}.
         * 
         * @param ipv6CidrBlockAssociationSet
         *        a consumer that will call methods on {@link List<SubnetIpv6CidrBlockAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockAssociationSet(List<SubnetIpv6CidrBlockAssociation>)
         */
        Builder ipv6CidrBlockAssociationSet(Consumer<SubnetIpv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Any tags assigned to the subnet.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the subnet.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the subnet.
         * </p>
         * 
         * @param subnetArn
         *        The Amazon Resource Name (ARN) of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArn(String subnetArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String availabilityZoneId;

        private Integer availableIpAddressCount;

        private String cidrBlock;

        private Boolean defaultForAz;

        private Boolean mapPublicIpOnLaunch;

        private Boolean mapCustomerOwnedIpOnLaunch;

        private String customerOwnedIpv4Pool;

        private String state;

        private String subnetId;

        private String vpcId;

        private String ownerId;

        private Boolean assignIpv6AddressOnCreation;

        private List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String subnetArn;

        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            availableIpAddressCount(model.availableIpAddressCount);
            cidrBlock(model.cidrBlock);
            defaultForAz(model.defaultForAz);
            mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            mapCustomerOwnedIpOnLaunch(model.mapCustomerOwnedIpOnLaunch);
            customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            state(model.state);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            ownerId(model.ownerId);
            assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            tags(model.tags);
            subnetArn(model.subnetArn);
            outpostArn(model.outpostArn);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final Integer getAvailableIpAddressCount() {
            return availableIpAddressCount;
        }

        @Override
        public final Builder availableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public final void setAvailableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getDefaultForAz() {
            return defaultForAz;
        }

        @Override
        public final Builder defaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
            return this;
        }

        public final void setDefaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        public final Boolean getMapCustomerOwnedIpOnLaunch() {
            return mapCustomerOwnedIpOnLaunch;
        }

        @Override
        public final Builder mapCustomerOwnedIpOnLaunch(Boolean mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch;
            return this;
        }

        public final void setMapCustomerOwnedIpOnLaunch(Boolean mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SubnetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        public final Collection<SubnetIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            return ipv6CidrBlockAssociationSet != null ? ipv6CidrBlockAssociationSet.stream()
                    .map(SubnetIpv6CidrBlockAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(
                Consumer<SubnetIpv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet)
                    .map(c -> SubnetIpv6CidrBlockAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(
                Collection<SubnetIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier
                    .copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getSubnetArn() {
            return subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public Subnet build() {
            return new Subnet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
