/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignIpv6AddressesResponse extends Ec2Response implements
        ToCopyableBuilder<AssignIpv6AddressesResponse.Builder, AssignIpv6AddressesResponse> {
    private static final SdkField<List<String>> ASSIGNED_IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssignedIpv6Addresses")
            .getter(getter(AssignIpv6AddressesResponse::assignedIpv6Addresses))
            .setter(setter(Builder::assignedIpv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedIpv6Addresses")
                    .unmarshallLocationName("assignedIpv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ASSIGNED_IPV6_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssignedIpv6Prefixes")
            .getter(getter(AssignIpv6AddressesResponse::assignedIpv6Prefixes))
            .setter(setter(Builder::assignedIpv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedIpv6PrefixSet")
                    .unmarshallLocationName("assignedIpv6PrefixSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssignIpv6AddressesResponse::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNED_IPV6_ADDRESSES_FIELD,
            ASSIGNED_IPV6_PREFIXES_FIELD, NETWORK_INTERFACE_ID_FIELD));

    private final List<String> assignedIpv6Addresses;

    private final List<String> assignedIpv6Prefixes;

    private final String networkInterfaceId;

    private AssignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.assignedIpv6Addresses = builder.assignedIpv6Addresses;
        this.assignedIpv6Prefixes = builder.assignedIpv6Prefixes;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssignedIpv6Addresses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssignedIpv6Addresses() {
        return assignedIpv6Addresses != null && !(assignedIpv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned to the
     * network interface before the request are not included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignedIpv6Addresses} method.
     * </p>
     * 
     * @return The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned to
     *         the network interface before the request are not included.
     */
    public final List<String> assignedIpv6Addresses() {
        return assignedIpv6Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssignedIpv6Prefixes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssignedIpv6Prefixes() {
        return assignedIpv6Prefixes != null && !(assignedIpv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 prefixes that are assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignedIpv6Prefixes} method.
     * </p>
     * 
     * @return The IPv6 prefixes that are assigned to the network interface.
     */
    public final List<String> assignedIpv6Prefixes() {
        return assignedIpv6Prefixes;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignedIpv6Addresses() ? assignedIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignedIpv6Prefixes() ? assignedIpv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesResponse)) {
            return false;
        }
        AssignIpv6AddressesResponse other = (AssignIpv6AddressesResponse) obj;
        return hasAssignedIpv6Addresses() == other.hasAssignedIpv6Addresses()
                && Objects.equals(assignedIpv6Addresses(), other.assignedIpv6Addresses())
                && hasAssignedIpv6Prefixes() == other.hasAssignedIpv6Prefixes()
                && Objects.equals(assignedIpv6Prefixes(), other.assignedIpv6Prefixes())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignIpv6AddressesResponse")
                .add("AssignedIpv6Addresses", hasAssignedIpv6Addresses() ? assignedIpv6Addresses() : null)
                .add("AssignedIpv6Prefixes", hasAssignedIpv6Prefixes() ? assignedIpv6Prefixes() : null)
                .add("NetworkInterfaceId", networkInterfaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignedIpv6Addresses":
            return Optional.ofNullable(clazz.cast(assignedIpv6Addresses()));
        case "AssignedIpv6Prefixes":
            return Optional.ofNullable(clazz.cast(assignedIpv6Prefixes()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignIpv6AddressesResponse, T> g) {
        return obj -> g.apply((AssignIpv6AddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AssignIpv6AddressesResponse> {
        /**
         * <p>
         * The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned to the
         * network interface before the request are not included.
         * </p>
         * 
         * @param assignedIpv6Addresses
         *        The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned
         *        to the network interface before the request are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses);

        /**
         * <p>
         * The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned to the
         * network interface before the request are not included.
         * </p>
         * 
         * @param assignedIpv6Addresses
         *        The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned
         *        to the network interface before the request are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Addresses(String... assignedIpv6Addresses);

        /**
         * <p>
         * The IPv6 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv6Prefixes
         *        The IPv6 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Prefixes(Collection<String> assignedIpv6Prefixes);

        /**
         * <p>
         * The IPv6 prefixes that are assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv6Prefixes
         *        The IPv6 prefixes that are assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Prefixes(String... assignedIpv6Prefixes);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<String> assignedIpv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> assignedIpv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesResponse model) {
            super(model);
            assignedIpv6Addresses(model.assignedIpv6Addresses);
            assignedIpv6Prefixes(model.assignedIpv6Prefixes);
            networkInterfaceId(model.networkInterfaceId);
        }

        public final Collection<String> getAssignedIpv6Addresses() {
            if (assignedIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return assignedIpv6Addresses;
        }

        public final void setAssignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
        }

        @Override
        public final Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Addresses(String... assignedIpv6Addresses) {
            assignedIpv6Addresses(Arrays.asList(assignedIpv6Addresses));
            return this;
        }

        public final Collection<String> getAssignedIpv6Prefixes() {
            if (assignedIpv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return assignedIpv6Prefixes;
        }

        public final void setAssignedIpv6Prefixes(Collection<String> assignedIpv6Prefixes) {
            this.assignedIpv6Prefixes = IpPrefixListCopier.copy(assignedIpv6Prefixes);
        }

        @Override
        public final Builder assignedIpv6Prefixes(Collection<String> assignedIpv6Prefixes) {
            this.assignedIpv6Prefixes = IpPrefixListCopier.copy(assignedIpv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Prefixes(String... assignedIpv6Prefixes) {
            assignedIpv6Prefixes(Arrays.asList(assignedIpv6Prefixes));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        @Override
        public AssignIpv6AddressesResponse build() {
            return new AssignIpv6AddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
