/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options when modifying a Verified Access endpoint with the <code>network-interface</code> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVerifiedAccessEndpointEniOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyVerifiedAccessEndpointEniOptions.Builder, ModifyVerifiedAccessEndpointEniOptions> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(ModifyVerifiedAccessEndpointEniOptions::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Port")
            .getter(getter(ModifyVerifiedAccessEndpointEniOptions::port))
            .setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port")
                    .unmarshallLocationName("Port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final Integer port;

    private ModifyVerifiedAccessEndpointEniOptions(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
    }

    /**
     * <p>
     * The IP protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VerifiedAccessEndpointProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The IP protocol.
     * @see VerifiedAccessEndpointProtocol
     */
    public final VerifiedAccessEndpointProtocol protocol() {
        return VerifiedAccessEndpointProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The IP protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VerifiedAccessEndpointProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The IP protocol.
     * @see VerifiedAccessEndpointProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The IP port number.
     * </p>
     * 
     * @return The IP port number.
     */
    public final Integer port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessEndpointEniOptions)) {
            return false;
        }
        ModifyVerifiedAccessEndpointEniOptions other = (ModifyVerifiedAccessEndpointEniOptions) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVerifiedAccessEndpointEniOptions").add("Protocol", protocolAsString()).add("Port", port())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessEndpointEniOptions, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessEndpointEniOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyVerifiedAccessEndpointEniOptions> {
        /**
         * <p>
         * The IP protocol.
         * </p>
         * 
         * @param protocol
         *        The IP protocol.
         * @see VerifiedAccessEndpointProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifiedAccessEndpointProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The IP protocol.
         * </p>
         * 
         * @param protocol
         *        The IP protocol.
         * @see VerifiedAccessEndpointProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifiedAccessEndpointProtocol
         */
        Builder protocol(VerifiedAccessEndpointProtocol protocol);

        /**
         * <p>
         * The IP port number.
         * </p>
         * 
         * @param port
         *        The IP port number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessEndpointEniOptions model) {
            protocol(model.protocol);
            port(model.port);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(VerifiedAccessEndpointProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Override
        public ModifyVerifiedAccessEndpointEniOptions build() {
            return new ModifyVerifiedAccessEndpointEniOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
