/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendSerialConsoleSshPublicKeyRequest extends Ec2InstanceConnectRequest implements
        ToCopyableBuilder<SendSerialConsoleSshPublicKeyRequest.Builder, SendSerialConsoleSshPublicKeyRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SendSerialConsoleSshPublicKeyRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Integer> SERIAL_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SerialPort").getter(getter(SendSerialConsoleSshPublicKeyRequest::serialPort))
            .setter(setter(Builder::serialPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialPort").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SSHPublicKey").getter(getter(SendSerialConsoleSshPublicKeyRequest::sshPublicKey))
            .setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            SERIAL_PORT_FIELD, SSH_PUBLIC_KEY_FIELD));

    private final String instanceId;

    private final Integer serialPort;

    private final String sshPublicKey;

    private SendSerialConsoleSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.serialPort = builder.serialPort;
        this.sshPublicKey = builder.sshPublicKey;
    }

    /**
     * <p>
     * The ID of the EC2 instance.
     * </p>
     * 
     * @return The ID of the EC2 instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The serial port of the EC2 instance. Currently only port 0 is supported.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return The serial port of the EC2 instance. Currently only port 0 is supported.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer serialPort() {
        return serialPort;
    }

    /**
     * <p>
     * The public key material. To use the public key, you must have the matching private key. For information about the
     * supported key formats and lengths, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws"
     * >Requirements for key pairs</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The public key material. To use the public key, you must have the matching private key. For information
     *         about the supported key formats and lengths, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws"
     *         >Requirements for key pairs</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String sshPublicKey() {
        return sshPublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(serialPort());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendSerialConsoleSshPublicKeyRequest)) {
            return false;
        }
        SendSerialConsoleSshPublicKeyRequest other = (SendSerialConsoleSshPublicKeyRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(serialPort(), other.serialPort())
                && Objects.equals(sshPublicKey(), other.sshPublicKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendSerialConsoleSshPublicKeyRequest").add("InstanceId", instanceId())
                .add("SerialPort", serialPort()).add("SSHPublicKey", sshPublicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SerialPort":
            return Optional.ofNullable(clazz.cast(serialPort()));
        case "SSHPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendSerialConsoleSshPublicKeyRequest, T> g) {
        return obj -> g.apply((SendSerialConsoleSshPublicKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2InstanceConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendSerialConsoleSshPublicKeyRequest> {
        /**
         * <p>
         * The ID of the EC2 instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The serial port of the EC2 instance. Currently only port 0 is supported.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param serialPort
         *        The serial port of the EC2 instance. Currently only port 0 is supported.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialPort(Integer serialPort);

        /**
         * <p>
         * The public key material. To use the public key, you must have the matching private key. For information about
         * the supported key formats and lengths, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws"
         * >Requirements for key pairs</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param sshPublicKey
         *        The public key material. To use the public key, you must have the matching private key. For
         *        information about the supported key formats and lengths, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html#how-to-generate-your-own-key-and-import-it-to-aws"
         *        >Requirements for key pairs</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2InstanceConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Integer serialPort;

        private String sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SendSerialConsoleSshPublicKeyRequest model) {
            super(model);
            instanceId(model.instanceId);
            serialPort(model.serialPort);
            sshPublicKey(model.sshPublicKey);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getSerialPort() {
            return serialPort;
        }

        public final void setSerialPort(Integer serialPort) {
            this.serialPort = serialPort;
        }

        @Override
        public final Builder serialPort(Integer serialPort) {
            this.serialPort = serialPort;
            return this;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendSerialConsoleSshPublicKeyRequest build() {
            return new SendSerialConsoleSshPublicKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
