/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about any failures associated with the scanning configuration of a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryScanningConfigurationFailure implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryScanningConfigurationFailure.Builder, RepositoryScanningConfigurationFailure> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(RepositoryScanningConfigurationFailure::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(RepositoryScanningConfigurationFailure::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(RepositoryScanningConfigurationFailure::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            FAILURE_CODE_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String failureCode;

    private final String failureReason;

    private RepositoryScanningConfigurationFailure(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link ScanningConfigurationFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code.
     * @see ScanningConfigurationFailureCode
     */
    public final ScanningConfigurationFailureCode failureCode() {
        return ScanningConfigurationFailureCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link ScanningConfigurationFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code.
     * @see ScanningConfigurationFailureCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The reason for the failure.
     * </p>
     * 
     * @return The reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryScanningConfigurationFailure)) {
            return false;
        }
        RepositoryScanningConfigurationFailure other = (RepositoryScanningConfigurationFailure) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryScanningConfigurationFailure").add("RepositoryName", repositoryName())
                .add("FailureCode", failureCodeAsString()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryScanningConfigurationFailure, T> g) {
        return obj -> g.apply((RepositoryScanningConfigurationFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryScanningConfigurationFailure> {
        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @see ScanningConfigurationFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanningConfigurationFailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @see ScanningConfigurationFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanningConfigurationFailureCode
         */
        Builder failureCode(ScanningConfigurationFailureCode failureCode);

        /**
         * <p>
         * The reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        The reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String failureCode;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryScanningConfigurationFailure model) {
            repositoryName(model.repositoryName);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(ScanningConfigurationFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public RepositoryScanningConfigurationFailure build() {
            return new RepositoryScanningConfigurationFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
