/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemResponse extends EfsResponse implements
        ToCopyableBuilder<CreateFileSystemResponse.Builder, CreateFileSystemResponse> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(CreateFileSystemResponse::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationToken").getter(getter(CreateFileSystemResponse::creationToken))
            .setter(setter(Builder::creationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationToken").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(CreateFileSystemResponse::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemArn").getter(getter(CreateFileSystemResponse::fileSystemArn))
            .setter(setter(Builder::fileSystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CreateFileSystemResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifeCycleState").getter(getter(CreateFileSystemResponse::lifeCycleStateAsString))
            .setter(setter(Builder::lifeCycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFileSystemResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> NUMBER_OF_MOUNT_TARGETS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfMountTargets").getter(getter(CreateFileSystemResponse::numberOfMountTargets))
            .setter(setter(Builder::numberOfMountTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMountTargets").build())
            .build();

    private static final SdkField<FileSystemSize> SIZE_IN_BYTES_FIELD = SdkField
            .<FileSystemSize> builder(MarshallingType.SDK_POJO).memberName("SizeInBytes")
            .getter(getter(CreateFileSystemResponse::sizeInBytes)).setter(setter(Builder::sizeInBytes))
            .constructor(FileSystemSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()).build();

    private static final SdkField<String> PERFORMANCE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PerformanceMode").getter(getter(CreateFileSystemResponse::performanceModeAsString))
            .setter(setter(Builder::performanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceMode").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(CreateFileSystemResponse::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateFileSystemResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThroughputMode").getter(getter(CreateFileSystemResponse::throughputModeAsString))
            .setter(setter(Builder::throughputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()).build();

    private static final SdkField<Double> PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("ProvisionedThroughputInMibps")
            .getter(getter(CreateFileSystemResponse::provisionedThroughputInMibps))
            .setter(setter(Builder::provisionedThroughputInMibps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputInMibps")
                    .build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneName").getter(getter(CreateFileSystemResponse::availabilityZoneName))
            .setter(setter(Builder::availabilityZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId").getter(getter(CreateFileSystemResponse::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFileSystemResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FileSystemProtectionDescription> FILE_SYSTEM_PROTECTION_FIELD = SdkField
            .<FileSystemProtectionDescription> builder(MarshallingType.SDK_POJO).memberName("FileSystemProtection")
            .getter(getter(CreateFileSystemResponse::fileSystemProtection)).setter(setter(Builder::fileSystemProtection))
            .constructor(FileSystemProtectionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            CREATION_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, FILE_SYSTEM_ARN_FIELD, CREATION_TIME_FIELD, LIFE_CYCLE_STATE_FIELD,
            NAME_FIELD, NUMBER_OF_MOUNT_TARGETS_FIELD, SIZE_IN_BYTES_FIELD, PERFORMANCE_MODE_FIELD, ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD, THROUGHPUT_MODE_FIELD, PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD, AVAILABILITY_ZONE_NAME_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD, FILE_SYSTEM_PROTECTION_FIELD));

    private final String ownerId;

    private final String creationToken;

    private final String fileSystemId;

    private final String fileSystemArn;

    private final Instant creationTime;

    private final String lifeCycleState;

    private final String name;

    private final Integer numberOfMountTargets;

    private final FileSystemSize sizeInBytes;

    private final String performanceMode;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String throughputMode;

    private final Double provisionedThroughputInMibps;

    private final String availabilityZoneName;

    private final String availabilityZoneId;

    private final List<Tag> tags;

    private final FileSystemProtectionDescription fileSystemProtection;

    private CreateFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.ownerId = builder.ownerId;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemArn = builder.fileSystemArn;
        this.creationTime = builder.creationTime;
        this.lifeCycleState = builder.lifeCycleState;
        this.name = builder.name;
        this.numberOfMountTargets = builder.numberOfMountTargets;
        this.sizeInBytes = builder.sizeInBytes;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
        this.availabilityZoneName = builder.availabilityZoneName;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
        this.fileSystemProtection = builder.fileSystemProtection;
    }

    /**
     * <p>
     * The Amazon Web Services account that created the file system.
     * </p>
     * 
     * @return The Amazon Web Services account that created the file system.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The opaque string specified in the request.
     * </p>
     * 
     * @return The opaque string specified in the request.
     */
    public final String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * The ID of the file system, assigned by Amazon EFS.
     * </p>
     * 
     * @return The ID of the file system, assigned by Amazon EFS.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the EFS file system, in the format
     * <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>.
     * Example with sample data:
     * <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the EFS file system, in the format
     *         <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>
     *         . Example with sample data:
     *         <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code>
     */
    public final String fileSystemArn() {
        return fileSystemArn;
    }

    /**
     * <p>
     * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
     * </p>
     * 
     * @return The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The lifecycle phase of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle phase of the file system.
     * @see LifeCycleState
     */
    public final LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(lifeCycleState);
    }

    /**
     * <p>
     * The lifecycle phase of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle phase of the file system.
     * @see LifeCycleState
     */
    public final String lifeCycleStateAsString() {
        return lifeCycleState;
    }

    /**
     * <p>
     * You can add tags to a file system, including a <code>Name</code> tag. For more information, see
     * <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this
     * field.
     * </p>
     * 
     * @return You can add tags to a file system, including a <code>Name</code> tag. For more information, see
     *         <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in
     *         this field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current number of mount targets that the file system has. For more information, see <a>CreateMountTarget</a>.
     * </p>
     * 
     * @return The current number of mount targets that the file system has. For more information, see
     *         <a>CreateMountTarget</a>.
     */
    public final Integer numberOfMountTargets() {
        return numberOfMountTargets;
    }

    /**
     * <p>
     * The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and
     * the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value
     * is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent
     * the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to
     * the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified
     * for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was
     * at any point in time.
     * </p>
     * 
     * @return The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code>
     *         field, and the time at which that size was determined in its <code>Timestamp</code> field. The
     *         <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
     *         <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system,
     *         but it is eventually consistent when there are no writes to the file system. That is,
     *         <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period
     *         longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any
     *         point in time.
     */
    public final FileSystemSize sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The Performance mode of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeAsString}.
     * </p>
     * 
     * @return The Performance mode of the file system.
     * @see PerformanceMode
     */
    public final PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(performanceMode);
    }

    /**
     * <p>
     * The Performance mode of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeAsString}.
     * </p>
     * 
     * @return The Performance mode of the file system.
     * @see PerformanceMode
     */
    public final String performanceModeAsString() {
        return performanceMode;
    }

    /**
     * <p>
     * A Boolean value that, if true, indicates that the file system is encrypted.
     * </p>
     * 
     * @return A Boolean value that, if true, indicates that the file system is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The ID of an KMS key used to protect the encrypted file system.
     * </p>
     * 
     * @return The ID of an KMS key used to protect the encrypted file system.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Displays the file system's throughput mode. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the
     * <i>Amazon EFS User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return Displays the file system's throughput mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a>
     *         in the <i>Amazon EFS User Guide</i>.
     * @see ThroughputMode
     */
    public final ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(throughputMode);
    }

    /**
     * <p>
     * Displays the file system's throughput mode. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the
     * <i>Amazon EFS User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return Displays the file system's throughput mode. For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a>
     *         in the <i>Amazon EFS User Guide</i>.
     * @see ThroughputMode
     */
    public final String throughputModeAsString() {
        return throughputMode;
    }

    /**
     * <p>
     * The amount of provisioned throughput, measured in MiBps, for the file system. Valid for file systems using
     * <code>ThroughputMode</code> set to <code>provisioned</code>.
     * </p>
     * 
     * @return The amount of provisioned throughput, measured in MiBps, for the file system. Valid for file systems
     *         using <code>ThroughputMode</code> set to <code>provisioned</code>.
     */
    public final Double provisionedThroughputInMibps() {
        return provisionedThroughputInMibps;
    }

    /**
     * <p>
     * Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for
     * One Zone file systems. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the
     * <i>Amazon EFS User Guide</i>.
     * </p>
     * 
     * @return Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid
     *         only for One Zone file systems. For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in
     *         the <i>Amazon EFS User Guide</i>.
     */
    public final String availabilityZoneName() {
        return availabilityZoneName;
    }

    /**
     * <p>
     * The unique and consistent identifier of the Availability Zone in which the file system is located, and is valid
     * only for One Zone file systems. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1
     * Amazon Web Services Region, and it has the same location in every Amazon Web Services account.
     * </p>
     * 
     * @return The unique and consistent identifier of the Availability Zone in which the file system is located, and is
     *         valid only for One Zone file systems. For example, <code>use1-az1</code> is an Availability Zone ID for
     *         the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services
     *         account.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the file system, presented as an array of <code>Tag</code> objects.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Describes the protection on the file system.
     * </p>
     * 
     * @return Describes the protection on the file system.
     */
    public final FileSystemProtectionDescription fileSystemProtection() {
        return fileSystemProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputInMibps());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemResponse)) {
            return false;
        }
        CreateFileSystemResponse other = (CreateFileSystemResponse) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(creationToken(), other.creationToken())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(fileSystemArn(), other.fileSystemArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lifeCycleStateAsString(), other.lifeCycleStateAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(numberOfMountTargets(), other.numberOfMountTargets())
                && Objects.equals(sizeInBytes(), other.sizeInBytes())
                && Objects.equals(performanceModeAsString(), other.performanceModeAsString())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(throughputModeAsString(), other.throughputModeAsString())
                && Objects.equals(provisionedThroughputInMibps(), other.provisionedThroughputInMibps())
                && Objects.equals(availabilityZoneName(), other.availabilityZoneName())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(fileSystemProtection(), other.fileSystemProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFileSystemResponse").add("OwnerId", ownerId()).add("CreationToken", creationToken())
                .add("FileSystemId", fileSystemId()).add("FileSystemArn", fileSystemArn()).add("CreationTime", creationTime())
                .add("LifeCycleState", lifeCycleStateAsString()).add("Name", name())
                .add("NumberOfMountTargets", numberOfMountTargets()).add("SizeInBytes", sizeInBytes())
                .add("PerformanceMode", performanceModeAsString()).add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId())
                .add("ThroughputMode", throughputModeAsString())
                .add("ProvisionedThroughputInMibps", provisionedThroughputInMibps())
                .add("AvailabilityZoneName", availabilityZoneName()).add("AvailabilityZoneId", availabilityZoneId())
                .add("Tags", hasTags() ? tags() : null).add("FileSystemProtection", fileSystemProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CreationToken":
            return Optional.ofNullable(clazz.cast(creationToken()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "FileSystemArn":
            return Optional.ofNullable(clazz.cast(fileSystemArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LifeCycleState":
            return Optional.ofNullable(clazz.cast(lifeCycleStateAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NumberOfMountTargets":
            return Optional.ofNullable(clazz.cast(numberOfMountTargets()));
        case "SizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        case "PerformanceMode":
            return Optional.ofNullable(clazz.cast(performanceModeAsString()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ThroughputMode":
            return Optional.ofNullable(clazz.cast(throughputModeAsString()));
        case "ProvisionedThroughputInMibps":
            return Optional.ofNullable(clazz.cast(provisionedThroughputInMibps()));
        case "AvailabilityZoneName":
            return Optional.ofNullable(clazz.cast(availabilityZoneName()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FileSystemProtection":
            return Optional.ofNullable(clazz.cast(fileSystemProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemResponse, T> g) {
        return obj -> g.apply((CreateFileSystemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFileSystemResponse> {
        /**
         * <p>
         * The Amazon Web Services account that created the file system.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account that created the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The opaque string specified in the request.
         * </p>
         * 
         * @param creationToken
         *        The opaque string specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * The ID of the file system, assigned by Amazon EFS.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system, assigned by Amazon EFS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the EFS file system, in the format
         * <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>.
         * Example with sample data:
         * <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code>
         * </p>
         * 
         * @param fileSystemArn
         *        The Amazon Resource Name (ARN) for the EFS file system, in the format
         *        <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>
         *        . Example with sample data:
         *        <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemArn(String fileSystemArn);

        /**
         * <p>
         * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
         * </p>
         * 
         * @param creationTime
         *        The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The lifecycle phase of the file system.
         * </p>
         * 
         * @param lifeCycleState
         *        The lifecycle phase of the file system.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(String lifeCycleState);

        /**
         * <p>
         * The lifecycle phase of the file system.
         * </p>
         * 
         * @param lifeCycleState
         *        The lifecycle phase of the file system.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(LifeCycleState lifeCycleState);

        /**
         * <p>
         * You can add tags to a file system, including a <code>Name</code> tag. For more information, see
         * <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this
         * field.
         * </p>
         * 
         * @param name
         *        You can add tags to a file system, including a <code>Name</code> tag. For more information, see
         *        <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value
         *        in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current number of mount targets that the file system has. For more information, see
         * <a>CreateMountTarget</a>.
         * </p>
         * 
         * @param numberOfMountTargets
         *        The current number of mount targets that the file system has. For more information, see
         *        <a>CreateMountTarget</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMountTargets(Integer numberOfMountTargets);

        /**
         * <p>
         * The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field,
         * and the time at which that size was determined in its <code>Timestamp</code> field. The
         * <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
         * <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it
         * is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code>
         * represents actual size only if the file system is not modified for a period longer than a couple of hours.
         * Otherwise, the value is not the exact size that the file system was at any point in time.
         * </p>
         * 
         * @param sizeInBytes
         *        The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code>
         *        field, and the time at which that size was determined in its <code>Timestamp</code> field. The
         *        <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
         *        <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system,
         *        but it is eventually consistent when there are no writes to the file system. That is,
         *        <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period
         *        longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at
         *        any point in time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(FileSystemSize sizeInBytes);

        /**
         * <p>
         * The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field,
         * and the time at which that size was determined in its <code>Timestamp</code> field. The
         * <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
         * <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it
         * is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code>
         * represents actual size only if the file system is not modified for a period longer than a couple of hours.
         * Otherwise, the value is not the exact size that the file system was at any point in time.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSystemSize.Builder} avoiding the need
         * to create one manually via {@link FileSystemSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSystemSize.Builder#build()} is called immediately and its
         * result is passed to {@link #sizeInBytes(FileSystemSize)}.
         * 
         * @param sizeInBytes
         *        a consumer that will call methods on {@link FileSystemSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeInBytes(FileSystemSize)
         */
        default Builder sizeInBytes(Consumer<FileSystemSize.Builder> sizeInBytes) {
            return sizeInBytes(FileSystemSize.builder().applyMutation(sizeInBytes).build());
        }

        /**
         * <p>
         * The Performance mode of the file system.
         * </p>
         * 
         * @param performanceMode
         *        The Performance mode of the file system.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(String performanceMode);

        /**
         * <p>
         * The Performance mode of the file system.
         * </p>
         * 
         * @param performanceMode
         *        The Performance mode of the file system.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(PerformanceMode performanceMode);

        /**
         * <p>
         * A Boolean value that, if true, indicates that the file system is encrypted.
         * </p>
         * 
         * @param encrypted
         *        A Boolean value that, if true, indicates that the file system is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The ID of an KMS key used to protect the encrypted file system.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of an KMS key used to protect the encrypted file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Displays the file system's throughput mode. For more information, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in
         * the <i>Amazon EFS User Guide</i>.
         * </p>
         * 
         * @param throughputMode
         *        Displays the file system's throughput mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput
         *        modes</a> in the <i>Amazon EFS User Guide</i>.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(String throughputMode);

        /**
         * <p>
         * Displays the file system's throughput mode. For more information, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in
         * the <i>Amazon EFS User Guide</i>.
         * </p>
         * 
         * @param throughputMode
         *        Displays the file system's throughput mode. For more information, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput
         *        modes</a> in the <i>Amazon EFS User Guide</i>.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(ThroughputMode throughputMode);

        /**
         * <p>
         * The amount of provisioned throughput, measured in MiBps, for the file system. Valid for file systems using
         * <code>ThroughputMode</code> set to <code>provisioned</code>.
         * </p>
         * 
         * @param provisionedThroughputInMibps
         *        The amount of provisioned throughput, measured in MiBps, for the file system. Valid for file systems
         *        using <code>ThroughputMode</code> set to <code>provisioned</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps);

        /**
         * <p>
         * Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only
         * for One Zone file systems. For more information, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the
         * <i>Amazon EFS User Guide</i>.
         * </p>
         * 
         * @param availabilityZoneName
         *        Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid
         *        only for One Zone file systems. For more information, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in
         *        the <i>Amazon EFS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneName(String availabilityZoneName);

        /**
         * <p>
         * The unique and consistent identifier of the Availability Zone in which the file system is located, and is
         * valid only for One Zone file systems. For example, <code>use1-az1</code> is an Availability Zone ID for the
         * us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.
         * </p>
         * 
         * @param availabilityZoneId
         *        The unique and consistent identifier of the Availability Zone in which the file system is located, and
         *        is valid only for One Zone file systems. For example, <code>use1-az1</code> is an Availability Zone ID
         *        for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web
         *        Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * </p>
         * 
         * @param tags
         *        The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * </p>
         * 
         * @param tags
         *        The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.efs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.efs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.efs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.efs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Describes the protection on the file system.
         * </p>
         * 
         * @param fileSystemProtection
         *        Describes the protection on the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemProtection(FileSystemProtectionDescription fileSystemProtection);

        /**
         * <p>
         * Describes the protection on the file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSystemProtectionDescription.Builder}
         * avoiding the need to create one manually via {@link FileSystemProtectionDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSystemProtectionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #fileSystemProtection(FileSystemProtectionDescription)}.
         * 
         * @param fileSystemProtection
         *        a consumer that will call methods on {@link FileSystemProtectionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemProtection(FileSystemProtectionDescription)
         */
        default Builder fileSystemProtection(Consumer<FileSystemProtectionDescription.Builder> fileSystemProtection) {
            return fileSystemProtection(FileSystemProtectionDescription.builder().applyMutation(fileSystemProtection).build());
        }
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private String ownerId;

        private String creationToken;

        private String fileSystemId;

        private String fileSystemArn;

        private Instant creationTime;

        private String lifeCycleState;

        private String name;

        private Integer numberOfMountTargets;

        private FileSystemSize sizeInBytes;

        private String performanceMode;

        private Boolean encrypted;

        private String kmsKeyId;

        private String throughputMode;

        private Double provisionedThroughputInMibps;

        private String availabilityZoneName;

        private String availabilityZoneId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private FileSystemProtectionDescription fileSystemProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemResponse model) {
            super(model);
            ownerId(model.ownerId);
            creationToken(model.creationToken);
            fileSystemId(model.fileSystemId);
            fileSystemArn(model.fileSystemArn);
            creationTime(model.creationTime);
            lifeCycleState(model.lifeCycleState);
            name(model.name);
            numberOfMountTargets(model.numberOfMountTargets);
            sizeInBytes(model.sizeInBytes);
            performanceMode(model.performanceMode);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            throughputMode(model.throughputMode);
            provisionedThroughputInMibps(model.provisionedThroughputInMibps);
            availabilityZoneName(model.availabilityZoneName);
            availabilityZoneId(model.availabilityZoneId);
            tags(model.tags);
            fileSystemProtection(model.fileSystemProtection);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getCreationToken() {
            return creationToken;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getFileSystemArn() {
            return fileSystemArn;
        }

        public final void setFileSystemArn(String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
        }

        @Override
        public final Builder fileSystemArn(String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLifeCycleState() {
            return lifeCycleState;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getNumberOfMountTargets() {
            return numberOfMountTargets;
        }

        public final void setNumberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
        }

        @Override
        public final Builder numberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
            return this;
        }

        public final FileSystemSize.Builder getSizeInBytes() {
            return sizeInBytes != null ? sizeInBytes.toBuilder() : null;
        }

        public final void setSizeInBytes(FileSystemSize.BuilderImpl sizeInBytes) {
            this.sizeInBytes = sizeInBytes != null ? sizeInBytes.build() : null;
        }

        @Override
        public final Builder sizeInBytes(FileSystemSize sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final String getPerformanceMode() {
            return performanceMode;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode == null ? null : performanceMode.toString());
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getThroughputMode() {
            return throughputMode;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final Double getProvisionedThroughputInMibps() {
            return provisionedThroughputInMibps;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final String getAvailabilityZoneName() {
            return availabilityZoneName;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final FileSystemProtectionDescription.Builder getFileSystemProtection() {
            return fileSystemProtection != null ? fileSystemProtection.toBuilder() : null;
        }

        public final void setFileSystemProtection(FileSystemProtectionDescription.BuilderImpl fileSystemProtection) {
            this.fileSystemProtection = fileSystemProtection != null ? fileSystemProtection.build() : null;
        }

        @Override
        public final Builder fileSystemProtection(FileSystemProtectionDescription fileSystemProtection) {
            this.fileSystemProtection = fileSystemProtection;
            return this;
        }

        @Override
        public CreateFileSystemResponse build() {
            return new CreateFileSystemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
